/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.webservlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={"/Servlet2URL1", "/Servlet2URL2", "/test/*", "*.html"})
public class Servlet2 extends HttpServlet {

    public void service(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.write("Servlet2_INVOKED");
        
        pw.write("initParams: ");
        String name = null;
        String value = null;

        Enumeration names = getInitParameterNames();

        if (names.hasMoreElements()) {
            name = (String) names.nextElement();
            value = getInitParameter(name);
            pw.print(name + "=" + value);
        }
        
        pw.println("servletname=" + getServletName() + "END");
        pw.print("isAsyncSupported=" + request.isAsyncSupported()); 
    }
}
