/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ServletSecTestServlet.java 52684 2007-02-12 04:30:10Z lschwenk $
 */

package com.sun.ts.tests.servlet.spec.security.annotations;


import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.annotation.security.DeclareRoles;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.annotation.WebServlet;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.ServletSecurity.*;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.HttpConstraint;


/*
 * this declares several roles, specifies which roles are allowed, then
 * sets POST to DENYALL and sets GET TO PERMITALL.
 */
@DeclareRoles({"Administrator", "Manager", "Employee"})
@ServletSecurity(value=@HttpConstraint(rolesAllowed = {"Administrator" }),
        httpMethodConstraints = { @HttpMethodConstraint(value = "POST", emptyRoleSemantic = EmptyRoleSemantic.DENY),
                                  @HttpMethodConstraint(value = "GET", emptyRoleSemantic = EmptyRoleSemantic.PERMIT)
         })
@WebServlet("/ServletSecTest")
public class ServletSecTestServlet extends HttpServlet {

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        System.out.println("Inside  ServletSecTestServlet.service()  ....." + "<BR>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) 
           throws ServletException, java.io.IOException {

        PrintWriter out = response.getWriter();
        System.out.println("Inside  ServletSecTestServlet.doTrace() ....." + "<BR>");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response)
           throws ServletException, java.io.IOException {

        PrintWriter out = response.getWriter();
        System.out.println("Inside  ServletSecTestServlet.doGet() ....." + "<BR>");

        if ((request != null) && (request.getUserPrincipal() != null)) {
            out.println("The user principal is: " + request.getUserPrincipal().getName() + "<BR>");
        } else {
            out.println("The user principal is: Null."  + "<BR>");
        }

        if (request != null) {
            out.println("isUserInRole(\"ADM\"): !" + request.isUserInRole("ADM") + "!<BR>");
            out.println("isUserInRole(\"MGR\"): !" + request.isUserInRole("MGR") + "!<BR>");
            out.println("isUserInRole(\"EMP\"): !" + request.isUserInRole("EMP") + "!<BR>");
            out.println("isUserInRole(\"Administrator\"): !" + request.isUserInRole("Administrator") + "!<BR>");
        }

    }

}

