/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.util;

import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.facesconfig22.WebFacesConfigDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp31.WebAppDescriptor;

public class WebArchiveBuilder {
    private WebArchive archive;

    public WebArchiveBuilder() {
        this((WebArchive)ShrinkWrap.create(WebArchive.class));
    }

    public WebArchiveBuilder(WebArchive archive) {
        this.archive = archive;
    }

    public WebArchiveBuilder addClass(Class<?> clazz) {
        this.archive.addClass(clazz);
        return this;
    }

    public WebArchiveBuilder addClasses(Class<?> ... classes) {
        this.archive.addClasses((Class[])classes);
        return this;
    }

    public WebArchiveBuilder addView(Asset asset, String name) {
        this.archive.addAsWebInfResource(asset, "views/" + name);
        return this;
    }

    public WebArchiveBuilder addView(String value, String name) {
        return this.addView((Asset)new StringAsset(value), name);
    }

    public WebArchiveBuilder addView(String path) {
        return this.addView((Asset)new ClassLoaderAsset("views/" + path), path);
    }

    public WebArchiveBuilder addBeansXml(String discoveryMode) {
        return this.addBeansXml(((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).addDefaultNamespaces()).beanDiscoveryMode(discoveryMode));
    }

    public WebArchiveBuilder addBeansXml(BeansDescriptor descriptor) {
        String beans30Xml = descriptor.exportAsString().replace("http://xmlns.jcp.org/xml/ns/javaee", "https://jakarta.ee/xml/ns/jakartaee").replace("/beans_1_1.xsd", "/beans_3_0.xsd");
        this.archive.addAsWebInfResource((Asset)new StringAsset(descriptor.exportAsString()), "beans.xml");
        return this;
    }

    public WebArchiveBuilder withDefaultFaceConfig() {
        WebFacesConfigDescriptor descriptor = ((WebFacesConfigDescriptor)((WebFacesConfigDescriptor)Descriptors.create(WebFacesConfigDescriptor.class)).addDefaultNamespaces()).version("3.0");
        String faces30Version = descriptor.exportAsString().replace("http://xmlns.jcp.org/xml/ns/javaee", "https://jakarta.ee/xml/ns/jakartaee").replace("/web-facesconfig_2_2.xsd", "/web-facesconfig_3_0.xsd");
        this.archive.addAsWebInfResource((Asset)new StringAsset(faces30Version), "faces-config.xml");
        return this;
    }

    public WebArchiveBuilder withDefaultWebXml() {
        WebAppDescriptor descriptor = (WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).addDefaultNamespaces()).version("5.0").createServlet().servletName("FacesServlet").servletClass("jakarta.faces.webapp.FacesServlet").up()).createServletMapping().servletName("FacesServlet").urlPattern(new String[]{"*.xhtml"}).up();
        return this.withWebXml(descriptor);
    }

    public WebArchiveBuilder withWebXml(WebAppDescriptor descriptor) {
        String web50Version = descriptor.exportAsString().replace("http://xmlns.jcp.org/xml/ns/javaee", "https://jakarta.ee/xml/ns/jakartaee").replace("/web-app_3_1.xsd", "/web-app_5_0.xsd");
        this.archive.addAsWebInfResource((Asset)new StringAsset(web50Version), "web.xml");
        return this;
    }

    public WebArchive build() {
        return this.archive;
    }
}

