/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.multivaluedmap;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 5073014935147496028L;
    static final String[] KEYS = new String[]{"key0", "key1", "key2"};
    private long id = 5073014935147496028L;
    protected MultivaluedMap<String, Object> map;
    protected Vector<Response> vec;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    public JAXRSClientIT() {
        Response r = Response.ok().build();
        this.map = r.getMetadata();
        this.vec = new Vector();
        this.vec.add(r);
    }

    @Test
    public void getFirstWhenEmptyTest() throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((this.map.getFirst((Object)KEYS[0]) == null ? 1 : 0) != 0, (String)"EmptyMultivaluedMap#getFirst() should return null");
        Assertions.assertTrue((this.map.getFirst(null) == null ? 1 : 0) != 0, (String)"EmptyMultivaluedMap#getFirst() should return null");
    }

    @Test
    public void getFirstWhenSingleItemTest() throws JAXRSCommonClient.Fault {
        this.map.add((Object)KEYS[0], (Object)this);
        Assertions.assertTrue((this.map.size() == 1 ? 1 : 0) != 0, (String)"MultivaluedMap contains nothing when item added");
        JAXRSClientIT that = (JAXRSClientIT)this.map.getFirst((Object)KEYS[0]);
        Assertions.assertTrue((that.id == 5073014935147496028L ? 1 : 0) != 0, (String)"MultivaluedMap#getFirst() should contain what added first");
    }

    @Test
    public void getFirstWhenMoreItemsTest() throws JAXRSCommonClient.Fault {
        this.map.add((Object)KEYS[0], (Object)this);
        this.map.add((Object)KEYS[0], this.vec);
        Assertions.assertTrue((this.map.size() == 1 ? 1 : 0) != 0, (String)"There is more items in the map, but only a single key added");
        JAXRSClientIT that = (JAXRSClientIT)this.map.getFirst((Object)KEYS[0]);
        Assertions.assertTrue((that.id == 5073014935147496028L ? 1 : 0) != 0, (String)"MultivaluedMap#getFirst() should contain what added first");
        Assertions.assertTrue((((List)this.map.get((Object)KEYS[0])).size() == 2 ? 1 : 0) != 0, (String)"There shall be two items in a list when added for a single key");
    }

    @Test
    public void getFirstWhenFirstErasedTest() throws JAXRSCommonClient.Fault {
        this.map.add((Object)KEYS[0], (Object)this);
        this.map.add((Object)KEYS[0], this.vec);
        ListIterator i = ((List)this.map.get((Object)KEYS[0])).listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            Assertions.assertTrue((o.getClass() == Vector.class || o.getClass() == JAXRSClientIT.class ? 1 : 0) != 0, (String)"Only items added to a map shall be there");
            if (o.getClass() != JAXRSClientIT.class) continue;
            i.remove();
        }
        Vector anotherVec = (Vector)this.map.getFirst((Object)KEYS[0]);
        Assertions.assertTrue((anotherVec.getClass() == Vector.class ? 1 : 0) != 0, (String)"MultivaluedMap#getFirst() should not point to a removed instance");
    }

    @Test
    public void getFirstWhenListClearedTest() throws JAXRSCommonClient.Fault {
        this.map.add((Object)KEYS[0], (Object)this);
        this.map.add((Object)KEYS[0], this.vec);
        ((List)this.map.get((Object)KEYS[0])).clear();
        Assertions.assertTrue((this.map.getFirst((Object)KEYS[0]) == null ? 1 : 0) != 0, (String)"MultivaluedMap#getFirst() should be null when list is empty");
    }

    @Test
    public void getFirstWhenKeyIsNullTest() throws JAXRSCommonClient.Fault {
        this.map.add((Object)KEYS[0], (Object)this);
        this.map.add(null, this.vec);
        this.map.add(null, (Object)this);
        Assertions.assertTrue((((List)this.map.get(null)).size() == 2 ? 1 : 0) != 0, (String)"There shall be two items in a list when added for a null key");
        Assertions.assertTrue((this.map.size() == 2 ? 1 : 0) != 0, (String)"There shall be two items in a list when added items for two keys");
        Assertions.assertTrue((this.map.getFirst(null).getClass() == Vector.class ? 1 : 0) != 0, (String)"The first item for a null key was not the one retreived");
    }

    @Test
    public void putSingleTest() throws JAXRSCommonClient.Fault {
        this.map.putSingle((Object)KEYS[0], (Object)this);
        this.map.putSingle((Object)KEYS[0], this.vec);
        this.map.putSingle(null, this.vec);
        this.map.putSingle(null, (Object)this);
        Assertions.assertTrue((((List)this.map.get(null)).size() == 1 ? 1 : 0) != 0, (String)"There shall be one item in a list when putSingle() several times");
        Assertions.assertTrue((this.map.size() == 2 ? 1 : 0) != 0, (String)"There shall be two items in a list when added items for two keys");
        Assertions.assertTrue((this.map.getFirst((Object)KEYS[0]).getClass() == Vector.class ? 1 : 0) != 0, (String)"The first item for a null key was not the last put by putSingle()");
        Assertions.assertTrue((this.map.getFirst(null).getClass() == JAXRSClientIT.class ? 1 : 0) != 0, (String)"The first item for a null key was not the last put by putSingle()");
    }

    @Test
    public void addAllValuesTest() throws JAXRSCommonClient.Fault {
        JAXRSClientIT client1 = new JAXRSClientIT();
        this.map.addAll((Object)KEYS[0], new Object[]{this, this.vec, client1});
        Assertions.assertTrue((((List)this.map.get((Object)KEYS[0])).size() == 3 ? 1 : 0) != 0, (String)"Not all objects were added by #addAll");
        Assertions.assertTrue((boolean)((List)this.map.get((Object)KEYS[0])).contains(this.vec), (String)"given Vector has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get((Object)KEYS[0])).contains(client1), (String)"given JAXRSClient has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get((Object)KEYS[0])).contains(this), (String)"this class has not been found in a map");
        JAXRSClientIT.logMsg("All values have been added for key", KEYS[0]);
    }

    @Test
    public void addAllValuesNullKeyTest() throws JAXRSCommonClient.Fault {
        JAXRSClientIT client1 = new JAXRSClientIT();
        this.map.addAll(null, new Object[]{this, this.vec, client1});
        Assertions.assertTrue((((List)this.map.get(null)).size() == 3 ? 1 : 0) != 0, (String)"Not all objects were added by #addAll");
        Assertions.assertTrue((boolean)((List)this.map.get(null)).contains(this.vec), (String)"given Vector has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get(null)).contains(client1), (String)"given JAXRSClient has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get(null)).contains(this), (String)"this class has not been found in a map");
        JAXRSClientIT.logMsg("All values have been added for null key");
    }

    @Test
    public void addAllValuesEmptyReturnsImmediatellyTest() throws JAXRSCommonClient.Fault {
        this.map.addAll((Object)KEYS[0], new Object[0]);
        Assertions.assertTrue((!this.map.containsKey((Object)KEYS[0]) ? 1 : 0) != 0, (String)"Method did not return immediatelly for empty array");
        JAXRSClientIT.logMsg("Method did return immediatelly for empty array");
    }

    @Test
    public void addAllValuesThrowNPETest() throws JAXRSCommonClient.Fault {
        try {
            this.map.addAll((Object)KEYS[0], (Object[])null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected");
            return;
        }
    }

    @Test
    public void addAllListTest() throws JAXRSCommonClient.Fault {
        JAXRSClientIT client1 = new JAXRSClientIT();
        this.map.addAll((Object)KEYS[0], Arrays.asList(this, this.vec, client1));
        Assertions.assertTrue((((List)this.map.get((Object)KEYS[0])).size() == 3 ? 1 : 0) != 0, (String)"Not all objects were added by #addAll");
        Assertions.assertTrue((boolean)((List)this.map.get((Object)KEYS[0])).contains(this.vec), (String)"given Vector has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get((Object)KEYS[0])).contains(client1), (String)"given JAXRSClient has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get((Object)KEYS[0])).contains(this), (String)"this class has not been found in a map");
        JAXRSClientIT.logMsg("All values have been added for key", KEYS[0]);
    }

    @Test
    public void addAllListNullKeyTest() throws JAXRSCommonClient.Fault {
        JAXRSClientIT client1 = new JAXRSClientIT();
        this.map.addAll(null, Arrays.asList(this, this.vec, client1));
        Assertions.assertTrue((((List)this.map.get(null)).size() == 3 ? 1 : 0) != 0, (String)"Not all objects were added by #addAll");
        Assertions.assertTrue((boolean)((List)this.map.get(null)).contains(this.vec), (String)"given Vector has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get(null)).contains(client1), (String)"given JAXRSClient has not been found in a map");
        Assertions.assertTrue((boolean)((List)this.map.get(null)).contains(this), (String)"this class has not been found in a map");
        JAXRSClientIT.logMsg("All values have been added for null key");
    }

    @Test
    public void addAllListEmptyReturnsImmediatellyTest() throws JAXRSCommonClient.Fault {
        this.map.addAll((Object)KEYS[0], new ArrayList());
        Assertions.assertTrue((!this.map.containsKey((Object)KEYS[0]) ? 1 : 0) != 0, (String)"Method did not return immediatelly for empty array");
        JAXRSClientIT.logMsg("Method did return immediatelly for empty array");
    }

    @Test
    public void addAllListThrowNPETest() throws JAXRSCommonClient.Fault {
        try {
            this.map.addAll((Object)KEYS[0], (List)null);
            throw new JAXRSCommonClient.Fault("NullPointerException has not been thrown");
        }
        catch (NullPointerException e) {
            JAXRSClientIT.logMsg("NullPointerException has been thrown as expected");
            return;
        }
    }

    @Test
    public void addFirstTest() throws JAXRSCommonClient.Fault {
        this.map.addAll(null, new Object[]{this.vec, this});
        this.map.addFirst(null, (Object)new StringBuilder().append("test"));
        Assertions.assertTrue((this.map.getFirst(null).getClass() == StringBuilder.class ? 1 : 0) != 0, (String)("#addFirst didn't add new StringBuilder, but " + this.map.getFirst(null).getClass()));
        JAXRSClientIT.logMsg("#addFirst added new item to a first position");
    }

    @Test
    public void equalsIgnoreValueOrderTest() throws JAXRSCommonClient.Fault {
        StringBuilder o1 = new StringBuilder().append(KEYS[0]);
        StringBuffer o2 = new StringBuffer().append(KEYS[1]);
        Object o3 = new Object(){

            public String toString() {
                return KEYS[2];
            }
        };
        this.map.add((Object)KEYS[0], (Object)o1);
        this.map.add((Object)KEYS[0], (Object)o2);
        this.map.add((Object)KEYS[0], o3);
        MultivaluedHashMap map2 = new MultivaluedHashMap();
        map2.addAll((Object)KEYS[0], new Object[]{o3, o1, o2});
        Assertions.assertTrue((boolean)this.map.equalsIgnoreValueOrder((MultivaluedMap)map2), (String)(this.map + " and " + map2 + " are not equalIgnoreValueOrder"));
        Assertions.assertFalse((boolean)this.map.equals((Object)map2), (String)(this.map + " and " + map2 + " are equal"));
        JAXRSClientIT.logMsg("#equalsIgnoreValueOrder compared maps", this.map, "and", map2, "as expected");
    }
}

