/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.client.typedentitieswithxmlbinding;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.ext.messagebodyreaderwriter.ReadableWritableEntity;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.client.typedentitieswithxmlbinding.EntityMessageReader;
import ee.jakarta.tck.ws.rs.spec.client.typedentitieswithxmlbinding.EntityMessageWriter;
import ee.jakarta.tck.ws.rs.spec.client.typedentitieswithxmlbinding.Resource;
import ee.jakarta.tck.ws.rs.spec.client.typedentitieswithxmlbinding.TSAppConfig;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final String entity = Resource.class.getName();

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_client_typedentitieswithxmlbinding_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/client/typedentitieswithxmlbinding/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_client_typedentitieswithxmlbinding_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, EntityMessageReader.class, EntityMessageWriter.class, ReadableWritableEntity.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    @Tag(value="xml_binding")
    public void clientJaxbElementReaderTest() throws JAXRSCommonClient.Fault {
        GenericType<JAXBElement<String>> type = new GenericType<JAXBElement<String>>(){};
        this.standardReaderInvocation(MediaType.TEXT_XML_TYPE);
        JAXBElement responseEntity = (JAXBElement)this.getResponse().readEntity((GenericType)type);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        this.standardReaderInvocation(MediaType.APPLICATION_XML_TYPE);
        responseEntity = (JAXBElement)this.getResponse().readEntity((GenericType)type);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        this.standardReaderInvocation(MediaType.APPLICATION_ATOM_XML_TYPE);
        responseEntity = (JAXBElement)this.getResponse().readEntity((GenericType)type);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        String s = responseEntity.getValue().toString();
        Assertions.assertTrue((boolean)s.equals(entity), (String)("Returned Entity" + s + "is unexpected"));
    }

    @Test
    @Tag(value="xml_binding")
    public void clientJaxbElementWriterTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_XML_TYPE));
        JAXBElement element = new JAXBElement(new QName(""), String.class, (Object)entity);
        this.standardWriterInvocation(element);
    }

    protected void standardReaderInvocation(MediaType mediaType) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "standardreader"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(mediaType));
        this.bufferEntity(true);
        this.invoke();
    }

    protected void standardWriterInvocation(Object objectEntity) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "standardwriter"));
        this.setRequestContentEntity(objectEntity);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, entity);
        this.invoke();
    }

    protected <T> void toStringTest(Class<T> clazz) throws JAXRSCommonClient.Fault {
        Object responseEntity = this.getResponse().readEntity(clazz);
        Assertions.assertTrue((responseEntity != null ? 1 : 0) != 0, (String)"Returned Entity is null!");
        String s = responseEntity.toString();
        if (s.startsWith("[B")) {
            s = new String((byte[])responseEntity);
        }
        Assertions.assertTrue((boolean)s.equals(entity), (String)("Was expected returned entity" + entity + "got" + s));
    }
}

