/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.resource.locator;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.resource.locator.EntityWriter;
import ee.jakarta.tck.ws.rs.spec.resource.locator.LocatorEntity;
import ee.jakarta.tck.ws.rs.spec.resource.locator.Resource;
import ee.jakarta.tck.ws.rs.spec.resource.locator.SubResource;
import ee.jakarta.tck.ws.rs.spec.resource.locator.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_resource_locator_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/resource/locator/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_resource_locator_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, EntityWriter.class, LocatorEntity.class, SubResource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void checkEntityIsNotSetTest() throws JAXRSCommonClient.Fault {
        String request = this.buildRequest(JAXRSCommonClient.Request.POST, "sub;resmatrix=resarg;submatrix=subarg;entity=entityarg;");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, request);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "resMatrix=resarg");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "subMatrix=null");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "entity=null");
        this.invoke();
    }
}

