/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.servletexception;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import servlet.tck.common.servlets.GenericTCKServlet;
import servlet.tck.common.util.ServletTestUtil;

public class TestServlet
extends GenericTCKServlet {
    public void getRootCause(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletException se = new ServletException(new Throwable("cause"));
        if (se.getRootCause() instanceof Throwable) {
            passed = true;
        } else {
            passed = false;
            pw.println("ServletException.getRootCause() did not thrown an instance of Throwable");
        }
        ServletTestUtil.printResult(pw, passed);
    }

    public void servletExceptionConstructor1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        try {
            throw new ServletException();
        }
        catch (Throwable t) {
            if (t instanceof ServletException) {
                passed = true;
            } else {
                passed = false;
                pw.println("Exception thrown was not of type ServletException");
            }
            ServletTestUtil.printResult(pw, passed);
            return;
        }
    }

    public void servletExceptionConstructor2(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        try {
            throw new ServletException("Exceptional");
        }
        catch (Throwable t) {
            if (t instanceof ServletException) {
                if (t.getMessage().equals("Exceptional")) {
                    passed = true;
                } else {
                    passed = false;
                    pw.println("Exception did not contain Exceptional");
                }
            } else {
                passed = false;
                pw.println("Exception thrown was not of type ServletException(String)");
            }
            ServletTestUtil.printResult(pw, passed);
            return;
        }
    }

    public void servletExceptionConstructor3(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletException se = null;
        try {
            se = new ServletException(new Throwable("irrelevant"));
            throw se;
        }
        catch (Throwable t) {
            if (t instanceof ServletException) {
                Throwable rootCause = se.getRootCause();
                if (rootCause != null) {
                    if (rootCause.getMessage().equals("irrelevant")) {
                        passed = true;
                    } else {
                        passed = false;
                        pw.println("Exception did not contain irrelevant");
                    }
                } else {
                    passed = false;
                    pw.println("rootCause message is null, expecting it to be 'irrelevant'");
                }
            } else {
                passed = false;
                pw.println("Exception thrown is not of type ServletException");
            }
            ServletTestUtil.printResult(pw, passed);
            return;
        }
    }

    public void servletExceptionConstructor4(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        boolean passed = false;
        ServletException se = null;
        try {
            se = new ServletException("Exceptional", new Throwable("cos"));
            throw se;
        }
        catch (Throwable t) {
            if (t instanceof ServletException) {
                Throwable cause = se.getRootCause();
                String mesg = se.getMessage();
                if (cause != null && mesg != null) {
                    if (mesg.equals("Exceptional") && cause.getMessage().equals("cos")) {
                        passed = true;
                    } else {
                        passed = false;
                        pw.println("Exception did not contain Exceptional and a cause of cos");
                        pw.println("Actual exception was |" + mesg + "|");
                        pw.println("Actual cause was |" + cause.getMessage() + "|");
                    }
                } else {
                    passed = false;
                    pw.println("rootCause message thrown by Exception was null");
                }
            } else {
                passed = false;
                pw.println("Exception thrown was not an instance of ServletException");
            }
            ServletTestUtil.printResult(pw, passed);
            return;
        }
    }
}

