/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.sessiontrackingmode;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionTrackingMode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import servlet.tck.common.servlets.GenericTCKServlet;
import servlet.tck.common.util.ServletTestUtil;

public class TestServlet
extends GenericTCKServlet {
    public void setSessionTrackingModes(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        pw.println((String)context.getAttribute("LOG"));
        HashSet<SessionTrackingMode> expected_modes = new HashSet<SessionTrackingMode>();
        String expected = (String)context.getAttribute("MODES");
        StringTokenizer str = new StringTokenizer(expected, ";");
        while (str.hasMoreTokens()) {
            String mode = str.nextToken();
            pw.println("Expected SessionTrackingMode =" + mode);
            if (mode.equals(SessionTrackingMode.COOKIE.toString())) {
                expected_modes.add(SessionTrackingMode.COOKIE);
                continue;
            }
            if (mode.equals(SessionTrackingMode.SSL.toString())) continue;
            if (mode.equals(SessionTrackingMode.URL.toString())) {
                expected_modes.add(SessionTrackingMode.URL);
                continue;
            }
            passed = false;
            pw.println("Unrecogized SessionTrackingMode expected: " + mode);
        }
        Set results = null;
        results = expected_modes.isEmpty() ? context.getDefaultSessionTrackingModes() : context.getEffectiveSessionTrackingModes();
        if (!results.containsAll(expected_modes)) {
            passed = false;
            pw.append("setSessionTrackingModes and getEffectiveSessionTrackingModes retuns different set of SessionTrackingModes");
            pw.append("getEffectiveSessionTrackingModes =");
            for (SessionTrackingMode tmp : results) {
                pw.append("           " + tmp);
            }
        }
        ServletTestUtil.printResult(pw, passed);
    }
}

