/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet_http.readlistener1;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.api.jakarta_servlet_http.readlistener1.TestListener;
import servlet.tck.api.jakarta_servlet_http.readlistener1.TestServlet;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.common.servlets.CommonServlets;
import servlet.tck.common.util.ServletTestUtil;

public class ReadListener1Tests
extends AbstractTckTest {
    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
        this.setContextRoot("/servlet_jsh_readlistener1_web");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_jsh_readlistener1_web.war")).addAsLibraries((Archive[])CommonServlets.getCommonServletsArchive())).addClasses(new Class[]{TestServlet.class, TestListener.class});
    }

    @Test
    public void nioInputTest1() throws Exception {
        boolean passed = true;
        int sleepInSeconds = Integer.parseInt(this._props.getProperty("servlet_async_wait").trim());
        String testName = "nioInputTest1";
        String EXPECTED_RESPONSE = "Test PASSED|NullPointerException";
        String requestUrl = "http://" + this._hostname + ":" + this._port + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName;
        URL url = new URL(requestUrl);
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            this.logger.trace("======= Connecting {}", (Object)url.toExternalForm());
            conn.setChunkedStreamingMode(5);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            this.logger.trace("======= Header {}", (Object)conn);
            conn.connect();
            try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));){
                try {
                    String data = "Hello";
                    output.write(data);
                    output.flush();
                    Thread.sleep(sleepInSeconds * 1000);
                    data = "World";
                    output.write(data);
                    output.flush();
                    output.close();
                }
                catch (Exception ex) {
                    passed = false;
                    this.logger.error("======= Exception sending message: " + ex.getMessage());
                }
                try (BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line;
                    StringBuilder message_received = new StringBuilder();
                    while ((line = input.readLine()) != null) {
                        this.logger.trace("======= message received: {}", (Object)line);
                        message_received.append(line);
                    }
                    passed = ServletTestUtil.compareString(EXPECTED_RESPONSE, message_received.toString());
                }
            }
        }
        catch (Exception ex3) {
            passed = false;
            this.logger.error("Test" + ex3.getMessage());
        }
        if (!passed) {
            throw new Exception("Test Failed.");
        }
    }

    @Test
    public void nioInputTest2() throws Exception {
        boolean passed = true;
        int sleepInSeconds = Integer.parseInt(this._props.getProperty("servlet_async_wait").trim());
        String testName = "nioInputTest2";
        String EXPECTED_RESPONSE = "Test PASSED|IllegalStateException";
        String requestUrl = "http://" + this._hostname + ":" + this._port + this.getContextRoot() + "/" + this.getServletName() + "?testname=" + testName;
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            this.logger.trace("======= Connecting {}", (Object)url.toExternalForm());
            conn.setChunkedStreamingMode(5);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            this.logger.trace("======= Header {}", (Object)conn);
            conn.connect();
            try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()));){
                String data = "Hello";
                output.write(data);
                output.flush();
                Thread.sleep(sleepInSeconds * 1000);
                data = "World";
                output.write(data);
                output.flush();
                output.close();
                try (BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line;
                    StringBuilder message_received = new StringBuilder();
                    while ((line = input.readLine()) != null) {
                        this.logger.trace("======= message received: {}", (Object)line);
                        message_received.append(line);
                    }
                    passed = ServletTestUtil.compareString(EXPECTED_RESPONSE, message_received.toString());
                }
            }
        }
        catch (Exception ex3) {
            passed = false;
            this.logger.error("Test" + ex3.getMessage());
        }
        if (!passed) {
            throw new Exception("Test Failed.");
        }
    }
}

