/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.multifiltermapping;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;

public class NoContentLengthResponseWrapper
extends HttpServletResponseWrapper {
    public NoContentLengthResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void setContentLength(int len) {
    }

    public void setContentLengthLong(long len) {
    }

    public void setHeader(String name, String value) {
        if (this.isContentLength(name)) {
            return;
        }
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if (this.isContentLength(name)) {
            return;
        }
        super.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isContentLength(name)) {
            return;
        }
        super.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isContentLength(name)) {
            return;
        }
        super.addIntHeader(name, value);
    }

    private boolean isContentLength(String headerName) {
        return "content-length".equalsIgnoreCase(headerName);
    }
}

