/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.mvnosgi.launching.ui;

import java.util.stream.Stream;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MainLauncherTab
extends AbstractLaunchConfigurationTab {
    private Text fProjText;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group g = new Group(composite, 0);
        g.setLayoutData((Object)new GridData(768));
        g.setText("Project");
        g.setLayout((Layout)new GridLayout(2, false));
        this.fProjText = new Text((Composite)g, 2048);
        this.fProjText.setLayoutData((Object)new GridData(768));
        this.fProjText.addModifyListener(e -> {
            this.setDirty(true);
            this.getLaunchConfigurationDialog().updateButtons();
        });
        Button b = new Button((Composite)g, 8);
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IJavaProject project = this.chooseJavaProject();
            if (project != null) {
                this.fProjText.setText(project.getProject().getName());
            }
        }));
        b.setText("Browse ...");
        this.setControl((Control)composite);
    }

    private IJavaProject chooseJavaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        try {
            Object[] projects = Stream.of(JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects()).filter(p -> {
                try {
                    return p.getProject().hasNature("org.eclipse.m2e.core.maven2Nature");
                }
                catch (CoreException e) {
                    return false;
                }
            }).toArray();
            dialog.setElements(projects);
        }
        catch (JavaModelException projects) {
            // empty catch block
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fProjText.setText(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
    }

    public String getName() {
        return "Main";
    }
}

