/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.function;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.fx.core.function.ExConsumer;
import org.eclipse.fx.core.function.ExFunction;
import org.eclipse.fx.core.function.ExRunnable;
import org.eclipse.fx.core.function.ExSupplier;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.jdt.annotation.NonNull;

public final class ExExecutor {
    private ExExecutor() {
    }

    private static @NonNull RuntimeException wrap(@NonNull Throwable e, @NonNull String message) {
        return new RuntimeException(message, e);
    }

    public static void executeRunnable(@NonNull ExRunnable r, @NonNull String message) {
        ExExecutor.executeRunnable(r, (Throwable e) -> ExExecutor.wrap(e, message));
    }

    public static void executeRunnable(@NonNull ExRunnable r, @NonNull Function<@NonNull Throwable, @NonNull RuntimeException> exceptionConverter) {
        try {
            r.wrappedRun();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw exceptionConverter.apply(e);
        }
    }

    public static void executeRunnable(@NonNull ExRunnable r, Logger logger) {
        try {
            r.wrappedRun();
        }
        catch (Throwable t) {
            Logger l = logger;
            if (l == null) {
                l = LoggerCreator.createLogger(ExExecutor.class);
            }
            l.error("Unable to execute" + String.valueOf(r), t);
        }
    }

    public static void executeRunnable(@NonNull ExRunnable r) {
        ExExecutor.executeRunnable(r, null);
    }

    public static <V> Optional<V> executeSupplier(@NonNull ExSupplier<V> r, @NonNull String message) {
        return ExExecutor.executeSupplier(r, (Throwable e) -> ExExecutor.wrap(e, message));
    }

    public static <V> Optional<V> executeSupplier(@NonNull ExSupplier<V> r, @NonNull Function<@NonNull Throwable, @NonNull RuntimeException> exceptionConverter) {
        try {
            return Optional.ofNullable(r.wrappedGet());
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw exceptionConverter.apply(e);
        }
    }

    public static <V> Optional<V> executeSupplierOrDefault(@NonNull ExSupplier<V> r, Function<Throwable, V> exceptionHandler) {
        try {
            return Optional.of(r.wrappedGet());
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(ExExecutor.class).error("Failed to execute supplier", t);
            return Optional.ofNullable(exceptionHandler.apply(t));
        }
    }

    public static <V> Optional<V> accept(@NonNull ExSupplier<V> r) {
        try {
            return Optional.of(r.wrappedGet());
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static <T> void executeConsumer(T value, @NonNull ExConsumer<T> r, @NonNull String message) {
        ExExecutor.executeConsumer(value, r, (Throwable e) -> ExExecutor.wrap(e, message));
    }

    public static <T> void executeConsumer(T value, @NonNull ExConsumer<T> r, @NonNull Function<@NonNull Throwable, @NonNull RuntimeException> exceptionConverter) {
        try {
            r.wrappedAccept(value);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw exceptionConverter.apply(e);
        }
    }

    public static <T> void get(T value, @NonNull ExConsumer<T> r) {
        try {
            r.wrappedAccept(value);
        }
        catch (Throwable e) {
            LoggerCreator.createLogger(ExExecutor.class).error("Failed to execute consumer", e);
        }
    }

    public static <V, R> Optional<R> executeFunction(V value, @NonNull ExFunction<V, R> r, @NonNull String message) {
        return ExExecutor.executeFunction(value, r, (Throwable e) -> ExExecutor.wrap(e, message));
    }

    public static <V, R> Optional<R> executeFunctionOrDefault(V value, @NonNull ExFunction<V, R> r, BiFunction<Throwable, V, R> exceptionHandler) {
        try {
            return Optional.of(r.wrappedApply(value));
        }
        catch (Throwable t) {
            return Optional.ofNullable(exceptionHandler.apply(t, value));
        }
    }

    public static <V, R> Optional<R> apply(V value, @NonNull ExFunction<V, R> f) {
        try {
            return Optional.of(f.wrappedApply(value));
        }
        catch (Throwable t) {
            LoggerCreator.createLogger(ExExecutor.class).error("Failed to execute function", t);
            return Optional.empty();
        }
    }

    public static <V, R> Optional<R> executeFunction(V value, @NonNull ExFunction<V, R> r, @NonNull Function<@NonNull Throwable, @NonNull RuntimeException> exceptionConverter) {
        try {
            return Optional.ofNullable(r.wrappedApply(value));
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw exceptionConverter.apply(e);
        }
    }
}

