/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.fx.ui.controls.styledtext.StyledStringSegment;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StyledString
implements CharSequence {
    private @Nullable StringBuffer buffer;
    private @NonNull ObservableList<@NonNull StyledStringSegment> segmentList = FXCollections.observableArrayList();

    public StyledString() {
        this.segmentList.addListener((InvalidationListener)new WeakInvalidationListener(o -> {
            StringBuffer stringBuffer = this.buffer = null;
        }));
    }

    private final StringBuffer buffer() {
        StringBuffer rv = this.buffer;
        if (rv == null) {
            rv = this.buffer = new StringBuffer();
            for (StyledStringSegment s : this.segmentList) {
                rv.append(s.getText());
            }
        }
        return rv;
    }

    @Override
    public int length() {
        return this.buffer().length();
    }

    @Override
    public char charAt(int index) {
        return this.buffer().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.buffer().subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.buffer().toString();
    }

    public @NonNull ObservableList<@NonNull StyledStringSegment> getSegmentList() {
        return this.segmentList;
    }

    public void appendSegment(String text, String ... styleClass) {
        this.segmentList.add((Object)new StyledStringSegment(text, styleClass));
    }

    public void appendSegment(String text, List<String> styleClass) {
        this.segmentList.add((Object)new StyledStringSegment(text, styleClass));
    }
}

