/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.panes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.fx.ui.panes.AbstractLayoutPane;
import org.eclipse.fx.ui.panes.RowData;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RowLayoutPane
extends AbstractLayoutPane<RowData> {
    private static final CssMetaData<RowLayoutPane, Number> MARGIN_WIDTH = new CssMetaData<RowLayoutPane, Number>("-fx-inner-margin-width", StyleConverter.getSizeConverter(), (Number)0){

        public boolean isSettable(RowLayoutPane node) {
            return !node.marginWidthProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.marginWidthProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Number> MARGIN_HEIGHT = new CssMetaData<RowLayoutPane, Number>("-fx-inner-margin-height", StyleConverter.getSizeConverter(), (Number)0){

        public boolean isSettable(RowLayoutPane node) {
            return !node.marginHeightProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.marginHeightProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Number> MARGIN_LEFT = new CssMetaData<RowLayoutPane, Number>("-fx-inner-margin-left", StyleConverter.getSizeConverter(), (Number)0){

        public boolean isSettable(RowLayoutPane node) {
            return !node.marginLeftProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.marginLeftProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Number> MARGIN_TOP = new CssMetaData<RowLayoutPane, Number>("-fx-inner-margin-top", StyleConverter.getSizeConverter(), (Number)0){

        public boolean isSettable(RowLayoutPane node) {
            return !node.marginTopProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.marginTopProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Number> MARGIN_RIGHT = new CssMetaData<RowLayoutPane, Number>("-fx-inner-margin-right", StyleConverter.getSizeConverter(), (Number)0){

        public boolean isSettable(RowLayoutPane node) {
            return !node.marginRightProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.marginRightProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Number> MARGIN_BOTTOM = new CssMetaData<RowLayoutPane, Number>("-fx-inner-margin-bottom", StyleConverter.getSizeConverter(), (Number)0){

        public boolean isSettable(RowLayoutPane node) {
            return !node.marginBottomProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.marginBottomProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Number> SPACING = new CssMetaData<RowLayoutPane, Number>("-fx-spacing", StyleConverter.getSizeConverter(), (Number)3){

        public boolean isSettable(RowLayoutPane node) {
            return !node.spacingProperty().isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.spacingProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Boolean> WRAP = new CssMetaData<RowLayoutPane, Boolean>("-fx-wrap", StyleConverter.getBooleanConverter(), Boolean.TRUE){

        public boolean isSettable(RowLayoutPane node) {
            return !node.wrapProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.wrapProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Boolean> PACK = new CssMetaData<RowLayoutPane, Boolean>("-fx-pack", StyleConverter.getBooleanConverter(), Boolean.TRUE){

        public boolean isSettable(RowLayoutPane node) {
            return !node.packProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.packProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Boolean> FILL = new CssMetaData<RowLayoutPane, Boolean>("-fx-fill", StyleConverter.getBooleanConverter(), Boolean.FALSE){

        public boolean isSettable(RowLayoutPane node) {
            return !node.fillProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.fillProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Boolean> CENTER = new CssMetaData<RowLayoutPane, Boolean>("-fx-center", StyleConverter.getBooleanConverter(), Boolean.FALSE){

        public boolean isSettable(RowLayoutPane node) {
            return !node.centerProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.centerProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Boolean> JUSTIFY = new CssMetaData<RowLayoutPane, Boolean>("-fx-justify", StyleConverter.getBooleanConverter(), Boolean.FALSE){

        public boolean isSettable(RowLayoutPane node) {
            return !node.justifyProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.justifyProperty();
        }
    };
    private static final CssMetaData<RowLayoutPane, Boolean> HORIZONTAL = new CssMetaData<RowLayoutPane, Boolean>("-fx-horizontal", StyleConverter.getBooleanConverter(), Boolean.FALSE){

        public boolean isSettable(RowLayoutPane node) {
            return !node.horizontalProperty().isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(RowLayoutPane node) {
            return (StyleableProperty)node.horizontalProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private final @NonNull IntegerProperty marginWidth = new SimpleStyleableIntegerProperty(MARGIN_WIDTH, (Object)this, "marginWidth", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginHeight = new SimpleStyleableIntegerProperty(MARGIN_HEIGHT, (Object)this, "marginHeight", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginLeft = new SimpleStyleableIntegerProperty(MARGIN_LEFT, (Object)this, "marginLeft", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginTop = new SimpleStyleableIntegerProperty(MARGIN_TOP, (Object)this, "marginTop", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginRight = new SimpleStyleableIntegerProperty(MARGIN_RIGHT, (Object)this, "marginRight", Integer.valueOf(0));
    private final @NonNull IntegerProperty marginBottom = new SimpleStyleableIntegerProperty(MARGIN_BOTTOM, (Object)this, "marginBottom", Integer.valueOf(0));
    private @NonNull IntegerProperty spacing = new SimpleStyleableIntegerProperty(SPACING, (Object)this, "spacing", Integer.valueOf(3));
    private @NonNull BooleanProperty wrap = new SimpleStyleableBooleanProperty(WRAP, (Object)this, "wrap", true);
    private @NonNull BooleanProperty pack = new SimpleStyleableBooleanProperty(PACK, (Object)this, "pack", true);
    private @NonNull BooleanProperty fill = new SimpleStyleableBooleanProperty(FILL, (Object)this, "fill", false);
    private @NonNull BooleanProperty center = new SimpleStyleableBooleanProperty(CENTER, (Object)this, "center", false);
    private @NonNull BooleanProperty justify = new SimpleStyleableBooleanProperty(JUSTIFY, (Object)this, "justify", false);
    private @NonNull BooleanProperty horizontal = new SimpleStyleableBooleanProperty(HORIZONTAL, (Object)this, "horizontal", true);
    private static final @NonNull String LAYOUT_KEY = "rowData";

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(AbstractLayoutPane.getClassCssMetaData());
        styleables.add(CENTER);
        styleables.add(FILL);
        styleables.add(HORIZONTAL);
        styleables.add(JUSTIFY);
        styleables.add(MARGIN_BOTTOM);
        styleables.add(MARGIN_HEIGHT);
        styleables.add(MARGIN_LEFT);
        styleables.add(MARGIN_RIGHT);
        styleables.add(MARGIN_TOP);
        styleables.add(PACK);
        styleables.add(SPACING);
        styleables.add(WRAP);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return RowLayoutPane.getClassCssMetaData();
    }

    public static final void setConstraint(@NonNull Node n, @NonNull RowData griddata) {
        RowLayoutPane.setConstraint(n, LAYOUT_KEY, griddata);
    }

    public static final @Nullable RowData getConstraint(@NonNull Node n) {
        return (RowData)RowLayoutPane.getConstraint(n, LAYOUT_KEY);
    }

    @Override
    protected AbstractLayoutPane.Size computeSize(double wHint, double hHint, boolean flushCache) {
        AbstractLayoutPane.Size extent = this.isHorizontal() ? this.layoutHorizontal(false, wHint != -1.0 && this.isWrap(), wHint, flushCache) : this.layoutVertical(false, hHint != -1.0 && this.isWrap(), hHint, flushCache);
        double width = extent.width;
        double height = extent.height;
        if (wHint != -1.0) {
            width = wHint;
        }
        if (hHint != -1.0) {
            height = hHint;
        }
        return new AbstractLayoutPane.Size(width, height);
    }

    private static AbstractLayoutPane.Size computeSize(@NonNull Node control, boolean flushCache) {
        int wHint = -1;
        int hHint = -1;
        RowData data = RowLayoutPane.getConstraint(control);
        if (data != null) {
            wHint = data.getWidth();
            hHint = data.getHeight();
        }
        return new AbstractLayoutPane.Size(control.prefWidth((double)wHint), control.prefHeight((double)hHint));
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Bounds clientArea = this.getLayoutBounds();
        if (this.isHorizontal()) {
            this.layoutHorizontal(true, this.isWrap(), clientArea.getWidth(), true);
        } else {
            this.layoutVertical(true, this.isWrap(), clientArea.getHeight(), true);
        }
    }

    private int getInnerMarginLeft() {
        return (int)Math.ceil((double)(this.getMarginWidth() + this.getMarginLeft()) + this.getPadding().getLeft());
    }

    private int getInnerMarginRight() {
        return (int)Math.ceil((double)(this.getMarginWidth() + this.getMarginRight()) + this.getPadding().getRight());
    }

    private int getInnerMarginTop() {
        return (int)Math.ceil((double)(this.getMarginHeight() + this.getMarginTop()) + this.getPadding().getTop());
    }

    private int getInnerMarginBottom() {
        return (int)Math.ceil((double)(this.getMarginHeight() + this.getMarginBottom()) + this.getPadding().getBottom());
    }

    AbstractLayoutPane.Size layoutHorizontal(boolean move, boolean wrap, double width, boolean flushCache) {
        @NonNull Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = 0;
        int i = 0;
        while (i < children.length) {
            Node control = children[i];
            RowData data = RowLayoutPane.getConstraint(control);
            if (data == null || !data.isExclude()) {
                children[count++] = children[i];
            }
            ++i;
        }
        if (count == 0) {
            return new AbstractLayoutPane.Size(this.getInnerMarginLeft() + this.getInnerMarginRight(), this.getInnerMarginTop() + this.getInnerMarginBottom());
        }
        double childWidth = 0.0;
        double childHeight = 0.0;
        double maxHeight = 0.0;
        if (!this.isPack()) {
            int i2 = 0;
            while (i2 < count) {
                Node child = children[i2];
                AbstractLayoutPane.Size size = RowLayoutPane.computeSize(child, flushCache);
                childWidth = Math.max(childWidth, size.width);
                childHeight = Math.max(childHeight, size.height);
                ++i2;
            }
            maxHeight = childHeight;
        }
        double clientX = 0.0;
        double clientY = 0.0;
        if (move) {
            Bounds rect = this.getLayoutBounds();
            clientX = rect.getMinX();
            clientY = rect.getMinY();
        }
        double[] wraps = null;
        boolean wrapped = false;
        Bounds[] bounds = null;
        if (move && (this.isJustify() || this.isFill() || this.isCenter())) {
            bounds = new Bounds[count];
            wraps = new double[count];
        }
        double maxX = 0.0;
        double x = this.getInnerMarginLeft();
        double y = this.getInnerMarginTop();
        int i3 = 0;
        while (i3 < count) {
            Node child = children[i3];
            if (this.isPack()) {
                AbstractLayoutPane.Size size = RowLayoutPane.computeSize(child, flushCache);
                childWidth = size.width;
                childHeight = size.height;
            }
            if (wrap && i3 != 0 && x + childWidth > width) {
                wrapped = true;
                if (move && (this.isJustify() || this.isFill() || this.isCenter()) && wraps != null) {
                    wraps[i3 - 1] = maxHeight;
                }
                x = this.getInnerMarginLeft();
                y += (double)this.getSpacing() + maxHeight;
                if (this.isPack()) {
                    maxHeight = 0.0;
                }
            }
            if (this.isPack() || this.isFill() || this.isCenter()) {
                maxHeight = Math.max(maxHeight, childHeight);
            }
            if (move) {
                double childX = x + clientX;
                double childY = y + clientY;
                if (this.isJustify() || this.isFill() || this.isCenter()) {
                    if (bounds != null) {
                        bounds[i3] = new BoundingBox(childX, childY, childWidth, childHeight);
                    }
                } else {
                    child.resizeRelocate(childX, childY, childWidth, childHeight);
                }
            }
            maxX = Math.max(maxX, x += (double)this.getSpacing() + childWidth);
            ++i3;
        }
        maxX = Math.max(clientX + (double)this.getInnerMarginLeft(), maxX - (double)this.getSpacing());
        if (!wrapped) {
            maxX += (double)this.getInnerMarginRight();
        }
        if (move && (this.isJustify() || this.isFill() || this.isCenter())) {
            double space = 0.0;
            double margin = 0.0;
            if (!wrapped) {
                space = Math.max(0.0, (width - maxX) / (double)(count + 1));
                margin = Math.max(0.0, (width - maxX) % (double)(count + 1) / 2.0);
            } else if (this.isFill() || this.isJustify() || this.isCenter()) {
                int last = 0;
                if (count > 0 && wraps != null) {
                    wraps[count - 1] = maxHeight;
                }
                int i4 = 0;
                while (i4 < count) {
                    if (wraps != null && wraps[i4] != 0.0) {
                        int wrapCount = i4 - last + 1;
                        if (this.isJustify()) {
                            int wrapX = 0;
                            int j = last;
                            while (j <= i4) {
                                if (bounds != null) {
                                    wrapX = (int)((double)wrapX + (bounds[j].getWidth() + (double)this.getSpacing()));
                                }
                                ++j;
                            }
                            space = Math.max(0.0, (width - (double)wrapX) / (double)(wrapCount + 1));
                            margin = Math.max(0.0, (width - (double)wrapX) % (double)(wrapCount + 1) / 2.0);
                        }
                        int j = last;
                        while (j <= i4) {
                            if (this.isJustify() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeX(bounds[j], space * (double)(j - last + 1) + margin);
                            }
                            if (this.isFill()) {
                                if (bounds != null) {
                                    bounds[j] = RowLayoutPane.changeHeight(bounds[j], wraps[i4]);
                                }
                            } else if (this.isCenter() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeY(bounds[j], Math.max(0.0, (wraps[i4] - bounds[j].getHeight()) / 2.0));
                            }
                            ++j;
                        }
                        last = i4 + 1;
                    }
                    ++i4;
                }
            }
            int i5 = 0;
            while (i5 < count) {
                if (!wrapped) {
                    if (this.isJustify() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeX(bounds[i5], space * (double)(i5 + 1) + margin);
                    }
                    if (this.isFill()) {
                        if (bounds != null) {
                            bounds[i5] = RowLayoutPane.changeHeight(bounds[i5], maxHeight);
                        }
                    } else if (this.isCenter() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeY(bounds[i5], Math.max(0.0, (maxHeight - bounds[i5].getHeight()) / 2.0));
                    }
                }
                if (bounds != null) {
                    children[i5].resizeRelocate(bounds[i5].getMinX(), bounds[i5].getMinY(), bounds[i5].getWidth(), bounds[i5].getHeight());
                }
                ++i5;
            }
        }
        return new AbstractLayoutPane.Size(maxX, y + maxHeight + (double)this.getInnerMarginBottom());
    }

    AbstractLayoutPane.Size layoutVertical(boolean move, boolean wrap, double height, boolean flushCache) {
        @NonNull Node[] children = (Node[])this.getChildren().toArray((Object[])new Node[0]);
        int count = 0;
        int i = 0;
        while (i < children.length) {
            Node control = children[i];
            RowData data = RowLayoutPane.getConstraint(control);
            if (data == null || !data.isExclude()) {
                children[count++] = children[i];
            }
            ++i;
        }
        if (count == 0) {
            return new AbstractLayoutPane.Size(this.getInnerMarginLeft() + this.getInnerMarginRight(), this.getInnerMarginTop() + this.getInnerMarginBottom());
        }
        double childWidth = 0.0;
        double childHeight = 0.0;
        double maxWidth = 0.0;
        if (!this.isPack()) {
            int i2 = 0;
            while (i2 < count) {
                Node child = children[i2];
                AbstractLayoutPane.Size size = RowLayoutPane.computeSize(child, flushCache);
                childWidth = Math.max(childWidth, size.width);
                childHeight = Math.max(childHeight, size.height);
                ++i2;
            }
            maxWidth = childWidth;
        }
        double clientX = 0.0;
        double clientY = 0.0;
        if (move) {
            Bounds rect = this.getLayoutBounds();
            clientX = rect.getMinX();
            clientY = rect.getMinY();
        }
        double[] wraps = null;
        boolean wrapped = false;
        Bounds[] bounds = null;
        if (move && (this.isJustify() || this.isFill() || this.isCenter())) {
            bounds = new Bounds[count];
            wraps = new double[count];
        }
        double maxY = 0.0;
        double x = this.getInnerMarginLeft();
        double y = this.getInnerMarginBottom();
        int i3 = 0;
        while (i3 < count) {
            Node child = children[i3];
            if (this.isPack()) {
                AbstractLayoutPane.Size size = RowLayoutPane.computeSize(child, flushCache);
                childWidth = size.width;
                childHeight = size.height;
            }
            if (wrap && i3 != 0 && y + childHeight > height) {
                wrapped = true;
                if (move && (this.isJustify() || this.isFill() || this.isCenter()) && wraps != null) {
                    wraps[i3 - 1] = maxWidth;
                }
                x += (double)this.getSpacing() + maxWidth;
                y = this.getInnerMarginTop();
                if (this.isPack()) {
                    maxWidth = 0.0;
                }
            }
            if (this.isPack() || this.isFill() || this.isCenter()) {
                maxWidth = Math.max(maxWidth, childWidth);
            }
            if (move) {
                double childX = x + clientX;
                double childY = y + clientY;
                if (this.isJustify() || this.isFill() || this.isCenter()) {
                    if (bounds != null) {
                        bounds[i3] = new BoundingBox(childX, childY, childWidth, childHeight);
                    }
                } else {
                    child.resizeRelocate(childX, childY, childWidth, childHeight);
                }
            }
            maxY = Math.max(maxY, y += (double)this.getSpacing() + childHeight);
            ++i3;
        }
        maxY = Math.max(clientY + (double)this.getInnerMarginTop(), maxY - (double)this.getSpacing());
        if (!wrapped) {
            maxY += (double)this.getInnerMarginBottom();
        }
        if (move && (this.isJustify() || this.isFill() || this.isCenter())) {
            double space = 0.0;
            double margin = 0.0;
            if (!wrapped) {
                space = Math.max(0.0, (height - maxY) / (double)(count + 1));
                margin = Math.max(0.0, (height - maxY) % (double)(count + 1) / 2.0);
            } else if (this.isFill() || this.isJustify() || this.isCenter()) {
                int last = 0;
                if (count > 0 && wraps != null) {
                    wraps[count - 1] = maxWidth;
                }
                int i4 = 0;
                while (i4 < count) {
                    if (wraps != null && wraps[i4] != 0.0) {
                        int wrapCount = i4 - last + 1;
                        if (this.isJustify()) {
                            int wrapY = 0;
                            int j = last;
                            while (j <= i4) {
                                if (bounds != null) {
                                    wrapY = (int)((double)wrapY + (bounds[j].getHeight() + (double)this.getSpacing()));
                                }
                                ++j;
                            }
                            space = Math.max(0.0, (height - (double)wrapY) / (double)(wrapCount + 1));
                            margin = Math.max(0.0, (height - (double)wrapY) % (double)(wrapCount + 1) / 2.0);
                        }
                        int j = last;
                        while (j <= i4) {
                            if (this.isJustify() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeY(bounds[j], space * (double)(j - last + 1) + margin);
                            }
                            if (this.isFill()) {
                                if (bounds != null) {
                                    bounds[j] = RowLayoutPane.changeWidth(bounds[j], wraps[i4]);
                                }
                            } else if (this.isCenter() && bounds != null) {
                                bounds[j] = RowLayoutPane.changeX(bounds[j], Math.max(0.0, (wraps[i4] - bounds[j].getWidth()) / 2.0));
                            }
                            ++j;
                        }
                        last = i4 + 1;
                    }
                    ++i4;
                }
            }
            int i5 = 0;
            while (i5 < count) {
                if (!wrapped) {
                    if (this.isJustify() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeY(bounds[i5], space * (double)(i5 + 1) + margin);
                    }
                    if (this.isFill()) {
                        if (bounds != null) {
                            bounds[i5] = RowLayoutPane.changeWidth(bounds[i5], maxWidth);
                        }
                    } else if (this.isCenter() && bounds != null) {
                        bounds[i5] = RowLayoutPane.changeX(bounds[i5], Math.max(0.0, (maxWidth - bounds[i5].getWidth()) / 2.0));
                    }
                }
                if (bounds != null) {
                    children[i5].resizeRelocate(bounds[i5].getMinX(), bounds[i5].getMinY(), bounds[i5].getWidth(), bounds[i5].getHeight());
                }
                ++i5;
            }
        }
        return new AbstractLayoutPane.Size(x + maxWidth + (double)this.getInnerMarginRight(), maxY);
    }

    private static Bounds changeX(Bounds original, double amount) {
        return new BoundingBox(original.getMinX() + amount, original.getMinY(), original.getWidth(), original.getHeight());
    }

    private static Bounds changeY(Bounds original, double amount) {
        return new BoundingBox(original.getMinX(), original.getMinY() + amount, original.getWidth(), original.getHeight());
    }

    private static Bounds changeHeight(Bounds original, double amount) {
        return new BoundingBox(original.getMinX(), original.getMinY(), original.getWidth(), original.getHeight() + amount);
    }

    private static Bounds changeWidth(Bounds original, double amount) {
        return new BoundingBox(original.getMinX(), original.getMinY(), original.getWidth() + amount, original.getHeight());
    }

    public void setCenter(boolean value) {
        this.centerProperty().set(value);
    }

    public boolean isCenter() {
        return this.centerProperty().get();
    }

    public @NonNull BooleanProperty centerProperty() {
        return this.center;
    }

    public void setFill(boolean value) {
        this.fillProperty().set(value);
    }

    public boolean isFill() {
        return this.fillProperty().get();
    }

    public @NonNull BooleanProperty fillProperty() {
        return this.fill;
    }

    public void setJustify(boolean value) {
        this.justifyProperty().set(value);
    }

    public boolean isJustify() {
        return this.justifyProperty().get();
    }

    public @NonNull BooleanProperty justifyProperty() {
        return this.justify;
    }

    public void setMarginBottom(int value) {
        this.marginBottomProperty().set(value);
    }

    public int getMarginBottom() {
        return this.marginBottomProperty().get();
    }

    public @NonNull IntegerProperty marginBottomProperty() {
        return this.marginBottom;
    }

    public void setMarginHeight(int value) {
        this.marginHeightProperty().set(value);
    }

    public int getMarginHeight() {
        return this.marginHeightProperty().get();
    }

    public @NonNull IntegerProperty marginHeightProperty() {
        return this.marginHeight;
    }

    public void setMarginLeft(int value) {
        this.marginLeftProperty().set(value);
    }

    public int getMarginLeft() {
        return this.marginLeftProperty().get();
    }

    public @NonNull IntegerProperty marginLeftProperty() {
        return this.marginLeft;
    }

    public void setMarginRight(int value) {
        this.marginRightProperty().set(value);
    }

    public int getMarginRight() {
        return this.marginRightProperty().get();
    }

    public @NonNull IntegerProperty marginRightProperty() {
        return this.marginRight;
    }

    public void setMarginTop(int value) {
        this.marginTopProperty().set(value);
    }

    public int getMarginTop() {
        return this.marginTopProperty().get();
    }

    public @NonNull IntegerProperty marginTopProperty() {
        return this.marginTop;
    }

    public void setMarginWidth(int value) {
        this.marginWidth.set(value);
    }

    public int getMarginWidth() {
        return this.marginWidthProperty().get();
    }

    public @NonNull IntegerProperty marginWidthProperty() {
        return this.marginWidth;
    }

    public void setPack(boolean value) {
        this.packProperty().set(value);
    }

    public boolean isPack() {
        return this.packProperty().get();
    }

    public @NonNull BooleanProperty packProperty() {
        return this.pack;
    }

    public void setSpacing(int value) {
        this.spacingProperty().set(value);
    }

    public int getSpacing() {
        return this.spacingProperty().get();
    }

    public @NonNull IntegerProperty spacingProperty() {
        return this.spacing;
    }

    public void setWrap(boolean value) {
        this.wrapProperty().set(value);
    }

    public boolean isWrap() {
        return this.wrapProperty().get();
    }

    public @NonNull BooleanProperty wrapProperty() {
        return this.wrap;
    }

    public void setHorizontal(boolean value) {
        this.horizontalProperty().set(value);
    }

    public boolean isHorizontal() {
        return this.horizontalProperty().get();
    }

    public @NonNull BooleanProperty horizontalProperty() {
        return this.horizontal;
    }
}

