/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.commands.table;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.dashboard.ui.views.GerritTableView;
import org.eclipse.egerrit.internal.model.ActionInfo;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DashboardFactoryHandler
extends AbstractHandler
implements IElementUpdater {
    private static Logger logger = LoggerFactory.getLogger(DashboardFactoryHandler.class);
    private ChangeInfo changeInfo = null;
    private RevisionInfo latestRevision = null;
    private GerritClient gerritClient = null;

    public void setEnabled(Object evaluationContext) {
        this.fillDataStructure();
        boolean state = true;
        this.setBaseEnabled(state);
    }

    public void updateElement(UIElement element, Map parameters) {
        this.fillDataStructure();
    }

    private void fillDataStructure() {
        GerritTableView reviewTableView = GerritTableView.getActiveView(true);
        TableViewer viewer = reviewTableView.getTableViewer();
        ISelection tableSelection = null;
        if (viewer != null) {
            tableSelection = viewer.getSelection();
        }
        this.gerritClient = reviewTableView.getGerritClient();
        if (tableSelection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)tableSelection).getFirstElement();
            if (obj instanceof ChangeInfo) {
                this.changeInfo = (ChangeInfo)obj;
                this.latestRevision = this.changeInfo.getRevision();
            } else {
                logger.debug("The selection does not contain a ChangeInfo");
                this.changeInfo = null;
                this.latestRevision = null;
            }
        } else {
            logger.debug("The selection does not contain a ChangeInfo");
            this.changeInfo = null;
            this.latestRevision = null;
        }
    }

    public GerritClient getGerritClient() {
        return this.gerritClient;
    }

    public ChangeInfo getChangeInfo() {
        return this.changeInfo;
    }

    public RevisionInfo getLatestRevision() {
        return this.latestRevision;
    }

    public ActionInfo getRevisionAction(String action) {
        return this.latestRevision != null ? (ActionInfo)this.latestRevision.getActions().get((Object)action) : null;
    }
}

