/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.core.ServersStore;
import org.eclipse.egerrit.internal.dashboard.GerritPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritServerUtility {
    private static Logger logger = LoggerFactory.getLogger(GerritServerUtility.class);
    private static final String LAST_GERRIT_FILE = "lastGerrit.txt";
    private static final String LAST_COMMANDS_FILE = "lastCommands.txt";
    private static final String ECLIPSE_GERRIT_DEFAULT = "https://git.eclipse.org/r/";
    private static final char SLASH = '/';
    private static GerritServerUtility fInstance = null;
    private GerritServerInformation lastServerCache = null;
    private int serversStoreTimestamp = -1;

    private GerritServerUtility() {
        fInstance = this;
    }

    private File getLastGerritFile(String aFile) {
        IPath ipath = GerritPlugin.getDefault().getStateLocation();
        String fileName = ipath.append(aFile).toPortableString();
        return new File(fileName);
    }

    private URL buildDocumentationURL(String aRequest) throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        GerritServerInformation lastSaved = GerritServerUtility.getInstance().getLastSavedGerritServer();
        sb.append(lastSaved != null ? lastSaved.getServerURI() : ECLIPSE_GERRIT_DEFAULT);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(aRequest);
        return new URL(sb.toString());
    }

    private String getEditorId(URL aUrl) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(aUrl.getFile());
        String id = null;
        if (desc != null) {
            id = desc.getId();
        }
        return id;
    }

    public static GerritServerUtility getInstance() {
        if (fInstance == null) {
            new GerritServerUtility();
        }
        return fInstance;
    }

    public boolean saveLastGerritServer(GerritServerInformation server) {
        if (this.lastServerCache != null && this.lastServerCache.equals((Object)server)) {
            return true;
        }
        boolean ok = true;
        File file = this.getLastGerritFile(LAST_GERRIT_FILE);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fw);
            out.write(Integer.toString(server.hashCode()));
            out.close();
            fw.close();
        }
        catch (IOException e1) {
            logger.debug("Saved last Gerrit server " + e1);
            ok = false;
        }
        return ok;
    }

    public GerritServerInformation getLastSavedGerritServer() {
        if (this.lastServerCache != null && ServersStore.getStoreTimeStamp() == this.serversStoreTimestamp) {
            return this.lastServerCache;
        }
        String lastServerId = null;
        File file = this.getLastGerritFile(LAST_GERRIT_FILE);
        if (file != null) {
            try {
                FileReader fr = new FileReader(file);
                BufferedReader in = new BufferedReader(fr);
                lastServerId = in.readLine();
                in.close();
                fr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.serversStoreTimestamp = ServersStore.getStoreTimeStamp();
        return ServersStore.getServer(lastServerId);
    }

    public void resetLastGerritServer() {
        this.lastServerCache = null;
        try {
            this.saveLastGerritServer(new GerritServerInformation("", ""));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public void openWebBrowser(String aDocumentation) {
        if (fInstance == null) {
            fInstance = GerritServerUtility.getInstance();
        }
        IWorkbenchBrowserSupport workBenchSupport = PlatformUI.getWorkbench().getBrowserSupport();
        URL url = null;
        try {
            url = this.buildDocumentationURL(aDocumentation);
            try {
                String id = this.getEditorId(url);
                workBenchSupport.createBrowser(id).openURL(url);
            }
            catch (PartInitException e) {
                logger.debug("PartInitException openWebBrowser for " + (Object)((Object)e));
            }
        }
        catch (MalformedURLException e1) {
            logger.debug("MalformedURLException openWebBrowser for " + e1);
        }
        logger.debug("openWebBrowser for " + url);
    }

    public Boolean saveLastCommandList(Set<String> aCommands) {
        Boolean ok = true;
        File file = this.getLastGerritFile(LAST_COMMANDS_FILE);
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fw);
            for (String s : aCommands) {
                out.write(s);
                out.newLine();
            }
            out.close();
            fw.close();
        }
        catch (IOException e1) {
            logger.debug("Saved last command  IOException " + e1);
            ok = false;
        }
        return ok;
    }

    public Set<String> getListLastCommands() {
        LinkedHashSet<String> lastCommands = new LinkedHashSet<String>();
        File file = this.getLastGerritFile(LAST_COMMANDS_FILE);
        if (file != null) {
            try {
                FileReader fr = new FileReader(file);
                BufferedReader in = new BufferedReader(fr);
                while (in.ready()) {
                    String line = in.readLine();
                    lastCommands.add(line);
                }
                in.close();
                fr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return lastCommands;
    }
}

