/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.utils;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.CreateDraftCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelHelpers;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.editors.ChangeDetailEditor;
import org.eclipse.egerrit.internal.ui.editors.FindLocalRepository;
import org.eclipse.egerrit.internal.ui.editors.OpenCompareEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.GerritToGitMapping;
import org.eclipse.egerrit.internal.ui.utils.MarkerRepositioner;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveWorkspaceRevision {
    private static final String MARKERS_KEY = "markertip";
    private static final String UI_EDITORS = "org.eclipse.ui.editors";
    private static final String QUICKDIFF_QUICKDIFF = "quickdiff.quickDiff";
    private static final String QUICKDIFF_DEFAULT = "quickdiff.defaultProvider";
    private static final String ADDITION_INDICATION_OVERVIEW_RULE = "additionIndicationInOverviewRule";
    private static final String CHANGE_INDICATION_OVERVIEW_RULE = "changeIndicationInOverviewRuler";
    private static final String DELETION_INDICATION_OVERVIEW_RULE = "deletionIndicationInOverviewRuler";
    private static Logger logger = LoggerFactory.getLogger(ChangeDetailEditor.class);
    private static final ActiveWorkspaceRevision INSTANCE = new ActiveWorkspaceRevision();
    private GerritClient fGerritClient = null;
    private ChangeInfo fChangeInfo = null;
    private RevisionInfo fRevisionInContext = null;
    private CommentAndDraftListener listener;
    private Map<String, IMarker> markersManaged = new HashMap<String, IMarker>();
    private boolean fIsAdditionIndicationInOverviewRule;
    private boolean fIsChangeIndicationInOverviewRuler;
    private boolean fIsDeletionIndicationInOverviewRuler;
    private boolean fIsQuickDiffOn;
    private String fDefaultProvider;
    private Repository fActiveRepository;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private ActiveWorkspaceRevision() {
    }

    public static ActiveWorkspaceRevision getInstance() {
        return INSTANCE;
    }

    public void activateCurrentRevision(GerritClient gerrit, RevisionInfo revisionInfo) {
        if (revisionInfo == null) {
            throw new IllegalArgumentException("Revision can't be null.");
        }
        if (this.fRevisionInContext != null && this.fRevisionInContext.getId().equals(revisionInfo.getId())) {
            return;
        }
        if (this.fRevisionInContext != null) {
            this.deactiveCurrentRevision();
        }
        this.fGerritClient = gerrit;
        this.fRevisionInContext = revisionInfo;
        this.fChangeInfo = revisionInfo.getChangeInfo();
        this.fActiveRepository = new FindLocalRepository(this.fGerritClient, this.fChangeInfo.getProject()).getRepository();
        this.forceLoadRevision();
        this.createMarkers();
        this.hookListeners();
        this.firePropertyChange("activeRevision", null, this.fRevisionInContext);
        boolean b = revisionInfo.isCommented();
        if (b) {
            this.openMarkerView(3);
        }
        this.enableQuickDiff();
        this.informUserAboutMarkers();
    }

    private void informUserAboutMarkers() {
        if (!this.fGerritClient.getRepository().getServerInfo().isAnonymous()) {
            String activeBranchId = this.getCurrentGitBranchId();
            String commitId = this.fRevisionInContext.getId();
            if (commitId.equals(activeBranchId)) {
                Display.getDefault().asyncExec(() -> UIUtils.showDialogTip(MARKERS_KEY, null, Messages.EGerriTip, Messages.ChangeDetailEditor_EGerriTipValue, null));
            } else {
                String reviewSelected = ".../" + this.fRevisionInContext.getChangeInfo().get_number() + "/" + this.fRevisionInContext.get_number();
                String note = NLS.bind((String)Messages.ActiveWorkspaceRevision_Note, (Object[])new String[]{this.getActiveBranchName(), reviewSelected});
                Display.getDefault().asyncExec(() -> UIUtils.showDialogTip(MARKERS_KEY, null, Messages.EGerriTip, Messages.ChangeDetailEditor_EGerriTipValue, note));
            }
        }
    }

    private boolean isProblemViewOpen() {
        IWorkbenchWindow[] listWW;
        IViewPart problemView = null;
        IWorkbenchWindow[] iWorkbenchWindowArray = listWW = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = listWW.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow element = iWorkbenchWindowArray[n2];
            problemView = element.getActivePage().findView("org.eclipse.ui.views.ProblemView");
            if (problemView != null) break;
            ++n2;
        }
        return problemView != null;
    }

    private void openMarkerView(int mode) {
        if (!this.isProblemViewOpen()) {
            IWorkbenchWindow[] listWW;
            IWorkbenchWindow[] iWorkbenchWindowArray = listWW = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = listWW.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow element = iWorkbenchWindowArray[n2];
                Display.getDefault().asyncExec(() -> {
                    try {
                        element.getActivePage().showView("org.eclipse.ui.views.AllMarkersView", null, mode);
                    }
                    catch (PartInitException e) {
                        EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
                    }
                });
                ++n2;
            }
        }
    }

    private void forceLoadRevision() {
        QueryHelpers.loadRevisionDetails(this.fGerritClient, this.fRevisionInContext);
    }

    private void hookListeners() {
        this.listener = new CommentAndDraftListener();
        this.fRevisionInContext.eAdapters().add((Object)this.listener);
    }

    public void newComment(CommentInfo newComment) {
        if (this.fRevisionInContext == null) {
            logger.debug("No active revision set.");
            return;
        }
        FileInfo fileInfo = this.getFileInfoInRevision(newComment.getPath());
        if (fileInfo == null) {
            logger.debug("Problem creating the marker. The active revision does not contain the expected file." + newComment.getPath());
            return;
        }
        CreateDraftCommand publishDraft = this.fGerritClient.createDraftComments(this.fChangeInfo.getId(), this.fRevisionInContext.getId());
        newComment.setSide("right");
        publishDraft.setCommandInput(newComment);
        newComment.setPath(fileInfo.getPath());
        try {
            fileInfo.getDraftComments().add((Object)((CommentInfo)publishDraft.call()));
        }
        catch (EGerritException e) {
            throw new RuntimeException(CommentableCompareItem.class.getName(), new Throwable(String.valueOf(this.hashCode())));
        }
    }

    private FileInfo getFileInfoInRevision(String workspacePath) {
        Collection files = this.fRevisionInContext.getFiles().values();
        for (FileInfo aFile : files) {
            if (aFile.getPath() == null || ("/" + aFile.getPath()).compareTo(workspacePath) != 0) continue;
            return aFile;
        }
        for (FileInfo aFile : files) {
            if (aFile.getPath() == null || !aFile.getPath().endsWith(workspacePath)) continue;
            return aFile;
        }
        return null;
    }

    public boolean isFilePartOfReview(String reviewFileName) {
        if (this.fRevisionInContext == null) {
            logger.debug("No active revision set.");
            return false;
        }
        return this.getFileInfoInRevision(reviewFileName) != null;
    }

    private void deleteAllMarkers() {
        HashSet<String> allMarkers = new HashSet<String>(this.markersManaged.keySet());
        for (String entry : allMarkers) {
            IMarker m = this.markersManaged.remove(entry);
            if (m == null) continue;
            try {
                m.delete();
            }
            catch (CoreException e) {
                logger.debug("Failed to delete marker", (Throwable)e);
            }
        }
    }

    private void createMarkers() {
        Collection files = this.fRevisionInContext.getFiles().values();
        this.deleteAllMarkers();
        for (FileInfo fileInfo : files) {
            EList sortedComments = ModelHelpers.sortComments((EList)fileInfo.getAllComments());
            boolean addingMarker = false;
            for (CommentInfo commentInfo : sortedComments) {
                this.addMarker(commentInfo);
                addingMarker = true;
            }
            if (!addingMarker) continue;
            this.openMarkerView(3);
        }
    }

    public void deactiveCurrentRevision() {
        if (this.fRevisionInContext == null) {
            return;
        }
        this.fRevisionInContext.eAdapters().remove((Object)this.listener);
        this.deleteAllMarkers();
        if (this.hasDrafts()) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            UIUtils.replyToChange(shell, this.fRevisionInContext, String.valueOf(Messages.ActiveWorkspaceRevision_0) + this.fRevisionInContext.getChangeInfo().getSubject() + "\"\n\n", this.fGerritClient, false, null);
        }
        this.deactivateQuickDiff();
        this.fRevisionInContext = null;
        this.firePropertyChange("activeRevision", null, null);
    }

    private void deactivateQuickDiff() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(UI_EDITORS);
        preferences.put(QUICKDIFF_QUICKDIFF, Boolean.toString(this.fIsQuickDiffOn));
        preferences.put(ADDITION_INDICATION_OVERVIEW_RULE, Boolean.toString(this.fIsAdditionIndicationInOverviewRule));
        preferences.put(CHANGE_INDICATION_OVERVIEW_RULE, Boolean.toString(this.fIsChangeIndicationInOverviewRuler));
        preferences.put(DELETION_INDICATION_OVERVIEW_RULE, Boolean.toString(this.fIsDeletionIndicationInOverviewRuler));
        preferences.put(QUICKDIFF_DEFAULT, this.fDefaultProvider);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e1) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
        }
    }

    private boolean hasDrafts() {
        Collection files = this.fRevisionInContext.getFiles().values();
        for (FileInfo fileInfo : files) {
            if (fileInfo.getDraftsCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private void addMarker(CommentInfo newComment) {
        IWorkspaceRoot workspaceFile = null;
        if (workspaceFile == null) {
            workspaceFile = new OpenCompareEditor(this.fGerritClient, this.fChangeInfo).getCorrespondingWorkspaceFile(ModelHelpers.getFileInfo((CommentInfo)newComment));
        }
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot();
        }
        try {
            IMarker commentMarker = workspaceFile.createMarker("org.eclipse.egerrit.ui.commentMarker");
            if (workspaceFile == ResourcesPlugin.getWorkspace().getRoot()) {
                commentMarker.setAttribute("message", (Object)(String.valueOf(this.resourceMissingMessage(newComment)) + UIUtils.formatMessageForMarkerView(newComment, 0)));
            } else {
                int lineNumber = this.getLine(newComment);
                commentMarker.setAttribute("lineNumber", Math.abs(lineNumber));
                commentMarker.setAttribute("message", (Object)UIUtils.formatMessageForMarkerView(newComment, lineNumber));
            }
            commentMarker.setAttribute("priority", 1);
            commentMarker.setAttribute("severity", 0);
            commentMarker.setAttribute("commentInfo", (Object)newComment);
            commentMarker.setAttribute("fileInfo", (Object)newComment);
            commentMarker.setAttribute("gerritClient", (Object)this.fGerritClient);
            commentMarker.setAttribute("isDraft", newComment.getAuthor() == null);
            this.markersManaged.put(newComment.getId(), commentMarker);
        }
        catch (CoreException e) {
            logger.debug("Failed to create marker", (Throwable)e);
        }
    }

    private int getLine(CommentInfo comment) {
        block3: {
            try {
                if (comment.getLine() != 0) break block3;
                return 1;
            }
            catch (Exception e) {
                return comment.getLine();
            }
        }
        Repository repo = new GerritToGitMapping(new URIish(this.fGerritClient.getRepository().getURIBuilder(false).toString()), this.fChangeInfo.getProject()).find();
        int newPosition = new MarkerRepositioner(repo, ModelHelpers.getFileInfo((CommentInfo)comment).getPath()).getNewPositionFor(comment.getLine());
        return newPosition == 0 ? -1 : newPosition;
    }

    private String resourceMissingMessage(CommentInfo comment) {
        return NLS.bind((String)Messages.ActiveWorkspaceRevision_1, (Object)ModelHelpers.getFileInfo((CommentInfo)comment).getPath());
    }

    public RevisionInfo getActiveRevision() {
        return this.fRevisionInContext;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private void enableQuickDiff() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(UI_EDITORS);
        this.fIsQuickDiffOn = Platform.getPreferencesService().getBoolean(UI_EDITORS, QUICKDIFF_QUICKDIFF, false, null);
        this.fIsAdditionIndicationInOverviewRule = Platform.getPreferencesService().getBoolean(UI_EDITORS, ADDITION_INDICATION_OVERVIEW_RULE, false, null);
        this.fIsChangeIndicationInOverviewRuler = Platform.getPreferencesService().getBoolean(UI_EDITORS, CHANGE_INDICATION_OVERVIEW_RULE, false, null);
        this.fIsDeletionIndicationInOverviewRuler = Platform.getPreferencesService().getBoolean(UI_EDITORS, DELETION_INDICATION_OVERVIEW_RULE, false, null);
        this.fDefaultProvider = Platform.getPreferencesService().getString(UI_EDITORS, QUICKDIFF_DEFAULT, "", null);
        preferences.putBoolean(QUICKDIFF_QUICKDIFF, true);
        preferences.putBoolean(ADDITION_INDICATION_OVERVIEW_RULE, true);
        preferences.putBoolean(CHANGE_INDICATION_OVERVIEW_RULE, true);
        preferences.putBoolean(DELETION_INDICATION_OVERVIEW_RULE, true);
        preferences.put(QUICKDIFF_DEFAULT, "org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider");
        try {
            preferences.flush();
        }
        catch (BackingStoreException e1) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
        }
        try {
            GitQuickDiffProvider.setBaselineReference((Repository)this.fActiveRepository, (String)"HEAD^1");
        }
        catch (IOException e1) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
        }
    }

    public GerritClient getGerritClient() {
        return this.fGerritClient;
    }

    private String getActiveBranchName() {
        String branchName = null;
        try {
            branchName = this.fActiveRepository != null ? this.fActiveRepository.getBranch() : null;
        }
        catch (IOException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
        }
        return branchName;
    }

    private String getCurrentGitBranchId() {
        String branchId = null;
        if (this.getActiveBranchName() != null) {
            Ref ref = null;
            try {
                ref = this.fActiveRepository.findRef(this.getActiveBranchName());
            }
            catch (IOException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
            }
            if (ref != null) {
                branchId = ref.getObjectId().getName();
            }
        }
        return branchId;
    }

    private final class CommentAndDraftListener
    extends EContentAdapter {
        private CommentAndDraftListener() {
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getFeature() == null) {
                return;
            }
            if (msg.getFeature().equals(ModelPackage.Literals.FILE_INFO__COMMENTS) || msg.getFeature().equals(ModelPackage.Literals.FILE_INFO__DRAFT_COMMENTS)) {
                if (msg.getEventType() == 3) {
                    ActiveWorkspaceRevision.this.addMarker((CommentInfo)msg.getNewValue());
                    ActiveWorkspaceRevision.this.openMarkerView(3);
                }
                if (msg.getEventType() == 4) {
                    this.deleteMarker((CommentInfo)msg.getOldValue());
                }
            }
        }

        private void deleteMarker(CommentInfo commentToDelete) {
            IMarker marker = (IMarker)ActiveWorkspaceRevision.this.markersManaged.remove(commentToDelete.getId());
            if (marker != null) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    logger.debug("Failed to delete marker", (Throwable)e);
                }
            }
        }
    }
}

