/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.runner.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.descriptor.GenericDescriptor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.descriptor.pattern.helper.IPatternDescriptorHandler;
import org.eclipse.egf.common.descriptor.pattern.helper.PatternDescriptorStrategy;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.MathHelper;
import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.common.progress.ProductionProgressMonitor;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.core.context.ProductionContext;
import org.eclipse.egf.core.task.AbstractTask;
import org.eclipse.egf.core.ui.EgfUiActivator;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ecore.PatternSeeker;
import org.eclipse.egf.pattern.execution.IPatternExecutionReporter;
import org.eclipse.egf.pattern.execution.PatternExecutionHelper;
import org.eclipse.egf.pattern.runner.task.Messages;
import org.eclipse.egf.pattern.validation.PatternValidationHelper;
import org.eclipse.egf.pde.pattern.reader.PlatformPatternExtensionReader;
import org.eclipse.egf.pde.pattern.reader.WorkspacePatternExtensionReader;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternElementRunnerTask
extends AbstractTask {
    private static final Logger __logger = Logger.getLogger((String)PatternElementRunnerTask.class.getPackage().getName());
    private static final String PATTERN_ELEMENT_FULL_ID = "patternOrLibraryFullId";
    private static final String PATTERN_EXECUTION_REPORTER = "executionReporter";
    private static final String MODEL_PATH = "modelPath";
    private PatternSeeker _seeker;

    protected boolean doExecute(IProgressMonitor progressMonitor_p) {
        IPatternExecutionReporter executionReporter = this.getPatternExecutionReporter();
        Resource model = this.getModel();
        String patternElementFullId = this.getPatternElementFullId();
        if (patternElementFullId == null) {
            return false;
        }
        if (this._seeker == null) {
            this._seeker = new PatternSeeker(false);
        }
        int allocatedTicksCount = this.getTicksCount();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor_p, (String)patternElementFullId, (int)allocatedTicksCount);
        int lookUpTicksCount = MathHelper.multiply((int)allocatedTicksCount, (float)0.1f);
        List<String> patternFullIds = this.lookupPatterns(patternElementFullId);
        subMonitor.worked(lookUpTicksCount);
        int patternsTicksCount = allocatedTicksCount - lookUpTicksCount;
        subMonitor.setWorkRemaining(patternsTicksCount);
        return this.runPatterns(patternFullIds, model, executionReporter, subMonitor, patternsTicksCount);
    }

    protected boolean runPatterns(List<String> patternFullIds_p, Resource model_p, IPatternExecutionReporter reporter_p, SubMonitor monitor_p, int totalWork_p) {
        boolean isOk = true;
        ProductionContext context = this.getProductionContext();
        int stepCount = totalWork_p / patternFullIds_p.size();
        HashMap<PatternExecutionHelper.ArgumentKey, Object> argument = new HashMap<PatternExecutionHelper.ArgumentKey, Object>(3);
        argument.put(PatternExecutionHelper.ArgumentKey.EMF_RESOURCE, model_p);
        argument.put(PatternExecutionHelper.ArgumentKey.PRODUCTION_CONTEXT, context);
        argument.put(PatternExecutionHelper.ArgumentKey.EXECUTION_REPORTER, reporter_p);
        Iterator<String> patternFullIds = patternFullIds_p.iterator();
        while (patternFullIds.hasNext() && isOk) {
            String currentPatternId = patternFullIds.next();
            String message = MessageFormatHelper.formatMessage((String)Messages.PatternElementRunnerTask_Execution_Title, (Object[])new String[]{currentPatternId});
            ProductionProgressMonitor currentPatternMonitor = new ProductionProgressMonitor(monitor_p, message, stepCount);
            isOk = this.runPattern(currentPatternId, argument);
            currentPatternMonitor.end();
        }
        return isOk;
    }

    protected boolean runPattern(String patternFullId_p, Map<PatternExecutionHelper.ArgumentKey, Object> data_p) {
        boolean isOk = false;
        IPreferenceStore preferenceStore = EgfUiActivator.getDefault().getPreferenceStore();
        boolean validationRequested = preferenceStore.getBoolean("Pattern_Execution_Mode");
        boolean executionGranted = true;
        if (validationRequested) {
            List patternsData = this._seeker.getPatternsData(patternFullId_p);
            Pattern pattern = ((PatternHandler.PatternData)patternsData.get(0)).getPattern();
            final Object[] patternName = new Object[]{pattern.getName()};
            final Diagnostic validatePattern = PatternValidationHelper.validatePattern((Pattern)pattern, null);
            if (4 == validatePattern.getSeverity()) {
                executionGranted = false;
                final Display display = PlatformUI.getWorkbench().getDisplay();
                final String validationErrorMessage = StringHelper.formatMessage((String)Messages.PatternElementRunnerTask_Validation_ErrorMessage, (Object[])patternName);
                if (display != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            DiagnosticDialog.open((Shell)display.getActiveShell(), (String)StringHelper.formatMessage((String)Messages.PatternElementRunnerTask_Validation_ErrorTitle, (Object[])patternName), (String)validationErrorMessage, (Diagnostic)validatePattern);
                        }
                    });
                } else {
                    StringBuilder loggerMessage = new StringBuilder("PatternElementRunnerTask.runPattern(..) _ ");
                    loggerMessage.append(validationErrorMessage).append('\n');
                    loggerMessage.append(validatePattern.getMessage());
                    __logger.warn((Object)loggerMessage.toString());
                }
            } else if (__logger.isDebugEnabled()) {
                StringBuilder loggerMessage = new StringBuilder("PatternElementRunnerTask.runPattern(..) _ ");
                loggerMessage.append(StringHelper.formatMessage((String)Messages.PatternElementRunnerTask_Validation_OkLogMessage, (Object[])patternName));
                __logger.debug((Object)loggerMessage.toString());
            }
        }
        try {
            if (executionGranted) {
                PatternExecutionHelper.doRunPattern((String)patternFullId_p, data_p);
                isOk = true;
            }
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("PatternElementRunnerTask.runPattern(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return isOk;
    }

    private List<String> lookupPatterns(String patternElementFullId_p) {
        IDescriptor rootDescriptor = this.getAllPatternLibraries();
        PatternDescriptorHandler patternDescriptorHandler = new PatternDescriptorHandler(patternElementFullId_p);
        PatternDescriptorStrategy strategy = new PatternDescriptorStrategy();
        strategy.iterateThroughPatternExtensionDescriptor((IPatternDescriptorHandler)patternDescriptorHandler, rootDescriptor);
        return patternDescriptorHandler.getOrderedPatternIds();
    }

    private IDescriptor getAllPatternLibraries() {
        GenericDescriptor rootDescriptor = new GenericDescriptor();
        PatternDescriptorStrategy.retainRootOnly((GenericDescriptor)rootDescriptor, (IDescriptor)new WorkspacePatternExtensionReader().getPatternLibraries());
        PatternDescriptorStrategy.retainRootOnly((GenericDescriptor)rootDescriptor, (IDescriptor)new PlatformPatternExtensionReader().getPatternLibraries());
        return rootDescriptor;
    }

    protected String getPatternElementFullId() {
        String fullId = (String)this.getContextElementValue(PATTERN_ELEMENT_FULL_ID);
        return fullId;
    }

    protected IPatternExecutionReporter getPatternExecutionReporter() {
        return (IPatternExecutionReporter)this.getContextElementValue(PATTERN_EXECUTION_REPORTER);
    }

    protected Resource getModel() {
        URI modelURI;
        Resource resource = null;
        String modelPath = this.getModelPath();
        if (modelPath != null && (modelURI = FileHelper.getFileFullUri((String)modelPath)) != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                long startTime = System.currentTimeMillis();
                resource = resourceSet.getResource(modelURI, true);
                long duration = System.currentTimeMillis() - startTime;
                if (__logger.isDebugEnabled()) {
                    StringBuilder loggerMessage = new StringBuilder("PatternElementRunnerTask.getModel(..) _ ");
                    loggerMessage.append("Loading ressource elapsed time (in ms) ").append(duration);
                    __logger.debug((Object)loggerMessage.toString());
                }
            }
            catch (RuntimeException exception_p) {
                StringBuilder loggerMessage = new StringBuilder("PatternElementRunnerTask.getDomain(..) _ ");
                __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
            }
        }
        return resource;
    }

    protected String getModelPath() {
        return (String)this.getContextElementValue(MODEL_PATH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PatternDescriptorHandler
    implements IPatternDescriptorHandler {
        private String _searchedPatternElementFullId;
        private List<String> _orderedPatternElementIds;
        private Map<String, String> _orchestratedLibraries;
        private Map<String, List<String>> _involvedLibraries;

        public PatternDescriptorHandler(String searchedPatternElementFullId_p) {
            this._searchedPatternElementFullId = searchedPatternElementFullId_p;
            this._orderedPatternElementIds = new ArrayList<String>(0);
            this._orchestratedLibraries = new HashMap<String, String>(0);
            this._involvedLibraries = new HashMap<String, List<String>>(0);
        }

        public List<String> getOrderedPatternIds() {
            return this.computePatternsOrder();
        }

        private List<String> computePatternsOrder() {
            ArrayList<String> orderedPatternList = new ArrayList<String>(0);
            for (String currentElementFullId : this._orderedPatternElementIds) {
                this.addPatternElement(currentElementFullId, orderedPatternList);
            }
            return orderedPatternList;
        }

        private void addPatternElement(String patternElementId_p, List<String> resultingPatterns_p) {
            if (this.isPattern(patternElementId_p)) {
                resultingPatterns_p.add(patternElementId_p);
            } else {
                String runtimeOrchestration = this._orchestratedLibraries.get(patternElementId_p);
                if (runtimeOrchestration != null) {
                    String[] patternElementIds;
                    String[] stringArray = patternElementIds = StringHelper.getTokens((String)runtimeOrchestration, (String)" ,");
                    int n = patternElementIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String patternElementId = stringArray[n2];
                        this.addPatternElement(patternElementId, resultingPatterns_p);
                        ++n2;
                    }
                } else {
                    List<String> containedElements = this._involvedLibraries.get(patternElementId_p);
                    for (String containedElement : containedElements) {
                        this.addPatternElement(containedElement, resultingPatterns_p);
                    }
                }
            }
        }

        private boolean isPattern(String patternElementId_p) {
            return !this._orchestratedLibraries.containsKey(patternElementId_p) && !this._involvedLibraries.containsKey(patternElementId_p);
        }

        public void handleDescriptor(IDescriptor descriptor_p) {
        }

        public void handleLibraryDescriptor(IDescriptor descriptor_p, String libraryFullId_p) {
            if (!libraryFullId_p.startsWith(this._searchedPatternElementFullId)) {
                return;
            }
            String runtimeOrchestration = (String)descriptor_p.getValue("runtimeOrchestration");
            if (runtimeOrchestration != null) {
                this._orchestratedLibraries.put(libraryFullId_p, runtimeOrchestration);
            } else {
                this._involvedLibraries.put(libraryFullId_p, new ArrayList(0));
            }
            String parentLibraryId = (String)PatternHelper.deresolveId((String)libraryFullId_p).getKey();
            if (parentLibraryId.equals(libraryFullId_p)) {
                parentLibraryId = null;
            }
            List<String> siblingElements = this._involvedLibraries.get(parentLibraryId);
            if (!this._orchestratedLibraries.containsKey(parentLibraryId)) {
                if (siblingElements == null) {
                    this._orderedPatternElementIds.add(libraryFullId_p);
                } else {
                    siblingElements.add(libraryFullId_p);
                }
            }
        }

        public void handlePatternDescriptor(IDescriptor descriptor_p, String patternFullId_p) {
            if (!patternFullId_p.startsWith(this._searchedPatternElementFullId)) {
                return;
            }
            String parentLibraryId = (String)PatternHelper.deresolveId((String)patternFullId_p).getKey();
            if (!this._orchestratedLibraries.containsKey(parentLibraryId)) {
                List<String> siblingElements = this._involvedLibraries.get(parentLibraryId);
                if (siblingElements != null) {
                    siblingElements.add(patternFullId_p);
                } else {
                    this._orderedPatternElementIds.add(patternFullId_p);
                }
            }
        }
    }
}

