/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.explorer.delete;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.ui.helper.WorkbenchHelper;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.explorer.delete.DeleteModelElementAction;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ui.editor.PatternEditorHelper;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletePatternAction
extends DeleteModelElementAction {
    private static final Logger __logger = Logger.getLogger((String)DeletePatternAction.class.getPackage().getName());
    private boolean _refreshProject = true;

    public DeletePatternAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
    }

    @Override
    protected String[] getConfirmDeleteMessage() {
        String[] message = new String[]{Messages.DeletePatternAction_Message, this.getModelElement().getName()};
        return message;
    }

    @Override
    protected Class<?> getModelElementClass() {
        return PatternModel.class;
    }

    @Override
    protected boolean closeEditor(NamedModelElementWithId modelElement_p) {
        IEditorPart patternEditorPart = PatternEditorHelper.isPatternEditorOpen((PatternModel)this.getPatternModel());
        boolean canDeletePattern = true;
        if (patternEditorPart != null) {
            canDeletePattern = WorkbenchHelper.closeEditor((IEditorPart)patternEditorPart, (boolean)false);
        }
        return canDeletePattern;
    }

    private PatternModel getPatternModel() {
        return (PatternModel)this.getModelElement();
    }

    @Override
    protected void doDeleteModelElement() {
        PatternModel pattern = this.getPatternModel();
        IProject project = null;
        if (this._refreshProject) {
            project = ModelHelper.getProject((NamedModelElementWithId)pattern);
        }
        super.doDeleteModelElement();
        PatternHandler patternHandler = this.getPatternHandler(pattern);
        patternHandler.delete();
        if (this._refreshProject) {
            ProjectHelper.refreshProject((IProject)project, (int)2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected PatternHandler getPatternHandler(PatternModel pattern_p) {
        PatternHandler patternHandler = null;
        if (pattern_p == null) {
            return patternHandler;
        }
        try {
            patternHandler = new PatternHandler();
            patternHandler.load(pattern_p.getPath());
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("DeletePatternAction.delete(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return patternHandler;
    }

    public void setRefreshProject(boolean refresh_p) {
        this._refreshProject = refresh_p;
    }
}

