/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page.implementation;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.ui.helper.WorkbenchHelper;
import org.eclipse.egf.console.EGFConsolePlugin;
import org.eclipse.egf.pattern.ecore.AnnotationHandler;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.egf.pattern.ui.PatternUiActivator;
import org.eclipse.egf.pattern.ui.editor.jet.PatternJETEditor;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.InternalMethodHandler;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;

public class InternalMethodHelper {
    private static boolean DEBUG = PatternUiActivator.getDefault().isDebugging();

    public static void openMethodContent(PatternHandler.PatternData patternData_p, InternalMethodHandler handler_p, boolean editable_p) {
        boolean openEditor;
        String methodName = handler_p.getMethodName();
        AnnotationHandler handler = new AnnotationHandler();
        String operationUid = handler.getUid(handler_p.getMethod());
        if (operationUid == null) {
            operationUid = methodName;
        }
        String fileRelativePath = TemplateHelper.getTemplateRelativePath((String)patternData_p.getPattern().getShortId(), (String)patternData_p.getPluginId(), (String)methodName, (String)operationUid);
        FileHelper.getFileFullUri((String)fileRelativePath);
        boolean bl = openEditor = !editable_p;
        if (!openEditor && !(openEditor = FileHelper.exists((String)fileRelativePath))) {
            openEditor = FileHelper.writeFile((String)fileRelativePath, (boolean)true, (String)"");
        }
        if (openEditor) {
            IEditorPart openFileEditor;
            if (editable_p) {
                try {
                    patternData_p.getJavaProject().getProject().refreshLocal(2, null);
                }
                catch (CoreException ce) {
                    PatternUiActivator.getDefault().log(ce);
                    if (DEBUG) {
                        EGFConsolePlugin.getConsole().logThrowable(NLS.bind((String)"Unable to refresh project ''{0}''", (Object)patternData_p.getJavaProject().getProject().getName()), (Throwable)ce);
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    return;
                }
            }
            if ((openFileEditor = WorkbenchHelper.openFileEditor((String)fileRelativePath, (String)PatternJETEditor.EDITOR_ID, (boolean)editable_p)) != null) {
                String templateFullName = String.valueOf(patternData_p.getPattern().getName()) + '.' + methodName;
                ((PatternJETEditor)openFileEditor).setPartName(templateFullName);
            }
        }
    }

    public static InternalMethodHandler[] getInternalMethodsFromInput(PatternHandler.PatternData patternData_p, IInternalMethodHandlerFactory factory_p) {
        InternalMethodHandler[] result = null;
        ArrayList<InternalMethodHandler> handlers = new ArrayList<InternalMethodHandler>(0);
        EList operations = patternData_p.getPattern().getEOperations();
        for (EOperation operation : operations) {
            String operationName = operation.getName();
            if ("generateBody".equals(operationName) || "generatePreMatching".equals(operationName) || "generatePostMatching".equals(operationName)) continue;
            handlers.add(factory_p.createNewHandler(operation));
        }
        result = handlers.toArray(new InternalMethodHandler[handlers.size()]);
        return result;
    }

    public static interface IInternalMethodHandlerFactory {
        public InternalMethodHandler createNewHandler(EOperation var1);
    }
}

