/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.internal.editor.page.implementation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.common.ui.viewers.IContentHandler;
import org.eclipse.egf.common.ui.viewers.IOrderedContentProvider;
import org.eclipse.egf.common.ui.viewers.OrderedListViewerWithAddAndRemove;
import org.eclipse.egf.pattern.ecore.AnnotationHandler;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationListener;
import org.eclipse.egf.pattern.ui.internal.editor.IPatternModificationNotification;
import org.eclipse.egf.pattern.ui.internal.editor.page.AbstractPatternPageContentProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.MethodActionHandler;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.MethodPatternCodeLabelProvider;
import org.eclipse.egf.pattern.ui.internal.editor.page.implementation.wizard.PatternCodeActionWizard;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPatternCodeViewer
extends OrderedListViewerWithAddAndRemove
implements DisposeListener {
    protected AbstractPatternPage _page;
    protected MethodPatternCodeContentHandler _contentHandler;
    private MethodPatternCodeContentProvider _contentProvider;
    private MethodPatternCodeLabelProvider _labelProvider;
    private List<String> _availableActions;
    private boolean _allowNextAndBack;
    private boolean _recomputeOnChanges;

    public MethodPatternCodeViewer(AbstractPatternPage patternPage_p, Composite parent_p) {
        super(parent_p);
        this._page = patternPage_p;
        this._labelProvider.setPatternData(this._page.getPatternData());
        this._contentHandler.setPatternPage(this._page);
    }

    protected AbstractPatternPage getPage() {
        return this._page;
    }

    protected StructuredViewer createViewer(Composite composite_p) {
        FormToolkit toolkit = new FormToolkit(composite_p.getDisplay());
        Composite listComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit, (Composite)composite_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)false);
        ListViewer viewer = new ListViewer(listComposite, 2820);
        Control listControl = viewer.getControl();
        listControl.addDisposeListener((DisposeListener)this);
        FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)listControl, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT);
        this._contentHandler = new MethodPatternCodeContentHandler();
        this._contentProvider = new MethodPatternCodeContentProvider();
        viewer.setContentProvider((IContentProvider)this._contentProvider);
        this._labelProvider = new MethodPatternCodeLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        toolkit.adapt(listComposite);
        return viewer;
    }

    protected SelectionChangedHandler createRemoveButtonHandler() {
        SelectionChangedHandler result = new SelectionChangedHandler(){

            protected boolean doHandleSelection(ISelection selection_p) {
                boolean enabled = selection_p instanceof IStructuredSelection;
                if (!enabled) {
                    return enabled;
                }
                Object selectedElement = ((IStructuredSelection)selection_p).getFirstElement();
                boolean bl = enabled = selectedElement != null;
                if (enabled) {
                    String actionType = (String)((MethodActionHandler)selectedElement).getAction().getKey();
                    enabled = !"READ".equals(actionType);
                }
                return enabled;
            }
        };
        return result;
    }

    public void initialize(List<String> availableActions_p, boolean allowNextAndBack_p, boolean recomputeOnChanges_p) {
        this._availableActions = availableActions_p;
        this._allowNextAndBack = allowNextAndBack_p;
        this._recomputeOnChanges = recomputeOnChanges_p;
        if (this._page != null && this._contentProvider != null) {
            this._page.getEditor().addPatternModificationListener(this._contentProvider);
        }
    }

    public void widgetDisposed(DisposeEvent e_p) {
        if (this._page != null && this._contentProvider != null) {
            this._page.getEditor().removePatternModificationListener(this._contentProvider);
        }
    }

    public void setInput(EOperation method_p) {
        StructuredViewer viewer = this.getDecoratedViewer();
        if (viewer != null) {
            this._contentHandler.setMethod(method_p);
            viewer.setInput((Object)method_p);
        }
    }

    public void setSelection(ISelection selection_p) {
        StructuredViewer viewer = this.getDecoratedViewer();
        if (viewer != null) {
            viewer.setSelection(selection_p);
        }
    }

    public void savePatternCode() {
        this._contentHandler.savePatternCodeAnnotation();
    }

    protected IContentHandler getContentHandler() {
        return this._contentHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MethodPatternCodeContentHandler
    extends DefaultContentHandler {
        private EOperation _method;
        private AnnotationHandler _annotationHandler;
        private List<MethodActionHandler> _actions;

        protected MethodPatternCodeContentHandler() {
            super(null, null);
            this._annotationHandler = new AnnotationHandler();
        }

        protected boolean isHandlerFor(EOperation method_p) {
            boolean result;
            boolean bl = result = this._method != null && this._method.equals(method_p);
            if (result) {
                return result;
            }
            result = !this.getHandlersFor(method_p).isEmpty();
            return result;
        }

        protected List<MethodActionHandler> getHandlersFor(EOperation method_p) {
            Assert.isNotNull(this._actions);
            Assert.isNotNull((Object)method_p);
            ArrayList<MethodActionHandler> result = new ArrayList<MethodActionHandler>(0);
            for (MethodActionHandler actionHandler : this._actions) {
                if (method_p != actionHandler.getPointedElement()) continue;
                result.add(actionHandler);
            }
            return result;
        }

        protected void setMethod(EOperation method_p) {
            this._method = method_p;
            if (this._actions != null) {
                this._actions.clear();
            }
        }

        protected List<MethodActionHandler> getActions() {
            if (this._actions == null || this._actions.isEmpty()) {
                List actionsAsCouples = this._annotationHandler.getOrderedActionsFor(this._method);
                this._actions = new ArrayList<MethodActionHandler>(actionsAsCouples.size());
                for (Couple action : actionsAsCouples) {
                    MethodActionHandler methodHandler = new MethodActionHandler(this.getPatternData(), (Couple<String, String>)action);
                    this.resolvePointedElement(methodHandler);
                    this._actions.add(methodHandler);
                }
            }
            return this._actions;
        }

        protected void resolvePointedElement(MethodActionHandler methodHandler_p) {
            Assert.isNotNull((Object)methodHandler_p);
            Couple<String, String> action = methodHandler_p.getAction();
            Assert.isNotNull(action);
            String actionType = (String)action.getKey();
            if ("CALL".equals(actionType)) {
                String methodName = (String)action.getValue();
                EList existingOperations = this.getPattern().getEOperations();
                for (EOperation operation : existingOperations) {
                    if (!operation.getName().equals(methodName)) continue;
                    methodHandler_p.setPointedElement(operation);
                    break;
                }
            }
        }

        private List<Couple<String, String>> extractActionsAsCouples() {
            Assert.isNotNull(this._actions);
            ArrayList<Couple<String, String>> actionsAsCouples = new ArrayList<Couple<String, String>>(this._actions.size());
            for (MethodActionHandler actionHandler : this._actions) {
                actionsAsCouples.add(actionHandler.getAction());
            }
            return actionsAsCouples;
        }

        protected void savePatternCodeAnnotation() {
            List<Couple<String, String>> actionsAsCouples = this.extractActionsAsCouples();
            this._annotationHandler.recomputeAnnotationFromActions(this._method, actionsAsCouples);
        }

        @Override
        protected void notifyModification() {
            if (MethodPatternCodeViewer.this._recomputeOnChanges) {
                this.savePatternCodeAnnotation();
            }
            super.notifyModification();
        }

        protected List<MethodActionHandler> removeActionsUsing(EOperation method_p) {
            Assert.isNotNull(this._actions);
            ArrayList<MethodActionHandler> removedActions = new ArrayList<MethodActionHandler>(0);
            removedActions.addAll(this._actions);
            for (MethodActionHandler actionHandler : this._actions) {
                if (actionHandler.getPointedElement() == method_p) continue;
                removedActions.remove(actionHandler);
            }
            this._actions.removeAll(removedActions);
            this.notifyModification();
            return removedActions;
        }

        @Override
        public Object createNewElement() {
            MethodActionHandler result = new MethodActionHandler(this.getPatternData(), (Couple<String, String>)new Couple(null, null));
            WizardDialog wizardDialog = new WizardDialog(MethodPatternCodeViewer.this._page.getSite().getShell(), (IWizard)new PatternCodeActionWizard(MethodPatternCodeViewer.this._page.getPatternData(), result.getAction(), MethodPatternCodeViewer.this._availableActions, MethodPatternCodeViewer.this._allowNextAndBack));
            int returnCode = wizardDialog.open();
            if (returnCode == 0) {
                this.resolvePointedElement(result);
                this._actions.add(result);
                this.notifyModification();
            } else {
                result = null;
            }
            return result;
        }

        @Override
        public void removeElement(Object element_p) {
            this._actions.remove(element_p);
            this.notifyModification();
        }

        protected void swapElements(int firstIndex_p, int secondIndex_p) {
            Collections.swap(this._actions, firstIndex_p, secondIndex_p);
            this.notifyModification();
        }
    }

    protected class MethodPatternCodeContentProvider
    extends AbstractPatternPageContentProvider
    implements IOrderedContentProvider,
    IPatternModificationListener {
        protected MethodPatternCodeContentProvider() {
        }

        protected ListViewer getViewer() {
            return (ListViewer)super.getViewer();
        }

        protected void doDispose() {
        }

        protected void doHandleElementUpdated(Object oldInput_p, Object newInput_p) {
            this.getViewer().update(newInput_p, null);
        }

        protected void doHandleElementsAdded(Object addedElements_p) {
            this.getViewer().add(addedElements_p);
        }

        protected void doHandleElementsRemoved(Object removedElements_p) {
            this.getViewer().remove(removedElements_p);
        }

        public void swap(int elementPosition1_p, int elementPosition2_p) {
            MethodPatternCodeViewer.this._contentHandler.swapElements(elementPosition1_p, elementPosition2_p);
            this.getViewer().refresh();
        }

        public Object[] getElements(Object inputElement_p) {
            Object[] result = null;
            if (inputElement_p instanceof EOperation) {
                result = MethodPatternCodeViewer.this._contentHandler.getActions().toArray();
            }
            return result;
        }

        public void notifyChanged(IPatternModificationNotification notification_p) {
            Object notifier;
            int type = notification_p.getEventType();
            if (2 == type) {
                Object oldValue = notification_p.getOldValue();
                if (oldValue instanceof EOperation) {
                    this.methodRemoved((EOperation)oldValue);
                }
            } else if (3 == type) {
                Object notifier2 = notification_p.getNotifier();
                if (notifier2 instanceof EOperation) {
                    EOperation operation = (EOperation)notifier2;
                    this.methodNameChanged(operation, (String)notification_p.getOldValue(), (String)notification_p.getNewValue());
                }
            } else if (4 == type && (notifier = notification_p.getNotifier()) instanceof MethodActionHandler) {
                MethodActionHandler handler = (MethodActionHandler)notifier;
                this.parameterSwitched(handler);
            }
        }

        protected void parameterSwitched(MethodActionHandler patternCodeAction_p) {
            Assert.isNotNull((Object)patternCodeAction_p);
            MethodPatternCodeViewer.this._contentHandler.resolvePointedElement(patternCodeAction_p);
            this.getViewer().refresh((Object)patternCodeAction_p);
        }

        protected void methodNameChanged(EOperation method_p, String oldMethodName_p, String newMethodName_p) {
            if (MethodPatternCodeViewer.this._contentHandler.isHandlerFor(method_p)) {
                List<MethodActionHandler> handlers = MethodPatternCodeViewer.this._contentHandler.getHandlersFor(method_p);
                if (!handlers.isEmpty()) {
                    for (MethodActionHandler actionHandler : handlers) {
                        actionHandler.getAction().setValue((Object)((EOperation)actionHandler.getPointedElement()).getName());
                        this.getViewer().refresh((Object)actionHandler);
                    }
                } else {
                    this.getViewer().refresh();
                }
            }
        }

        protected void methodRemoved(EOperation removedMethod_p) {
            Assert.isNotNull((Object)removedMethod_p);
            List<MethodActionHandler> removedActions = MethodPatternCodeViewer.this._contentHandler.removeActionsUsing(removedMethod_p);
            if (removedActions != null && !removedActions.isEmpty()) {
                for (MethodActionHandler actionHandler : removedActions) {
                    this.doHandleElementsRemoved(actionHandler);
                }
            }
        }
    }
}

