/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.emf.generator.common.task;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.task.AbstractTask;
import org.eclipse.egf.core.ui.actions.AbstractGenerateCodeOperation;
import org.eclipse.egf.fc.generator.java.model.AbstractGenModelGeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;

public abstract class AbstractEmfGeneratorTask
extends AbstractTask {
    private static final Logger __logger = Logger.getLogger((String)AbstractEmfGeneratorTask.class.getPackage().getName());
    private static final String ECORE_MODEL_PATH = "modelRelativePath";
    private static final String GENERATOR_ADAPTER_FACTORY = "generatorAdapterFactory";
    private static final String MERGE_RULES_RELATIVE_PATH = "mergeRulesPath";

    protected boolean doExecute(IProgressMonitor progressMonitor_p) {
        AbstractGenerateCodeOperation operation = this.getEmfGenerateCodeOperation();
        operation.setModelPath(this.getModelPath());
        AbstractGenModelGeneratorAdapterFactory generatorAdapterFactory = this.getGeneratorAdapterFactory();
        String mergeRulesPath = this.getMergeRulesRelativePath();
        if (mergeRulesPath != null) {
            generatorAdapterFactory.setMergeRulesRelativePath(mergeRulesPath);
        }
        operation.setGeneratorAdapterFactory((GeneratorAdapterFactory)generatorAdapterFactory);
        try {
            operation.run(progressMonitor_p);
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("AbstractEmfGeneratorTask.doExecute(..) _ ");
            loggerMessage.append("Failed to generate EMF code").append(" for model:").append(this.getModelPath());
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return operation.getResult();
    }

    protected abstract AbstractGenerateCodeOperation getEmfGenerateCodeOperation();

    private String getModelPath() {
        return (String)this.getContextElementValue(ECORE_MODEL_PATH);
    }

    private AbstractGenModelGeneratorAdapterFactory getGeneratorAdapterFactory() {
        return (AbstractGenModelGeneratorAdapterFactory)this.getContextElementValue(GENERATOR_ADAPTER_FACTORY);
    }

    private String getMergeRulesRelativePath() {
        return (String)this.getContextElementValue(MERGE_RULES_RELATIVE_PATH);
    }
}

