/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.toolkit.viewers;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.ui.toolkit.internal.UI;
import org.eclipse.egf.common.ui.toolkit.viewers.Messages;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransferViewer
extends Viewer {
    private static Logger _logger = Logger.getLogger((String)AbstractTransferViewer.class.getPackage().getName());
    public static final int STATUS_TEXT_FIELD = 2;
    public static final int ADD_ALL_BUTTON = 4;
    public static final int ADD_SELECTED_BUTTON = 8;
    public static final int REMOVE_SELECTED_BUTTON = 16;
    public static final int REMOVE_ALL_BUTTON = 32;
    public static final int SINGLE_SELECTION_VIEWER = 64;
    public static final int ALL_BUTTONS = 60;
    public static final int ALL_WIDGETS = 62;
    private int _style;
    private Composite _composite;
    private Text _statusBar;
    private Composite _buttonsPanel;
    private Button _addAllBtn;
    private Button _addSelectedBtn;
    private Button _removeSelectedBtn;
    private Button _removeAllBtn;
    protected StructuredViewer _leftViewer;
    private int _leftViewerStyleBits;
    protected StructuredViewer _rightViewer;
    private int _rightViewerStyleBits;
    private SelectionListener _buttonClickedListener;
    private ISelectionChangedListener _viewerSelectionChangedListener;
    private List<SelectionChangedHandler> _selectionChangedHandlersForBothViewers;
    private List<SelectionChangedHandler> _selectionChangedHandlersForLeftViewer;
    private List<SelectionChangedHandler> _selectionChangedHandlersForRightViewer;

    protected AbstractTransferViewer(Composite parent_p, int style_p, int leftViewerStyleBits_p, int rightViewerStyleBits_p) {
        this._style = style_p == 0 ? 62 : style_p;
        this._selectionChangedHandlersForBothViewers = new ArrayList<SelectionChangedHandler>(0);
        this._selectionChangedHandlersForLeftViewer = new ArrayList<SelectionChangedHandler>(0);
        this._selectionChangedHandlersForRightViewer = new ArrayList<SelectionChangedHandler>(0);
        this._leftViewerStyleBits = leftViewerStyleBits_p;
        this._rightViewerStyleBits = rightViewerStyleBits_p;
        this.createViewer(parent_p);
    }

    private void createViewer(Composite parent_p) {
        this.createInternalComposite(parent_p);
        this.initializeListeners();
        this.createLeftViewer(this._composite);
        this.createButtonArea(this._composite);
        this.createRightViewer(this._composite);
        this.createStatusTextField(this._composite);
    }

    private void createInternalComposite(Composite parent_p) {
        this._composite = new Composite(parent_p, 0);
        this._composite.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 4, true, true);
        this._composite.setLayoutData((Object)gridData);
    }

    private void createLeftViewer(Composite parent_p) {
        if (this._leftViewer == null) {
            this._leftViewer = this.doLeftViewer(parent_p);
        }
        this.layoutViewer(this._leftViewer, Messages.getString("AbstractTransferViewer.list.available.tooltip"));
    }

    private void createRightViewer(Composite parent_p) {
        if (this._rightViewer == null) {
            this._rightViewer = this.doRightViewer(parent_p);
        }
        this.layoutViewer(this._rightViewer, Messages.getString("AbstractTransferViewer.list.selected.tooltip"));
    }

    protected void createButtonArea(Composite parent_p) {
        this._buttonsPanel = new Composite(parent_p, 0);
        GridData gdData = new GridData();
        gdData.widthHint = UI.convertHorizontalDLUsToPixels((Control)this._buttonsPanel, 61);
        gdData.verticalAlignment = 2;
        gdData.grabExcessVerticalSpace = true;
        this._buttonsPanel.setLayoutData((Object)gdData);
        GridLayout buttonsLayout = new GridLayout(1, true);
        this._buttonsPanel.setLayout((Layout)buttonsLayout);
        if ((4 & this._style) != 0) {
            this._addAllBtn = this.createButton(this._buttonsPanel, ">>", Messages.getString("AbstractTransferViewer.addallelements.tooltip"));
        }
        if ((8 & this._style) != 0) {
            this._addSelectedBtn = this.createButton(this._buttonsPanel, ">", Messages.getString("AbstractTransferViewer.addselectedelements.tooltip"));
        }
        if ((0x10 & this._style) != 0) {
            this._removeSelectedBtn = this.createButton(this._buttonsPanel, "<", Messages.getString("AbstractTransferViewer.removeselectedelements.tooltip"));
        }
        if ((0x20 & this._style) != 0) {
            this._removeAllBtn = this.createButton(this._buttonsPanel, "<<", Messages.getString("AbstractTransferViewer.removeallelements.tooltip"));
        }
    }

    private void createStatusTextField(Composite parent_p) {
        if ((2 & this._style) != 0) {
            this._statusBar = new Text(parent_p, 2056);
            this._statusBar.setEditable(false);
            GridData gdData = new GridData();
            gdData.horizontalAlignment = 4;
            gdData.grabExcessHorizontalSpace = true;
            gdData.horizontalSpan = 3;
            this._statusBar.setLayoutData((Object)gdData);
        }
    }

    private void initializeListeners() {
        this._buttonClickedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                Widget button = event_p.widget;
                AbstractTransferViewer.this.handleButtonClicked(button);
            }
        };
        this._viewerSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                AbstractTransferViewer.this.handleViewersSelectionMode(event_p);
                ISelection selection = event_p.getSelection();
                if (!selection.isEmpty()) {
                    AbstractTransferViewer.this.updateButtons(selection, event_p.getSelectionProvider());
                    IStructuredSelection structSelection = (IStructuredSelection)selection;
                    Object lastSelected = structSelection.toList().get(structSelection.size() - 1);
                    ContentViewer source = (ContentViewer)event_p.getSource();
                    ILabelProvider labelProvider = (ILabelProvider)source.getLabelProvider();
                    AbstractTransferViewer.this.updateStatusLine(labelProvider.getText(lastSelected));
                }
            }
        };
        this._composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event_p) {
                Control leftControl = AbstractTransferViewer.this._leftViewer.getControl();
                Point leftViewerSize = leftControl.computeSize(-1, -1);
                Control rightControl = AbstractTransferViewer.this._rightViewer.getControl();
                Point rightViewerSize = rightControl.computeSize(-1, -1);
                int width = Math.max(leftViewerSize.x, rightViewerSize.x);
                GridData gd = (GridData)leftControl.getLayoutData();
                gd.widthHint = width;
                gd = (GridData)rightControl.getLayoutData();
                gd.widthHint = width;
            }
        });
    }

    private void layoutViewer(StructuredViewer viewer_p, String tooltip_p) {
        if (viewer_p == null) {
            return;
        }
        viewer_p.setUseHashlookup(true);
        Control control = viewer_p.getControl();
        control.setToolTipText(tooltip_p);
        viewer_p.addSelectionChangedListener(this._viewerSelectionChangedListener);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.verticalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gdData);
    }

    private Button createButton(Composite parent_p, String text_p, String tooltip_p) {
        Button button = new Button(parent_p, 0x1000000);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gdData);
        button.setText(text_p);
        button.setToolTipText(tooltip_p);
        button.addSelectionListener(this._buttonClickedListener);
        return button;
    }

    private void handleButtonClicked(Widget button_p) {
        boolean somethingWasDone = false;
        if (button_p == this._addAllBtn) {
            somethingWasDone = this.doHandleAddAllButton();
        } else if (button_p == this._addSelectedBtn) {
            somethingWasDone = this.doHandleAddSelectedButton();
        } else if (button_p == this._removeSelectedBtn) {
            somethingWasDone = this.doHandleRemoveSelectedButton();
        } else if (button_p == this._removeAllBtn) {
            somethingWasDone = this.doHandleRemoveAllButton();
        } else {
            _logger.warn((Object)("Unsupported source button :" + button_p));
        }
        if (somethingWasDone) {
            this.doLayout();
        }
    }

    protected void doLayout() {
        this._composite.layout();
    }

    protected boolean doHandleAddAllButton() {
        boolean changed = false;
        Object input = this._leftViewer.getInput();
        if (input != null) {
            changed = true;
            this._leftViewer.setInput(null);
            this._rightViewer.setInput(input);
        }
        return changed;
    }

    protected boolean doHandleAddSelectedButton() {
        boolean changed = false;
        ISelection leftSelection = this._leftViewer.getSelection();
        if (!leftSelection.isEmpty()) {
            changed = true;
            IStructuredSelection structuredSelection = (IStructuredSelection)leftSelection;
            Object[] elements = structuredSelection.toArray();
            this._leftViewer.getContentProvider().inputChanged((Viewer)this._leftViewer, (Object)elements, null);
            this._rightViewer.getContentProvider().inputChanged((Viewer)this._rightViewer, null, (Object)elements);
        }
        return changed;
    }

    protected boolean doHandleRemoveSelectedButton() {
        boolean changed = false;
        ISelection rightSelection = this._rightViewer.getSelection();
        if (!rightSelection.isEmpty()) {
            changed = true;
            IStructuredSelection structuredSelection = (IStructuredSelection)rightSelection;
            Object[] elements = structuredSelection.toArray();
            this._leftViewer.getContentProvider().inputChanged((Viewer)this._leftViewer, null, (Object)elements);
            this._rightViewer.getContentProvider().inputChanged((Viewer)this._rightViewer, (Object)elements, null);
        }
        return changed;
    }

    protected boolean doHandleRemoveAllButton() {
        boolean changed = false;
        Object input = this._rightViewer.getInput();
        if (input != null) {
            changed = true;
            this._rightViewer.setInput(null);
            this._leftViewer.setInput(input);
        }
        return changed;
    }

    protected void updateStatusLine(String text_p) {
        if (this._statusBar != null) {
            this._statusBar.setText(text_p);
        }
    }

    protected void updateButtons(ISelection selection_p, ISelectionProvider selectionProvider_p) {
        List<SelectionChangedHandler> handlersForSelectionProvider = null;
        if (selectionProvider_p == this._leftViewer) {
            handlersForSelectionProvider = this._selectionChangedHandlersForLeftViewer;
        } else if (selectionProvider_p == this._rightViewer) {
            handlersForSelectionProvider = this._selectionChangedHandlersForRightViewer;
        }
        this.notifySelectionChangedHandler(selection_p, handlersForSelectionProvider);
        this.notifySelectionChangedHandler(selection_p, this._selectionChangedHandlersForBothViewers);
    }

    private void notifySelectionChangedHandler(ISelection selection_p, List<SelectionChangedHandler> handlers_p) {
        if (handlers_p != null) {
            for (SelectionChangedHandler handler : handlers_p) {
                handler.handleSelection(selection_p);
            }
        }
    }

    protected void handleViewersSelectionMode(SelectionChangedEvent event_p) {
        if ((this._style & 0x40) != 0 && !event_p.getSelection().isEmpty()) {
            ISelectionProvider selectionProvider = event_p.getSelectionProvider();
            StructuredViewer disableSelectionViewer = null;
            Button buttonDrivenByOppositeViewer = null;
            if (selectionProvider == this._leftViewer) {
                disableSelectionViewer = this._rightViewer;
                buttonDrivenByOppositeViewer = this._removeSelectedBtn;
            } else if (selectionProvider == this._rightViewer) {
                disableSelectionViewer = this._leftViewer;
                buttonDrivenByOppositeViewer = this._addSelectedBtn;
            }
            if (buttonDrivenByOppositeViewer != null) {
                buttonDrivenByOppositeViewer.setEnabled(false);
            }
            if (!disableSelectionViewer.getSelection().isEmpty()) {
                disableSelectionViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    protected abstract StructuredViewer doRightViewer(Composite var1);

    protected abstract StructuredViewer doLeftViewer(Composite var1);

    public void setSelectionChangedHandler(SelectionChangedHandler handler_p, int buttonStyleConstant_p) {
        if (this._addAllBtn != null && (4 & buttonStyleConstant_p) != 0) {
            handler_p.addControl((Control)this._addAllBtn);
            this._selectionChangedHandlersForBothViewers.add(handler_p);
        }
        if (this._removeAllBtn != null && (0x20 & buttonStyleConstant_p) != 0) {
            handler_p.addControl((Control)this._removeAllBtn);
            this._selectionChangedHandlersForBothViewers.add(handler_p);
        }
        if (this._addSelectedBtn != null && (8 & buttonStyleConstant_p) != 0) {
            handler_p.addControl((Control)this._addSelectedBtn);
            this._selectionChangedHandlersForLeftViewer.add(handler_p);
        }
        if (this._removeSelectedBtn != null && (0x10 & buttonStyleConstant_p) != 0) {
            handler_p.addControl((Control)this._removeSelectedBtn);
            this._selectionChangedHandlersForRightViewer.add(handler_p);
        }
    }

    public IContentProvider getLeftContentProvider() {
        IContentProvider provider = null;
        if (this._leftViewer != null) {
            provider = this._leftViewer.getContentProvider();
        }
        return provider;
    }

    public Object getLeftInput() {
        Object object = null;
        if (this._leftViewer != null) {
            object = this._leftViewer.getInput();
        }
        return object;
    }

    public StructuredViewer getLeftViewer() {
        return this._leftViewer;
    }

    public IBaseLabelProvider getLeftLabelProvider() {
        IBaseLabelProvider provider = null;
        if (this._leftViewer != null) {
            provider = this._leftViewer.getLabelProvider();
        }
        return provider;
    }

    public void setLeftContentProvider(IContentProvider provider_p) {
        this._leftViewer.setContentProvider(provider_p);
    }

    public void setLeftInput(Object input_p) {
        this._leftViewer.setInput(input_p);
    }

    public void setLeftLabelProvider(ILabelProvider provider_p) {
        this._leftViewer.setLabelProvider((IBaseLabelProvider)provider_p);
    }

    public IContentProvider getRightContentProvider() {
        IContentProvider provider = null;
        if (this._rightViewer != null) {
            provider = this._rightViewer.getContentProvider();
        }
        return provider;
    }

    public Object getRightInput() {
        Object object = null;
        if (this._rightViewer != null) {
            object = this._rightViewer.getInput();
        }
        return object;
    }

    public StructuredViewer getRightViewer() {
        return this._rightViewer;
    }

    public IBaseLabelProvider getRightLabelProvider() {
        IBaseLabelProvider provider = null;
        if (this._rightViewer != null) {
            provider = this._rightViewer.getLabelProvider();
        }
        return provider;
    }

    public void setRightContentProvider(IContentProvider provider_p) {
        this._rightViewer.setContentProvider(provider_p);
    }

    public void setRightInput(Object input_p) {
        this._rightViewer.setInput(input_p);
    }

    public void setRightLabelProvider(ILabelProvider provider_p) {
        this._rightViewer.setLabelProvider((IBaseLabelProvider)provider_p);
    }

    public void dispose() {
        if (this._composite != null && !this._composite.isDisposed()) {
            this._composite.dispose();
            this._composite = null;
        }
        this._buttonClickedListener = null;
        this._addAllBtn = null;
        this._addSelectedBtn = null;
        this._removeSelectedBtn = null;
        this._removeAllBtn = null;
        if (this._leftViewer != null) {
            this._leftViewer.removeSelectionChangedListener(this._viewerSelectionChangedListener);
        }
        if (this._rightViewer != null) {
            this._rightViewer.removeSelectionChangedListener(this._viewerSelectionChangedListener);
        }
        this._viewerSelectionChangedListener = null;
    }

    public Control getControl() {
        return this._composite;
    }

    public Object getInput() {
        return null;
    }

    public ISelection getSelection() {
        return null;
    }

    public void refresh() {
        this._leftViewer.refresh();
        this._rightViewer.refresh();
    }

    public void setInput(Object input_p) {
    }

    public void setSelection(ISelection selection_p, boolean reveal_p) {
    }

    protected int getLeftViewerStyleBits() {
        return this._leftViewerStyleBits;
    }

    protected int getRightViewerStyleBits() {
        return this._rightViewerStyleBits;
    }

    public void setButtonEnabled(int buttonStyle_p, boolean enable_p) {
        if ((buttonStyle_p & 4) != 0) {
            this._addAllBtn.setEnabled(enable_p);
        }
        if ((buttonStyle_p & 8) != 0) {
            this._addSelectedBtn.setEnabled(enable_p);
        }
        if ((buttonStyle_p & 0x10) != 0) {
            this._removeSelectedBtn.setEnabled(enable_p);
        }
        if ((buttonStyle_p & 0x20) != 0) {
            this._removeAllBtn.setEnabled(enable_p);
        }
    }

    public boolean isButtonEnabled(int buttonStyle_p) {
        boolean enabled = true;
        switch (buttonStyle_p) {
            case 4: {
                enabled = this._addAllBtn.isEnabled();
                break;
            }
            case 8: {
                enabled = this._addSelectedBtn.isEnabled();
                break;
            }
            case 16: {
                enabled = this._removeSelectedBtn.isEnabled();
                break;
            }
            case 32: {
                enabled = this._removeAllBtn.isEnabled();
            }
        }
        return enabled;
    }

    public Composite getButtonsContainer() {
        return this._buttonsPanel;
    }
}

