/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.internal.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.common.internal.registry.EGFLoggerProxy;
import org.eclipse.egf.common.log.IEGFLogger;
import org.eclipse.egf.common.log.IEGFLoggerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EGFLoggerRegistry
implements IEGFLoggerRegistry,
IRegistryEventListener {
    private List<EGFLoggerProxy> _proxies;
    public static final String EXTENSION_ID = "org.eclipse.egf.common.logger";
    public static final String INVOKER_ATT_CLASS = "class";

    @Override
    public List<IEGFLogger> getEGFLoggers() {
        ArrayList<IEGFLogger> loggers = new ArrayList<IEGFLogger>();
        for (EGFLoggerProxy proxy : this._proxies) {
            IEGFLogger logger = proxy.getEGFLogger();
            if (logger == null) continue;
            loggers.add(logger);
        }
        return loggers;
    }

    public EGFLoggerRegistry() {
        this.initialize();
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXTENSION_ID);
    }

    private void initialize() {
        if (this._proxies != null) {
            return;
        }
        this._proxies = new ArrayList<EGFLoggerProxy>();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_ID);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.register(element);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void register(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        EGFLoggerProxy loggerProxy = EGFLoggerProxy.createProxy(element);
        if (loggerProxy != null) {
            this._proxies.add(loggerProxy);
        }
    }

    public void added(IExtension[] extensions) {
        if (extensions == null) {
            return;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.register(element);
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            Iterator<EGFLoggerProxy> it = this._proxies.iterator();
            while (it.hasNext()) {
                EGFLoggerProxy proxy = it.next();
                if (!proxy.originatesFrom(extensions[i])) continue;
                it.remove();
            }
            ++i;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void dispose() {
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        this._proxies = null;
    }
}

