/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.AbstractPlatformManager;
import org.eclipse.egf.core.platform.internal.pde.PlatformBundle;
import org.eclipse.egf.core.platform.internal.pde.PlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.internal.pde.TargetPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointURI;
import org.eclipse.egf.core.platform.pde.ITargetPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.ITargetPlatformManager;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IExtensionDeltaEvent;
import org.eclipse.pde.internal.core.IExtensionDeltaListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TargetPlatformManager
extends AbstractPlatformManager
implements ITargetPlatformManager,
IPluginModelListener,
IExtensionDeltaListener {
    protected Map<String, IPlatformBundle> _platformRegistry;
    private Map<Class<?>, Set<Object>> _workspaceRegistry;
    private Map<Class<?>, Set<Object>> _targetRegistry;

    protected static IPlatformBundle createPlatformBundle(IPluginModelBase base) {
        PlatformBundle platformBundle = new PlatformBundle(base);
        IPluginExtension[] iPluginExtensionArray = base.getExtensions(false).getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            Class<? extends IPlatformExtensionPoint> clazz = EGFPlatformPlugin.getPlatformExtensionPoints().get(extension.getPoint());
            if (clazz != null) {
                IPluginObject[] iPluginObjectArray = extension.getChildren();
                int n3 = iPluginObjectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginObject pluginObject = iPluginObjectArray[n4];
                    if (pluginObject instanceof IPluginElement) {
                        platformBundle.createPlatformExtensionPoint(clazz, pluginObject);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return platformBundle;
    }

    protected static List<IPluginModelBase> getExtensionPointModels(ModelEntry entry) {
        UniqueEList plugins = new UniqueEList();
        IPluginModelBase[] iPluginModelBaseArray = entry.hasWorkspaceModels() ? entry.getWorkspaceModels() : entry.getExternalModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getExtensions(false) != null && model.getExtensions(false).getExtensions() != null) {
                IPluginExtension[] iPluginExtensionArray = model.getExtensions(false).getExtensions();
                int n3 = iPluginExtensionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginExtension extension = iPluginExtensionArray[n4];
                    Class<? extends IPlatformExtensionPoint> clazz = EGFPlatformPlugin.getPlatformExtensionPoints().get(extension.getPoint());
                    if (clazz != null) {
                        plugins.add(model);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return plugins;
    }

    public TargetPlatformManager() {
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getModelManager().addExtensionDeltaListener((IExtensionDeltaListener)this);
    }

    @Override
    public int getPlatformBundleSize() {
        return this._platformRegistry.size();
    }

    @Override
    public int getPlatformExtensionPointSize() {
        int size = 0;
        for (Map.Entry<Class<?>, Set<Object>> entry : this._workspaceRegistry.entrySet()) {
            size += entry.getValue().size();
        }
        for (Map.Entry<Class<?>, Set<Object>> entry : this._targetRegistry.entrySet()) {
            size += entry.getValue().size();
        }
        return size;
    }

    @Override
    public int getWorkspacePlatformExtensionPointSize() {
        int size = 0;
        for (Map.Entry<Class<?>, Set<Object>> entry : this._workspaceRegistry.entrySet()) {
            size += entry.getValue().size();
        }
        return size;
    }

    @Override
    public int getTargetPlatformExtensionPointSize() {
        int size = 0;
        for (Map.Entry<Class<?>, Set<Object>> entry : this._targetRegistry.entrySet()) {
            size += entry.getValue().size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            super.dispose();
            PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
            PDECore.getDefault().getModelManager().removeExtensionDeltaListener((IExtensionDeltaListener)this);
            if (this._platformRegistry != null) {
                this._platformRegistry.clear();
            }
            if (this._targetRegistry != null) {
                this._targetRegistry.clear();
            }
            if (this._workspaceRegistry != null) {
                this._workspaceRegistry.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle getPlatformBundle(String id) {
        if (id == null) {
            return null;
        }
        Object object = this._lockPlatformManager;
        synchronized (object) {
            return this._platformRegistry.get(id);
        }
    }

    @Override
    public IPlatformBundle getPlatformBundle(IPluginModelBase base) {
        if (base == null) {
            return null;
        }
        String id = BundleHelper.getBundleId((IPluginModelBase)base);
        if (id == null) {
            return null;
        }
        return this.getPlatformBundle(id);
    }

    @Override
    public IPlatformBundle getPlatformBundle(IProject project) {
        if (project == null) {
            return null;
        }
        IPluginModelBase base = BundleHelper.getPluginModelBase((IProject)project);
        if (base == null) {
            return null;
        }
        String id = BundleHelper.getBundleId((IPluginModelBase)base);
        if (id == null) {
            return null;
        }
        return this.getPlatformBundle(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle[] getPlatformBundles() {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            return this._platformRegistry.values().toArray(new IPlatformBundle[this._platformRegistry.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getWorkspacePlatformExtensionPoints(Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            return TargetPlatformManager.getPlatformExtensionPoints(this._workspaceRegistry, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getTargetPlatformExtensionPoints(Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            return TargetPlatformManager.getPlatformExtensionPoints(this._targetRegistry, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            block4: {
                if (clazz != null && EGFPlatformPlugin.getPlatformExtensionPoints().values().contains(clazz)) break block4;
                return null;
            }
            IPlatformExtensionPoint[] targetExtensionPoints = this.getTargetPlatformExtensionPoints(clazz);
            IPlatformExtensionPoint[] workspaceExtensionPoints = this.getWorkspacePlatformExtensionPoints(clazz);
            IPlatformExtensionPoint[] extensionPoints = (IPlatformExtensionPoint[])Array.newInstance(clazz, targetExtensionPoints.length + workspaceExtensionPoints.length);
            System.arraycopy(targetExtensionPoints, 0, extensionPoints, 0, targetExtensionPoints.length);
            System.arraycopy(workspaceExtensionPoints, 0, extensionPoints, targetExtensionPoints.length, workspaceExtensionPoints.length);
            return extensionPoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(IPluginModelBase model, Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            if (model != null && clazz != null && EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) && (platformBundle = this.getPlatformBundle(model)) != null) {
                return platformBundle.getPlatformExtensionPoints(clazz);
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList(0), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(IProject project, Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            if (project != null && clazz != null && EGFPlatformPlugin.getPlatformExtensionPoints().values().contains(clazz) && (platformBundle = this.getPlatformBundle(project)) != null) {
                return platformBundle.getPlatformExtensionPoints(clazz);
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList(0), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(String id, Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            if (id != null && clazz != null && EGFPlatformPlugin.getPlatformExtensionPoints().values().contains(clazz) && (platformBundle = this._platformRegistry.get(id)) != null) {
                return platformBundle.getPlatformExtensionPoints(clazz);
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList(0), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        long startTargetTime = System.currentTimeMillis();
        Object object = this._lockPlatformManager;
        synchronized (object) {
            this.initializeRegistry();
        }
        long endTargetTime = System.currentTimeMillis();
        if (EGFPlatformPlugin.getDefault().isDebugging()) {
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TargetPlatformManager _ found {0} Platform Bundle{1}, ''{2}'' Workspace Extension Point{3},''{4}'' Target Extension Point{5},in ''{6}'' ms", (Object[])new Object[]{this.getPlatformBundleSize(), this.getPlatformBundleSize() < 2 ? "" : "s", this.getWorkspacePlatformExtensionPointSize(), this.getWorkspacePlatformExtensionPointSize() < 2 ? "" : "s", this.getTargetPlatformExtensionPointSize(), this.getTargetPlatformExtensionPointSize() < 2 ? "" : "s", endTargetTime - startTargetTime}));
            for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
                Set<Object> workspaceObjects;
                int workspace;
                Set<Object> targetObjects = this._targetRegistry.get(clazz);
                int target = targetObjects != null ? targetObjects.size() : 0;
                int extension = target + (workspace = (workspaceObjects = this._workspaceRegistry.get(clazz)) != null ? workspaceObjects.size() : 0);
                if (extension == 0) continue;
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"{0} Extension{1} ''{2}''", (Object[])new Object[]{extension, extension < 2 ? "" : "s", clazz.getName()}), 1);
                if (target != 0) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"{0} target Extension{1}", (Object[])new Object[]{target, target < 2 ? "" : "s", clazz.getName()}), 2);
                }
                if (workspace == 0) continue;
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"{0} workspace Extension{1}", (Object[])new Object[]{workspace, workspace < 2 ? "" : "s", clazz.getName()}), 2);
            }
        }
    }

    @Override
    protected void initializeRegistry() {
        if (this._platformRegistry != null) {
            return;
        }
        this._platformRegistry = new HashMap<String, IPlatformBundle>();
        this._workspaceRegistry = new HashMap();
        this._targetRegistry = new HashMap();
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels((boolean)true);
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase base = iPluginModelBaseArray[n2];
            this.addPlatformBundle(TargetPlatformManager.createPlatformBundle(base), null);
            ++n2;
        }
    }

    protected void handleChange(IPluginModelBase base, PlatformExtensionPointDelta delta) {
        if (base == null) {
            return;
        }
        PlatformBundle platformBundle = (PlatformBundle)this._platformRegistry.get(BundleHelper.getBundleId((IPluginModelBase)base));
        if (platformBundle == null) {
            if (base.isEnabled()) {
                this.addPlatformBundle(TargetPlatformManager.createPlatformBundle(base), delta);
            }
        } else if (base.isEnabled()) {
            if (base == platformBundle.getPluginModelBase()) {
                this.mergePlatformBundle(platformBundle, TargetPlatformManager.createPlatformBundle(base), delta);
            } else {
                this.removePlatformBundle(platformBundle, delta);
                this.addPlatformBundle(TargetPlatformManager.createPlatformBundle(base), delta);
            }
        } else {
            this.removePlatformBundle(platformBundle, delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extensionsChanged(IExtensionDeltaEvent event) {
        TargetPlatformExtensionPointDelta delta = new TargetPlatformExtensionPointDelta();
        Object object = this._lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            IPluginModelBase base;
            IPluginModelBase[] iPluginModelBaseArray = event.getRemovedModels();
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                platformBundle = this._platformRegistry.get(BundleHelper.getBundleId((IPluginModelBase)base));
                if (platformBundle != null && base.equals(platformBundle.getPluginModelBase())) {
                    this.removePlatformBundle(platformBundle, delta);
                }
                ++n2;
            }
            iPluginModelBaseArray = event.getAddedModels();
            n = iPluginModelBaseArray.length;
            n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                platformBundle = this._platformRegistry.get(BundleHelper.getBundleId((IPluginModelBase)base));
                if (platformBundle != null && !base.equals(platformBundle.getPluginModelBase())) {
                    this.removePlatformBundle(platformBundle, delta);
                }
                this.addPlatformBundle(TargetPlatformManager.createPlatformBundle(base), delta);
                ++n2;
            }
            iPluginModelBaseArray = event.getChangedModels();
            n = iPluginModelBaseArray.length;
            n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                this.handleChange(base, delta);
                ++n2;
            }
        }
        if (!delta.isEmpty()) {
            if (EGFPlatformPlugin.getDefault().isDebugging()) {
                this.trace(delta);
            }
            this.firePlatformExtensionPoint(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelsChanged(PluginModelDelta event) {
        TargetPlatformExtensionPointDelta delta = new TargetPlatformExtensionPointDelta();
        Object object = this._lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            ModelEntry entry;
            int n;
            int n2;
            ModelEntry[] modelEntryArray;
            if ((event.getKind() & 2) != 0) {
                modelEntryArray = event.getRemovedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    entry = modelEntryArray[n];
                    for (IPluginModelBase base : TargetPlatformManager.getExtensionPointModels(entry)) {
                        platformBundle = this._platformRegistry.get(BundleHelper.getBundleId((IPluginModelBase)base));
                        if (platformBundle == null || !base.equals(platformBundle.getPluginModelBase())) continue;
                        this.removePlatformBundle(platformBundle, delta);
                    }
                    ++n;
                }
            }
            if ((event.getKind() & 1) != 0) {
                modelEntryArray = event.getAddedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    entry = modelEntryArray[n];
                    for (IPluginModelBase base : TargetPlatformManager.getExtensionPointModels(entry)) {
                        platformBundle = this._platformRegistry.get(BundleHelper.getBundleId((IPluginModelBase)base));
                        if (platformBundle != null && !base.equals(platformBundle.getPluginModelBase())) {
                            this.removePlatformBundle(platformBundle, delta);
                        }
                        this.addPlatformBundle(TargetPlatformManager.createPlatformBundle(base), delta);
                    }
                    ++n;
                }
            }
            if ((event.getKind() & 4) != 0) {
                modelEntryArray = event.getChangedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    entry = modelEntryArray[n];
                    IPluginModelBase[] iPluginModelBaseArray = entry.hasWorkspaceModels() ? entry.getWorkspaceModels() : entry.getExternalModels();
                    int n3 = iPluginModelBaseArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginModelBase base;
                        base = iPluginModelBaseArray[n4];
                        this.handleChange(base, delta);
                        ++n4;
                    }
                    ++n;
                }
            }
        }
        if (!delta.isEmpty()) {
            if (EGFPlatformPlugin.getDefault().isDebugging()) {
                this.trace(delta);
            }
            this.firePlatformExtensionPoint(delta);
        }
    }

    protected void mergePlatformBundle(PlatformBundle platformBundle, IPlatformBundle newPlatformBundle, PlatformExtensionPointDelta delta) {
        if (platformBundle == null || newPlatformBundle == null) {
            return;
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
            int n;
            int n2;
            IPlatformExtensionPoint[] iPlatformExtensionPointArray;
            IPlatformExtensionPoint[] iPlatformExtensionPointArray2 = platformBundle.getPlatformExtensionPoints(clazz);
            int n3 = iPlatformExtensionPointArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                block16: {
                    IPlatformExtensionPoint existingExtensionPoint = iPlatformExtensionPointArray2[n4];
                    iPlatformExtensionPointArray = newPlatformBundle.getPlatformExtensionPoints(clazz);
                    n2 = iPlatformExtensionPointArray.length;
                    n = 0;
                    while (n < n2) {
                        IPlatformExtensionPoint newExtensionPoint = iPlatformExtensionPointArray[n];
                        if (!existingExtensionPoint.equals(newExtensionPoint)) {
                            ++n;
                            continue;
                        }
                        break block16;
                    }
                    if (!platformBundle.removePlatformExtensionPoint(clazz, existingExtensionPoint)) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"TargetPlatformManager.mergePlatformBundle(..) _ ''{0}'' unable to remove Extension Point from IPlatformBundle.", (Object)existingExtensionPoint));
                    }
                    if (platformBundle.isTarget()) {
                        TargetPlatformManager.removeExtensionPoint(existingExtensionPoint, clazz, this._targetRegistry, delta);
                    } else if (platformBundle.isWorkspace()) {
                        TargetPlatformManager.removeExtensionPoint(existingExtensionPoint, clazz, this._workspaceRegistry, delta);
                    }
                }
                ++n4;
            }
            iPlatformExtensionPointArray2 = newPlatformBundle.getPlatformExtensionPoints(clazz);
            n3 = iPlatformExtensionPointArray2.length;
            n4 = 0;
            while (n4 < n3) {
                block17: {
                    IPlatformExtensionPoint newExtensionPoint = iPlatformExtensionPointArray2[n4];
                    iPlatformExtensionPointArray = platformBundle.getPlatformExtensionPoints(clazz);
                    n2 = iPlatformExtensionPointArray.length;
                    n = 0;
                    while (n < n2) {
                        IPlatformExtensionPoint existingExtensionPoint = iPlatformExtensionPointArray[n];
                        if (!existingExtensionPoint.equals(newExtensionPoint)) {
                            ++n;
                            continue;
                        }
                        break block17;
                    }
                    platformBundle.addPlatformExtensionPoint(clazz, newExtensionPoint);
                    if (platformBundle.isTarget()) {
                        TargetPlatformManager.addExtensionPoint(newExtensionPoint, clazz, this._targetRegistry, delta);
                    } else if (platformBundle.isWorkspace()) {
                        TargetPlatformManager.addExtensionPoint(newExtensionPoint, clazz, this._workspaceRegistry, delta);
                    }
                }
                ++n4;
            }
        }
        if (platformBundle.isEmpty() && !platformBundle.equals(this._platformRegistry.remove(platformBundle.getBundleId()))) {
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"TargetPlatformManager.mergePlatformBundle(..) _ ''{0}'' unknown IPlatformBundle.", (Object)platformBundle.getBundleId()));
        }
    }

    protected void removePlatformBundle(IPlatformBundle platformBundle, PlatformExtensionPointDelta delta) {
        if (platformBundle == null) {
            return;
        }
        if (platformBundle.isTarget()) {
            TargetPlatformManager.removePlatformBundle(platformBundle, this._platformRegistry, this._targetRegistry, delta);
        } else {
            TargetPlatformManager.removePlatformBundle(platformBundle, this._platformRegistry, this._workspaceRegistry, delta);
        }
    }

    protected void addPlatformBundle(IPlatformBundle platformBundle, PlatformExtensionPointDelta delta) {
        if (platformBundle == null || platformBundle.isEmpty()) {
            return;
        }
        IPlatformBundle innerPlatformBundle = this._platformRegistry.get(platformBundle.getBundleId());
        if (platformBundle.equals(innerPlatformBundle)) {
            return;
        }
        if (platformBundle.isTarget()) {
            TargetPlatformManager.addPlatformBundle(platformBundle, this._platformRegistry, this._targetRegistry, delta);
        } else {
            TargetPlatformManager.addPlatformBundle(platformBundle, this._platformRegistry, this._workspaceRegistry, delta);
        }
    }

    private void trace(ITargetPlatformExtensionPointDelta delta) {
        IPlatformExtensionPoint[] iPlatformExtensionPointArray;
        IPlatformExtensionPoint[] workspace;
        IPlatformExtensionPoint extensionPoint;
        int n;
        IPlatformExtensionPoint[] iPlatformExtensionPointArray2;
        IPlatformExtensionPoint[] target;
        IPlatformExtensionPoint[] added = delta.getAddedPlatformExtensionPoints();
        IPlatformExtensionPoint[] removed = delta.getRemovedPlatformExtensionPoints();
        if (removed.length != 0) {
            target = delta.getTargetRemovedPlatformExtensionPoints();
            if (target.length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TargetPlatformManager removed {0} target Extension{1}.", (Object)target.length, (Object)(target.length < 2 ? "" : "s")));
                iPlatformExtensionPointArray2 = target;
                n = target.length;
                int n2 = 0;
                while (n2 < n) {
                    extensionPoint = iPlatformExtensionPointArray2[n2];
                    if (extensionPoint instanceof IPlatformExtensionPointURI) {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Target Removed {0}", (Object)DataValue.URI.encode((String)((IPlatformExtensionPointURI)extensionPoint).getURI().toString())), 1);
                    } else {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Target Removed {0}", (Object)extensionPoint.getId()), 1);
                    }
                    ++n2;
                }
            }
            if ((workspace = delta.getWorkspaceRemovedPlatformExtensionPoints()).length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TargetPlatformManager removed {0} workspace Extension{1}.", (Object)workspace.length, (Object)(workspace.length < 2 ? "" : "s")));
                iPlatformExtensionPointArray = workspace;
                int n3 = workspace.length;
                n = 0;
                while (n < n3) {
                    IPlatformExtensionPoint extensionPoint2 = iPlatformExtensionPointArray[n];
                    if (extensionPoint2 instanceof IPlatformExtensionPointURI) {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Workspace Removed {0}", (Object)DataValue.URI.encode((String)((IPlatformExtensionPointURI)extensionPoint2).getURI().toString())), 1);
                    } else {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Workspace Removed {0}", (Object)extensionPoint2.getId()), 1);
                    }
                    ++n;
                }
            }
        }
        if (added.length != 0) {
            target = delta.getTargetAddedPlatformExtensionPoints();
            if (target.length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TargetPlatformManager added {0} target Extension{1}.", (Object)target.length, (Object)(target.length < 2 ? "" : "s")));
                iPlatformExtensionPointArray2 = target;
                n = target.length;
                int extensionPoint2 = 0;
                while (extensionPoint2 < n) {
                    extensionPoint = iPlatformExtensionPointArray2[extensionPoint2];
                    if (extensionPoint instanceof IPlatformExtensionPointURI) {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Target Added {0}", (Object)DataValue.URI.encode((String)((IPlatformExtensionPointURI)extensionPoint).getURI().toString())), 1);
                    } else {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Target Added {0}", (Object)extensionPoint.getId()), 1);
                    }
                    ++extensionPoint2;
                }
            }
            if ((workspace = delta.getWorkspaceAddedPlatformExtensionPoints()).length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"TargetPlatformManager added {0} workspace Extension{1}.", (Object)workspace.length, (Object)(workspace.length < 2 ? "" : "s")));
                iPlatformExtensionPointArray = workspace;
                int n4 = workspace.length;
                n = 0;
                while (n < n4) {
                    IPlatformExtensionPoint extensionPoint3 = iPlatformExtensionPointArray[n];
                    if (extensionPoint3 instanceof IPlatformExtensionPointURI) {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Workspace Added {0}", (Object)DataValue.URI.encode((String)((IPlatformExtensionPointURI)extensionPoint3).getURI().toString())), 1);
                    } else {
                        EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Workspace Added {0}", (Object)extensionPoint3.getId()), 1);
                    }
                    ++n;
                }
            }
        }
    }
}

