/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ParameterTypeHelper {
    public static final ParameterTypeHelper INSTANCE = new ParameterTypeHelper();

    public String getSourceTypeLiteral(String type) {
        return this.getTypeLiteral(type, true);
    }

    public String getBinaryTypeLiteral(String type) {
        return this.getTypeLiteral(type, false);
    }

    private String getTypeLiteral(String type, boolean handleInnerClass) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException();
        }
        int index = type.indexOf(35);
        if (index == -1) {
            return handleInnerClass ? type.replace('$', '.') : type;
        }
        EPackage ePackage = this.getEPackage(type, index);
        String basePackage = Activator.getEPackageHelper().getBasePackage(ePackage);
        if (basePackage == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.assembly_error7, (Object)type));
        }
        if ("".equals(basePackage)) {
            return String.valueOf(ePackage.getName()) + "." + this.getClassName(type, index);
        }
        return String.valueOf(basePackage) + "." + this.getClassName(type, index);
    }

    public Object loadClass(String type) {
        if (type == null || "".equals(type)) {
            throw new IllegalArgumentException();
        }
        int index = type.indexOf(35);
        if (index > 0) {
            return this.loadEClass(type, index);
        }
        try {
            return this.getClass().getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private EClass loadEClass(String type, int index) {
        String className = this.getClassName(type, index);
        EPackage ePackage = this.getEPackage(type, index);
        EClass eClassifier = (EClass)ePackage.getEClassifier(className);
        if (eClassifier == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.classloader_error3, (Object)className, (Object)this.getNsURI(type, index)));
        }
        return eClassifier;
    }

    private EPackage getEPackage(String type, int index) {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        EObject eObject = editingDomain.getResourceSet().getEObject(URI.createURI((String)type), true);
        if (eObject == null) {
            throw new IllegalStateException(Messages.bind((String)Messages.assembly_error7, (Object)type));
        }
        return Activator.getEPackageHelper().getEPackage(eObject);
    }

    private String getNsURI(String type, int index) {
        return type.substring(0, index);
    }

    private String getClassName(String type, int index) {
        String className = type.substring(index + 1);
        if (className.startsWith("//")) {
            return className.substring(2);
        }
        return className;
    }

    private ParameterTypeHelper() {
    }
}

