/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.genmodel;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.PlatformExtensionPointURI;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformGenModel
extends PlatformExtensionPointURI
implements IPlatformGenModel {
    private String _generatedPackage;
    private String _genModel;
    private URI _genModelURI;
    private static Map<String, URI> _ePackageNsURIToGenModelLocationMap;

    public static Map<String, URI> getEPackageNsURIToGenModelLocationMap() {
        if (_ePackageNsURIToGenModelLocationMap == null) {
            _ePackageNsURIToGenModelLocationMap = new HashMap<String, URI>();
        }
        return _ePackageNsURIToGenModelLocationMap;
    }

    public PlatformGenModel(IPlatformBundle bundle, String id, String className, String genModel) {
        super(bundle, id);
        Assert.isNotNull((Object)className);
        Assert.isLegal((className.trim().length() != 0 ? 1 : 0) != 0);
        this._generatedPackage = className.trim();
        if (genModel != null && genModel.trim().length() != 0) {
            this._genModel = genModel.trim();
            this._genModelURI = bundle.isTarget() ? URIHelper.getPlatformPluginURI((String)this.getPlatformBundle().getBundleId(), (String)URI.decode((String)this._genModel), (boolean)false) : URIHelper.getPlatformResourceURI((String)this.getPlatformBundle().getBundleId(), (String)URI.decode((String)this._genModel), (boolean)false);
            PlatformGenModel.getEPackageNsURIToGenModelLocationMap().put(this.getId(), this._genModelURI);
        }
    }

    @Override
    public String getNamespace() {
        return this.getURI().toString();
    }

    @Override
    public String getGeneratedPackage() {
        return this._generatedPackage;
    }

    @Override
    public String getGenModel() {
        return this._genModel;
    }

    @Override
    public URI getGenModelURI() {
        return this._genModelURI;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof IPlatformGenModel)) {
            return false;
        }
        IPlatformGenModel platformGenModel = (IPlatformGenModel)object;
        if (!platformGenModel.getGeneratedPackage().equals(this.getGeneratedPackage())) {
            return false;
        }
        if (platformGenModel.getGenModel() == null && this.getGenModel() == null) {
            return true;
        }
        if (platformGenModel.getGenModel() == null || this.getGenModel() == null) {
            return false;
        }
        return platformGenModel.getGenModel().equals(this.getGenModel());
    }

    protected void dispose() {
        PlatformGenModel.getEPackageNsURIToGenModelLocationMap().remove(this.getId());
    }
}

