/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.task.acceleo3.engine;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acceleo3ScriptEngine {
    public void executeAcceleo3Task(String implementation, ITaskProductionContext productionContext, SubMonitor monitor) throws InvocationException {
        URI modelURI = (URI)productionContext.getInputValue((Object)"modelURI", URI.class);
        String targetUri = (String)productionContext.getInputValue((Object)"output", String.class);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath targetFolderIPath = root.getFolder((IPath)new Path(targetUri)).getLocation();
        try {
            Class<?> generatedClass = this.loadClass(implementation);
            Object instance = this.getInstance(modelURI, targetFolderIPath, generatedClass);
            Method doGenerate = instance.getClass().getMethod("doGenerate", Monitor.class);
            doGenerate.invoke(instance, new Object[1]);
        }
        catch (Exception e) {
            EGFCorePlugin.getDefault().logInfo(e.toString());
            e.printStackTrace();
        }
    }

    private Object getInstance(URI modelURI, IPath targetFolderIPath, Class<?> generatedClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class[] parameterTypes = new Class[]{URI.class, File.class, List.class};
        Constructor<?> constructor = generatedClass.getConstructor(parameterTypes);
        Object[] initargs = new Object[]{modelURI, targetFolderIPath.toFile(), Collections.EMPTY_LIST};
        Object instance = constructor.newInstance(initargs);
        return instance;
    }

    private Class<?> loadClass(String implementation) throws UnsupportedEncodingException, IOException, ClassNotFoundException {
        ByteArrayInputStream stream = new ByteArrayInputStream(implementation.getBytes("UTF-8"));
        Properties properties = new Properties();
        properties.load(stream);
        String project = properties.getProperty("project");
        String className = properties.getProperty("class");
        Class generatedClass = project != null ? Platform.getBundle((String)project).loadClass(className) : Class.forName(className);
        return generatedClass;
    }
}

