/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.compare.CompareHelper;
import org.eclipse.egf.pattern.ui.compare.MethodCompareItem;
import org.eclipse.egf.pattern.ui.compare.MethodCompareLabelProvider;

public class MethodCompareInput
extends CompareEditorInput {
    private PatternMethod patternMethod;
    private PatternMethod superPatternMethod;
    private static final MethodCompareLabelProvider labelProvider = new MethodCompareLabelProvider();

    public MethodCompareInput(PatternMethod patternMethod, PatternMethod superPatternMethod) {
        this(new CompareConfiguration(), patternMethod, superPatternMethod);
    }

    public MethodCompareInput(CompareConfiguration compareConfiguration, PatternMethod patternMethod, PatternMethod superPatternMethod) {
        super(compareConfiguration);
        this.patternMethod = patternMethod;
        this.superPatternMethod = superPatternMethod;
    }

    protected Object prepareInput(IProgressMonitor pm) {
        DiffNode diffNode;
        MethodCompareItem left = new MethodCompareItem(this.superPatternMethod);
        MethodCompareItem right = new MethodCompareItem(this.patternMethod);
        PatternMethod superSuperPattern = CompareHelper.getSuperMethod(this.superPatternMethod);
        if (superSuperPattern != null) {
            MethodCompareItem ancestor = new MethodCompareItem(superSuperPattern);
            diffNode = new DiffNode(12, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
        } else {
            diffNode = new DiffNode((ITypedElement)left, (ITypedElement)right);
        }
        this.getCompareConfiguration().setDefaultLabelProvider((ICompareInputLabelProvider)labelProvider);
        return diffNode;
    }
}

