/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.portfolio.genchain.generationChain.EmfGeneration;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.ecore.EcoreImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreImporterHelper {
    protected static final BasicMonitor MONITOR = new BasicMonitor();
    protected static final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    protected static final String GENMODEL_EXT = ".genmodel";
    protected static final String FCORE_EXT = ".fcore";
    protected static final String ECORE_EXT = ".ecore";
    private EcoreImporter importer;

    public static EcoreImporter createDefaultEcoreImporter() throws Exception {
        return new EcoreImporter();
    }

    public static EcoreImporter createEcoreImporter(IPath containterPath, URI ecoreURI, EmfGeneration model) throws Exception {
        return EcoreImporterHelper.doCreateEcoreImporter(new EcoreImporterHelper(), containterPath, ecoreURI, model);
    }

    protected static EcoreImporter doCreateEcoreImporter(EcoreImporterHelper helper, IPath containterPath, URI ecoreURI, EmfGeneration model) throws Exception {
        helper.importer = new EcoreImporter(){

            public ResourceSet createResourceSet() {
                return new TargetPlatformResourceSet();
            }

            protected List<Resource> computeResourcesToBeSaved() {
                UniqueEList.FastCompare resources = new UniqueEList.FastCompare();
                Resource genModelResource = this.getGenModel().eResource();
                resources.add(genModelResource);
                for (GenPackage genPackage : this.getGenModel().getUsedGenPackages()) {
                    if (genPackage.eResource() != genModelResource) continue;
                    resources.add(genPackage.getEcorePackage().eResource());
                }
                return resources;
            }
        };
        helper.importer.setGenModelContainerPath(containterPath);
        String name = ecoreURI.lastSegment().replace(ECORE_EXT, GENMODEL_EXT);
        helper.importer.setGenModelFileName(name);
        helper.importer.setModelLocation(ecoreURI.toString());
        helper.importer.computeDefaultGenModelFileName();
        helper.importer.prepareGenModelAndEPackages((Monitor)MONITOR);
        EList genPackages = helper.importer.getGenModel().getGenPackages();
        helper.addEPackages(containterPath, ecoreURI, helper.importer, model);
        helper.importer.saveGenModelAndEPackages((Monitor)MONITOR);
        return helper.importer;
    }

    private static Map<String, EPackage> asMap(List<EPackage> packages) {
        HashMap<String, EPackage> uri2package = new HashMap<String, EPackage>();
        for (EPackage pack : packages) {
            uri2package.put(pack.getNsURI(), pack);
        }
        return uri2package;
    }

    protected void addEPackages(IPath containterPath, URI ecoreURI, EcoreImporter ecoreImporter, EmfGeneration model) throws Exception {
        ResourceSet resourceSet = ecoreImporter.getGenModel().eResource().getResourceSet();
        List<EPackage> ePackages = EcoreImporterHelper.getOwnEPackages(resourceSet, ecoreURI);
        GenModel genModel = ecoreImporter.getGenModel();
        genModel.initialize(ePackages);
        ecoreImporter.computeEPackages((Monitor)MONITOR);
        ecoreImporter.adjustEPackages((Monitor)MONITOR);
        List allEPackages = ecoreImporter.getEPackages();
        Map<String, EPackage> requiredEPackages = EcoreImporterHelper.asMap(allEPackages);
        for (EPackage ePackage : ePackages) {
            requiredEPackages.remove(ePackage.getNsURI());
        }
        for (EPackage ePackage : requiredEPackages.values()) {
            List<GenPackage> genModels = EcoreImporterHelper.getPluginGenModel(ePackage);
            if (genModels.isEmpty()) {
                Path ecorePath = new Path(ePackage.eResource().getURI().toString());
                Resource resource = EcoreImporterHelper.getGenModelResource((IPath)ecorePath, genModel, model);
                if (resource != null && !resource.getContents().isEmpty()) {
                    for (EObject obj : resource.getContents()) {
                        genModel.getUsedGenPackages().addAll((Collection)((GenModel)obj).getGenPackages());
                    }
                    continue;
                }
                this.handleMissingGenmodel(resourceSet, genModel, (IPath)ecorePath);
                continue;
            }
            genModel.getUsedGenPackages().addAll(genModels);
        }
    }

    protected void handleMissingGenmodel(ResourceSet resourceSet, GenModel genModel, IPath ecorePath) {
        throw new RuntimeException("can't find genmodel for " + ecorePath);
    }

    private static Resource getGenModelResource(IPath ecorePath, GenModel genModel, EmfGeneration model) {
        TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
        IPath path = ecorePath.removeFileExtension().addFileExtension("genmodel");
        URI uri = URI.createURI((String)path.toString());
        Resource resource = null;
        try {
            resource = resourceSet.getResource(uri, true);
            if (resource != null && !resource.getContents().isEmpty()) {
                return resource;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        IPath ecoreAbsolutePath = ecorePath.setDevice(null).removeFirstSegments(1).makeAbsolute();
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)EcoreUtil.getRootContainer((EObject)model), (boolean)false);
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof EmfGeneration)) continue;
            EmfGeneration emfGeneration = (EmfGeneration)next;
            path = new Path(emfGeneration.getPluginName()).append(ecorePath.removeFirstSegments(2)).removeFileExtension().addFileExtension("genmodel");
            uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)false);
            if (!emfGeneration.getModelPath().equals(ecoreAbsolutePath.toString())) continue;
            try {
                resource = resourceSet.getResource(uri, true);
                if (resource == null || resource.getContents().isEmpty()) continue;
                return resource;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static List<GenPackage> getPluginGenModel(EPackage ePackage) {
        ResourceSet resourceSet = ePackage.eResource().getResourceSet();
        Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        for (Map.Entry entry : ePackageNsURItoGenModelLocationMap.entrySet()) {
            if (!((String)entry.getKey()).equals(ePackage.getNsURI())) continue;
            URI value = (URI)entry.getValue();
            Resource resource = resourceSet.getResource(value, true);
            GenModel eObject = (GenModel)resource.getContents().get(0);
            return eObject.getGenPackages();
        }
        return Collections.emptyList();
    }

    private static List<EPackage> getOwnEPackages(ResourceSet resourceSet, URI ecoreURI) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        Resource resource = resourceSet.getResource(ecoreURI, true);
        TreeIterator allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)next;
            result.add(ePackage);
        }
        return result;
    }
}

