/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.adapter;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.model.ftask.FtaskPackage;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.types.TypesPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class ModelElementBundleAdapter
extends EContentAdapter {
    private Resource _resource;
    private IWorkbenchWindow _window;

    public ModelElementBundleAdapter(Resource resource) {
        this._window = EGFModelEditorPlugin.getActiveWorkbenchWindow();
        this._resource = resource;
    }

    public ModelElementBundleAdapter(Resource resource, IWorkbenchPartSite site) {
        this._window = site != null ? site.getWorkbenchWindow() : EGFModelEditorPlugin.getActiveWorkbenchWindow();
        this._resource = resource;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNewValue() != null && notification.getNewValue() instanceof ModelElement) {
            this.handleNotification(notification);
        }
    }

    private void handleNotification(Notification notification) {
        if (notification.getEventType() == 3 || notification.getEventType() == 1 || notification.getEventType() == 5) {
            ModelElement modelElement = (ModelElement)notification.getNewValue();
            Resource resource = modelElement.eResource();
            if (resource != this._resource || ((ResourceImpl)resource).isLoading()) {
                return;
            }
            IProject project = EMFHelper.getProject((Resource)resource);
            if (project == null) {
                return;
            }
            Collection patterns = EMFHelper.getAllProperContents((EClassifier)PatternPackage.eINSTANCE.getPattern(), (EObject)EcoreUtil.getRootContainer((EObject)modelElement, (boolean)true));
            Collection tasks = EMFHelper.getAllProperContents((EClassifier)FtaskPackage.eINSTANCE.getTask(), (EObject)EcoreUtil.getRootContainer((EObject)modelElement, (boolean)true));
            Collection typeClasses = EMFHelper.getAllProperContents((EClassifier)TypesPackage.eINSTANCE.getTypeClass(), (EObject)EcoreUtil.getRootContainer((EObject)modelElement, (boolean)true));
            ConvertProjectOperation operation = null;
            if (patterns.isEmpty() && tasks.isEmpty()) {
                if (!typeClasses.isEmpty()) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (javaProject != null && javaProject.exists()) {
                        try {
                            javaProject.close();
                        }
                        catch (JavaModelException javaModelException) {
                            // empty catch block
                        }
                        return;
                    }
                    operation = new ConvertProjectOperation(project, true, true);
                    operation.setInitialDependencies(new String[]{"org.eclipse.egf.model.ftask"});
                    operation.setInitialSourceFolders(new String[]{"src"});
                }
            } else if (patterns.isEmpty() && !tasks.isEmpty()) {
                operation = new ConvertProjectOperation(project, true, true);
                operation.setInitialDependencies(new String[]{"org.eclipse.egf.model.ftask"});
                operation.setInitialSourceFolders(new String[]{"src"});
            } else {
                operation = new ConvertProjectOperation(project, true, true);
                operation.setInitialDependencies(new String[]{"org.eclipse.egf.pattern", "org.eclipse.egf.pattern.ftask"});
                operation.setInitialSourceFolders(new String[]{"generated"});
            }
            try {
                if (operation != null) {
                    this._window.run(false, false, (IRunnableWithProgress)operation);
                    this._window.getWorkbench().getDisplay().readAndDispatch();
                }
            }
            catch (InterruptedException javaProject) {
            }
            catch (Exception e) {
                ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)e);
            }
        }
    }
}

