/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.builder;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.engine.TranslationHelper;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;

public class PatternBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return new IProject[0];
        }
        PatternHelper helper = null;
        List patterns = null;
        try {
            Set<String> patternIds = null;
            IResourceDelta delta = this.getDelta(project);
            if (delta != null && delta.getKind() != 0) {
                PatternVisitor patternVisitor = new PatternVisitor();
                delta.accept((IResourceDeltaVisitor)patternVisitor);
                patternIds = patternVisitor.getPatternId2translate();
                if (patternIds.isEmpty()) {
                    return null;
                }
            }
            try {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                helper = PatternHelper.createCollector();
                patterns = helper.getPatterns(project, patternIds);
                if (delta != null) {
                    TranslationHelper.translate((IProgressMonitor)monitor, (List)patterns);
                } else {
                    TranslationHelper.translate((IProgressMonitor)monitor, new HashSet(patterns));
                }
            }
            catch (OperationCanceledException oce) {
                throw oce;
            }
            catch (Throwable t) {
                EGFPatternPlugin.getDefault().logError(EGFPatternMessages.PatternBuilding_Failed, t);
            }
        }
        finally {
            monitor.done();
            if (helper != null) {
                helper.clear();
            }
            if (patterns != null) {
                patterns.clear();
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PatternVisitor
    implements IResourceDeltaVisitor {
        private final Set<String> patternId2translate = new HashSet<String>();

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() != 2 && TemplateModelFileHelper.PATTERN_UNIT_FILE_EXTENSION.equals(resource.getFileExtension()) && delta.getFlags() != 131072) {
                    try {
                        this.patternId2translate.add(TemplateModelFileHelper.extractPatternId((IPath)resource.getProjectRelativePath()));
                    }
                    catch (TemplateModelFileHelper.FilenameFormatException e) {
                        EGFPatternPlugin.getDefault().logError((Throwable)e);
                    }
                }
                return false;
            }
            return true;
        }

        public Set<String> getPatternId2translate() {
            return this.patternId2translate;
        }
    }
}

