/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.usecase.emf.uc3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.portfolio.file.resources.EGFFileResourcesActivator;
import org.eclipse.egf.portfolio.file.resources.FileUtil;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;

public class CreateEmfInfoFileTask
implements ITaskProduction {
    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        StringBuffer result = new StringBuffer();
        EMFDomain domain = (EMFDomain)productionContext.getInputValue((Object)"domain", EMFDomain.class);
        String APIType = ((String)productionContext.getInputValue((Object)"APIType", String.class)).toLowerCase();
        String contents = (String)productionContext.getInputValue((Object)"contents", String.class);
        String folder = (String)productionContext.getInputValue((Object)"folder", String.class);
        String fileName = (String)productionContext.getInputValue((Object)"fileName", String.class);
        GenModel genmodel = (GenModel)domain.getContent().get(0);
        String projectName = this.getPluginId(genmodel, APIType);
        result.append(contents).append("\n").append(this.getEmfInfo(genmodel, APIType));
        this.writeInFile(monitor, result, folder, fileName, projectName);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    private String getEmfInfo(GenModel genmodel, String APIType) {
        StringBuffer result = new StringBuffer();
        result.append("Model name: ").append(genmodel.getModelName()).append("\n\n").append("Compliance level: ").append(genmodel.getComplianceLevel().toString()).append("\n").append("Runtime platform: ").append("Runtime version: ").append(genmodel.getRuntimeVersion()).append("\n\n");
        if ("model".equals(APIType)) {
            result.append("Model directory: ").append(genmodel.getModelDirectory()).append("\n").append("Root extends class: ").append(genmodel.getRootExtendsClass()).append("\n").append("Root extends interface: ").append(genmodel.getRootExtendsInterface()).append("\n");
        }
        if ("edit".equals(APIType)) {
            result.append("Edit directory: ").append(genmodel.getEditDirectory()).append("\n");
        }
        if ("editor".equals(APIType)) {
            result.append("Editor directory: ").append(genmodel.getEditorDirectory()).append("\n");
        }
        return result.toString();
    }

    private String getPluginId(GenModel genmodel, String APIType) {
        if ("model".equals(APIType)) {
            return genmodel.getModelPluginID();
        }
        if ("edit".equals(APIType)) {
            return genmodel.getEditPluginID();
        }
        if ("editor".equals(APIType)) {
            return genmodel.getEditorPluginID();
        }
        return genmodel.getModelPluginID();
    }

    private void writeInFile(IProgressMonitor monitor, StringBuffer result, String folder, String fileName, String projectName) throws InvocationException {
        ByteArrayInputStream fileContents = new ByteArrayInputStream(result.toString().getBytes());
        try {
            IFile file = FileUtil.getNewFile((String)projectName, (String)folder, (String)fileName);
            if (file.exists()) {
                file.setContents((InputStream)fileContents, true, false, monitor);
            } else {
                FileHelper.createContainers((IProgressMonitor)monitor, (IResource)file);
                file.create((InputStream)fileContents, true, monitor);
            }
        }
        catch (Throwable t) {
            if (t instanceof CoreException) {
                throw new InvocationException(t);
            }
            throw new InvocationException((Throwable)new CoreException(EGFFileResourcesActivator.getDefault().newStatus(4, "Unexpected Exception", t)));
        }
    }
}

