/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.RebaseOperation;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.WrongGitFlowStateException;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.GitFlowOperation;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public final class FeatureRebaseOperation
extends GitFlowOperation {
    private RebaseResult operationResult;

    public FeatureRebaseOperation(GitFlowRepository repository) {
        super(repository);
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        try {
            if (!this.repository.isFeature()) {
                throw new WrongGitFlowStateException(CoreText.AbstractFeatureOperation_notOnAFeatureBranch);
            }
            Repository jgitRepo = this.repository.getRepository();
            Ref develop = jgitRepo.exactRef(this.repository.getConfig().getDevelopFull());
            RebaseOperation op = new RebaseOperation(jgitRepo, develop);
            op.execute(monitor);
            this.operationResult = op.getResult();
        }
        catch (IOException | WrongGitFlowStateException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    public RebaseResult getOperationResult() {
        return this.operationResult;
    }
}

