/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class FanProcessor
implements ILayoutProcessor<TGraph> {
    private Map<String, Integer> gloFanMap = new HashMap<String, Integer>();
    private Map<String, Integer> gloDescMap = new HashMap<String, Integer>();

    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor compute fanout", 1.0f);
        this.gloFanMap.clear();
        this.gloDescMap.clear();
        TNode root = null;
        Iterator<TNode> it = tGraph.getNodes().iterator();
        while (root == null && it.hasNext()) {
            TNode tNode = it.next();
            if (!((Boolean)tNode.getProperty(InternalProperties.ROOT)).booleanValue()) continue;
            root = tNode;
        }
        LinkedList<TNode> rootLevel = new LinkedList<TNode>();
        rootLevel.add(root);
        this.calculateFan(rootLevel);
        for (TNode tNode : tGraph.getNodes()) {
            String key = (String)tNode.getProperty(InternalProperties.ID);
            int fan = this.gloFanMap.get(key) != null ? this.gloFanMap.get(key) : 0;
            tNode.setProperty(InternalProperties.FAN, fan);
            int desc = 1 + (this.gloDescMap.get(key) != null ? this.gloDescMap.get(key) : 0);
            tNode.setProperty(InternalProperties.DESCENDANTS, desc);
        }
        progressMonitor.done();
    }

    private void calculateFan(LinkedList<TNode> currentLevel) {
        if (!currentLevel.isEmpty()) {
            LinkedList<TNode> nextLevel = new LinkedList<TNode>();
            Object id = null;
            String pId = null;
            int digits = (int)(Math.floor(Math.log10(currentLevel.size())) + 1.0);
            int index = 0;
            for (TNode tNode : currentLevel) {
                if (pId != tNode.getProperty(InternalProperties.ID)) {
                    pId = (String)tNode.getProperty(InternalProperties.ID);
                    index = 0;
                }
                id = pId != null ? pId + FanProcessor.formatRight(index++, digits) : FanProcessor.formatRight(index++, digits);
                tNode.setProperty(InternalProperties.ID, id);
                for (TNode tChild : tNode.getChildren()) {
                    nextLevel.add(tChild);
                    tChild.setProperty(InternalProperties.ID, id);
                }
            }
            HashMap<String, Integer> locFanMap = new HashMap<String, Integer>();
            int i = 0;
            while (i < ((String)id).length() - digits) {
                for (TNode tNode : currentLevel) {
                    String key = ((String)tNode.getProperty(InternalProperties.ID)).substring(0, i + 1);
                    int blockSize = locFanMap.get(key) != null ? (Integer)locFanMap.get(key) + 1 : 1;
                    locFanMap.put(key, blockSize);
                }
                ++i;
            }
            for (Map.Entry locEntry : locFanMap.entrySet()) {
                Integer gloValue = this.gloDescMap.get(locEntry.getKey()) != null ? this.gloDescMap.get(locEntry.getKey()) : 0;
                this.gloDescMap.put((String)locEntry.getKey(), (Integer)locEntry.getValue() + gloValue);
                gloValue = this.gloFanMap.get(locEntry.getKey());
                if (gloValue != null && gloValue >= (Integer)locEntry.getValue()) continue;
                this.gloFanMap.put((String)locEntry.getKey(), (Integer)locEntry.getValue());
            }
            this.calculateFan(nextLevel);
        }
    }

    public static String formatRight(int value, int len) {
        String s = "" + value;
        while (s.length() < len) {
            s = "0" + s;
        }
        return s;
    }
}

