/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph.transform;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.common.nodespacing.NodeLabelAndSizeCalculator;
import org.eclipse.elk.alg.layered.components.ComponentOrderingStrategy;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphElement;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPadding;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.CycleBreakingStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.LayeredSpacings;
import org.eclipse.elk.alg.layered.options.LayeringStrategy;
import org.eclipse.elk.alg.layered.options.NodePlacementStrategy;
import org.eclipse.elk.alg.layered.options.NodePromotionStrategy;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.UnsupportedGraphException;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.labels.LabelManagementOptions;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.math.Spacing;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.HierarchyHandling;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.adapters.ElkGraphAdapters;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class ElkGraphImporter {
    private final Map<ElkGraphElement, LGraphElement> nodeAndPortMap = Maps.newHashMap();

    ElkGraphImporter() {
    }

    public LGraph importGraph(ElkNode elkgraph) {
        LGraph topLevelGraph = this.createLGraph(elkgraph);
        EList ports = elkgraph.getPorts();
        elkgraph.getPorts().stream().forEach(elkport -> this.ensureDefinedPortSide(topLevelGraph, (ElkPort)elkport));
        Set graphProperties = (Set)topLevelGraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        this.checkExternalPorts(elkgraph, graphProperties);
        if (graphProperties.contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            for (ElkPort elkport2 : elkgraph.getPorts()) {
                this.transformExternalPort(elkgraph, topLevelGraph, elkport2);
            }
        }
        if (this.shouldCalculateMinimumGraphSize(elkgraph)) {
            this.calculateMinimumGraphSize(elkgraph, topLevelGraph);
        }
        if (((Boolean)topLevelGraph.getProperty(LayeredOptions.PARTITIONING_ACTIVATE)).booleanValue()) {
            graphProperties.add(GraphProperties.PARTITIONS);
        }
        if (topLevelGraph.hasProperty(LayeredOptions.SPACING_BASE_VALUE)) {
            LayeredSpacings.withBaseValue((Double)topLevelGraph.getProperty(LayeredOptions.SPACING_BASE_VALUE)).apply((IPropertyHolder)topLevelGraph);
        }
        if (elkgraph.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN) {
            this.importHierarchicalGraph(elkgraph, topLevelGraph);
        } else {
            this.importFlatGraph(elkgraph, topLevelGraph);
        }
        return topLevelGraph;
    }

    private void ensureDefinedPortSide(LGraph lgraph, ElkPort elkport) {
        Direction layoutDirection = (Direction)lgraph.getProperty(LayeredOptions.DIRECTION);
        PortSide portSide = (PortSide)elkport.getProperty(LayeredOptions.PORT_SIDE);
        PortConstraints portConstraints = (PortConstraints)lgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        if (!portConstraints.isSideFixed()) {
            int netFlow = this.calculateNetFlow(elkport);
            portSide = netFlow > 0 ? PortSide.fromDirection((Direction)layoutDirection) : PortSide.fromDirection((Direction)layoutDirection).opposed();
        } else if (portSide == PortSide.UNDEFINED && (portSide = ElkUtil.calcPortSide((ElkPort)elkport, (Direction)layoutDirection)) == PortSide.UNDEFINED) {
            portSide = PortSide.fromDirection((Direction)layoutDirection);
        }
        elkport.setProperty(LayeredOptions.PORT_SIDE, (Object)portSide);
    }

    private boolean shouldCalculateMinimumGraphSize(ElkNode elkgraph) {
        return !((EnumSet)elkgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS)).isEmpty();
    }

    private void calculateMinimumGraphSize(ElkNode elkgraph, LGraph lgraph) {
        if (elkgraph.getParent() == null) {
            return;
        }
        EnumSet sizeConstraints = (EnumSet)lgraph.getProperty(LayeredOptions.NODE_SIZE_CONSTRAINTS);
        assert (!sizeConstraints.isEmpty());
        if (elkgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS) == PortConstraints.UNDEFINED) {
            elkgraph.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FREE);
        }
        ElkGraphAdapters.ElkGraphAdapter graphAdapter = ElkGraphAdapters.adapt((ElkNode)elkgraph.getParent());
        ElkGraphAdapters.ElkNodeAdapter nodeAdapter = ElkGraphAdapters.adaptSingleNode((ElkNode)elkgraph);
        KVector minSize = NodeLabelAndSizeCalculator.process((GraphAdapters.GraphAdapter)graphAdapter, (GraphAdapters.NodeAdapter)nodeAdapter, (boolean)false, (boolean)true);
        sizeConstraints.add(SizeConstraint.MINIMUM_SIZE);
        KVector configuredMinSize = (KVector)lgraph.getProperty(LayeredOptions.NODE_SIZE_MINIMUM);
        configuredMinSize.x = Math.max(minSize.x, configuredMinSize.x);
        configuredMinSize.y = Math.max(minSize.y, configuredMinSize.y);
    }

    private void importFlatGraph(ElkNode elkgraph, LGraph lgraph) {
        ElkNode source;
        int index = 0;
        for (ElkNode child : elkgraph.getChildren()) {
            if (((Boolean)child.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue()) continue;
            if (this.needsModelOrder(child)) {
                child.setProperty(InternalProperties.MODEL_ORDER, (Object)index);
                ++index;
            }
            this.transformNode(child, lgraph);
        }
        index = 0;
        for (ElkEdge elkedge : elkgraph.getContainedEdges()) {
            if (this.needsModelOrderBasedOnParent(elkgraph)) {
                elkedge.setProperty(InternalProperties.MODEL_ORDER, (Object)index);
                ++index;
            }
            source = ElkGraphUtil.getSourceNode((ElkEdge)elkedge);
            ElkNode target = ElkGraphUtil.getTargetNode((ElkEdge)elkedge);
            boolean enableInsideSelfLoops = (Boolean)source.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
            boolean isToBeLaidOut = (Boolean)elkedge.getProperty(LayeredOptions.NO_LAYOUT) == false;
            boolean isInsideSelfLoop = enableInsideSelfLoops && elkedge.isSelfloop() && (Boolean)elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            boolean connectsSiblings = source.getParent() == elkgraph && source.getParent() == target.getParent();
            boolean connectsToGraph = (source.getParent() == elkgraph && target == elkgraph) ^ (target.getParent() == elkgraph && source == elkgraph);
            if (!isToBeLaidOut || isInsideSelfLoop || !connectsToGraph && !connectsSiblings) continue;
            this.transformEdge(elkedge, elkgraph, lgraph);
        }
        if (elkgraph.getParent() != null) {
            for (ElkEdge elkedge : elkgraph.getParent().getContainedEdges()) {
                boolean isInsideSelfLoop;
                source = ElkGraphUtil.getSourceNode((ElkEdge)elkedge);
                if (source != elkgraph || !elkedge.isSelfloop()) continue;
                boolean bl = isInsideSelfLoop = (Boolean)source.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false && (Boolean)elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                if (!isInsideSelfLoop) continue;
                this.transformEdge(elkedge, elkgraph, lgraph);
            }
        }
    }

    private void importHierarchicalGraph(ElkNode elkgraph, LGraph lgraph) {
        LNode parentLNode;
        LGraph parentLGraph;
        LinkedList elkGraphQueue = Lists.newLinkedList();
        Direction parentGraphDirection = (Direction)lgraph.getProperty(LayeredOptions.DIRECTION);
        int index = 0;
        elkGraphQueue.addAll(elkgraph.getChildren());
        while (!elkGraphQueue.isEmpty()) {
            boolean isNodeToBeLaidOut;
            ElkNode elknode = (ElkNode)elkGraphQueue.poll();
            if (this.needsModelOrder(elknode)) {
                elknode.setProperty(InternalProperties.MODEL_ORDER, (Object)index++);
            }
            boolean bl = isNodeToBeLaidOut = (Boolean)elknode.getProperty(LayeredOptions.NO_LAYOUT) == false;
            if (!isNodeToBeLaidOut) continue;
            boolean hasChildren = !elknode.getChildren().isEmpty();
            boolean hasInsideSelfLoops = this.hasInsideSelfLoops(elknode);
            boolean hasHierarchyHandlingEnabled = elknode.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
            boolean usesElkLayered = !elknode.hasProperty(CoreOptions.ALGORITHM) || "org.eclipse.elk.layered".endsWith((String)elknode.getProperty(CoreOptions.ALGORITHM));
            LGraph nestedGraph = null;
            if (usesElkLayered && hasHierarchyHandlingEnabled && (hasChildren || hasInsideSelfLoops)) {
                nestedGraph = this.createLGraph(elknode);
                nestedGraph.setProperty(LayeredOptions.DIRECTION, parentGraphDirection);
                if (nestedGraph.hasProperty(LayeredOptions.SPACING_BASE_VALUE)) {
                    LayeredSpacings.withBaseValue((Double)nestedGraph.getProperty(LayeredOptions.SPACING_BASE_VALUE)).apply((IPropertyHolder)nestedGraph);
                }
                if (this.shouldCalculateMinimumGraphSize(elknode)) {
                    LGraph finalNestedGraph = nestedGraph;
                    elknode.getPorts().stream().forEach(elkport -> this.ensureDefinedPortSide(finalNestedGraph, (ElkPort)elkport));
                    this.calculateMinimumGraphSize(elknode, nestedGraph);
                }
            }
            parentLGraph = lgraph;
            parentLNode = (LNode)this.nodeAndPortMap.get(elknode.getParent());
            if (parentLNode != null) {
                parentLGraph = parentLNode.getNestedGraph();
            }
            LNode lnode = this.transformNode(elknode, parentLGraph);
            if (nestedGraph == null) continue;
            lnode.setNestedGraph(nestedGraph);
            nestedGraph.setParentNode(lnode);
            elkGraphQueue.addAll(elknode.getChildren());
        }
        index = 0;
        elkGraphQueue.add(elkgraph);
        while (!elkGraphQueue.isEmpty()) {
            boolean hasHierarchyHandlingEnabled;
            ElkNode elkGraphNode = (ElkNode)elkGraphQueue.poll();
            for (ElkEdge elkedge : elkGraphNode.getContainedEdges()) {
                this.checkEdgeValidity(elkedge);
                if (this.needsModelOrderBasedOnParent(elkgraph)) {
                    elkedge.setProperty(InternalProperties.MODEL_ORDER, (Object)index++);
                }
                ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getSources().get(0)));
                ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getTargets().get(0)));
                if (((Boolean)elkedge.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue() || ((Boolean)sourceNode.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue() || ((Boolean)targetNode.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue()) continue;
                boolean isInsideSelfLoop = elkedge.isSelfloop() && (Boolean)sourceNode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE) != false && (Boolean)elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                ElkNode parentElkGraph = elkGraphNode;
                if (isInsideSelfLoop || ElkGraphUtil.isDescendant((ElkNode)targetNode, (ElkNode)sourceNode)) {
                    parentElkGraph = sourceNode;
                } else if (ElkGraphUtil.isDescendant((ElkNode)sourceNode, (ElkNode)targetNode)) {
                    parentElkGraph = targetNode;
                }
                parentLGraph = lgraph;
                parentLNode = (LNode)this.nodeAndPortMap.get(parentElkGraph);
                if (parentLNode != null) {
                    parentLGraph = parentLNode.getNestedGraph();
                }
                LEdge ledge = this.transformEdge(elkedge, parentElkGraph, parentLGraph);
                ledge.setProperty(InternalProperties.COORDINATE_SYSTEM_ORIGIN, this.findCoordinateSystemOrigin(elkedge, elkgraph, lgraph));
            }
            boolean bl = hasHierarchyHandlingEnabled = elkGraphNode.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
            if (!hasHierarchyHandlingEnabled) continue;
            for (ElkNode elkChildGraphNode : elkGraphNode.getChildren()) {
                boolean partOfSameLayoutRun;
                boolean usesElkLayered = !elkChildGraphNode.hasProperty(CoreOptions.ALGORITHM) || "org.eclipse.elk.layered".endsWith((String)elkChildGraphNode.getProperty(CoreOptions.ALGORITHM));
                boolean bl2 = partOfSameLayoutRun = elkChildGraphNode.getProperty(LayeredOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN;
                if (!usesElkLayered || !partOfSameLayoutRun) continue;
                elkGraphQueue.add(elkChildGraphNode);
            }
        }
    }

    private boolean needsModelOrder(ElkNode child) {
        ElkNode elkgraph = child.getParent();
        return this.needsModelOrderBasedOnParent(elkgraph) && (Boolean)child.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_NO_MODEL_ORDER) == false;
    }

    private boolean needsModelOrderBasedOnParent(ElkNode elkgraph) {
        return elkgraph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_STRATEGY) != OrderingStrategy.NONE || elkgraph.getProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY) == CycleBreakingStrategy.MODEL_ORDER || elkgraph.getProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY) == CycleBreakingStrategy.GREEDY_MODEL_ORDER || (Boolean)elkgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_FORCE_NODE_MODEL_ORDER) != false || elkgraph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_COMPONENTS) != ComponentOrderingStrategy.NONE || elkgraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_STRATEGY) == NodePromotionStrategy.MODEL_ORDER_LEFT_TO_RIGHT || elkgraph.getProperty(LayeredOptions.LAYERING_NODE_PROMOTION_STRATEGY) == NodePromotionStrategy.MODEL_ORDER_RIGHT_TO_LEFT || elkgraph.getProperty(LayeredOptions.LAYERING_STRATEGY) == LayeringStrategy.BF_MODEL_ORDER || elkgraph.getProperty(LayeredOptions.LAYERING_STRATEGY) == LayeringStrategy.DF_MODEL_ORDER;
    }

    private boolean hasInsideSelfLoops(ElkNode elknode) {
        if (((Boolean)elknode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE)).booleanValue()) {
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)elknode)) {
                if (!edge.isSelfloop() || !((Boolean)edge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private LGraph findCoordinateSystemOrigin(ElkEdge elkedge, ElkNode topLevelElkGraph, LGraph topLevelLGraph) {
        LGraph lgraph;
        ElkNode source = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getSources().get(0)));
        ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getTargets().get(0)));
        if (source.getParent() == target.getParent()) {
            return null;
        }
        if (ElkGraphUtil.isDescendant((ElkNode)target, (ElkNode)source)) {
            return null;
        }
        ElkNode origin = elkedge.getContainingNode();
        assert (source == origin || ElkGraphUtil.isDescendant((ElkNode)source, (ElkNode)origin));
        assert (target == origin || ElkGraphUtil.isDescendant((ElkNode)target, (ElkNode)origin));
        if (origin == topLevelElkGraph) {
            return topLevelLGraph;
        }
        LNode lnode = (LNode)this.nodeAndPortMap.get(origin);
        if (lnode != null && (lgraph = lnode.getNestedGraph()) != null) {
            return lgraph;
        }
        return null;
    }

    private LGraph createLGraph(ElkNode elkgraph) {
        LGraph lgraph = new LGraph();
        lgraph.copyProperties((IPropertyHolder)elkgraph);
        if (lgraph.getProperty(LayeredOptions.DIRECTION) == Direction.UNDEFINED) {
            lgraph.setProperty(LayeredOptions.DIRECTION, LGraphUtil.getDirection(lgraph));
        }
        if (lgraph.getProperty(LabelManagementOptions.LABEL_MANAGER) == null) {
            ElkGraphElement root = (ElkGraphElement)EcoreUtil.getRootContainer((EObject)elkgraph);
            lgraph.setProperty(LabelManagementOptions.LABEL_MANAGER, (ILabelManager)root.getProperty(LabelManagementOptions.LABEL_MANAGER));
        }
        lgraph.setProperty(InternalProperties.ORIGIN, elkgraph);
        lgraph.setProperty(InternalProperties.GRAPH_PROPERTIES, EnumSet.noneOf(GraphProperties.class));
        ElkPadding nodeLabelpadding = NodeLabelAndSizeCalculator.computeInsideNodeLabelPadding((GraphAdapters.GraphAdapter)(elkgraph.getParent() == null ? null : ElkGraphAdapters.adapt((ElkNode)elkgraph.getParent())), (GraphAdapters.NodeAdapter)ElkGraphAdapters.adaptSingleNode((ElkNode)elkgraph), (Direction)Direction.RIGHT);
        ElkPadding nodePadding = (ElkPadding)lgraph.getProperty(LayeredOptions.PADDING);
        LPadding lPadding = lgraph.getPadding();
        lPadding.add((Spacing)nodePadding);
        lPadding.add((Spacing)nodeLabelpadding);
        return lgraph;
    }

    private void checkExternalPorts(ElkNode elkgraph, Set<GraphProperties> graphProperties) {
        boolean enableSelfLoops = (Boolean)elkgraph.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
        Set portLabelPlacement = (Set)elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT);
        boolean hasExternalPorts = false;
        boolean hasHyperedges = false;
        Iterator portIterator = elkgraph.getPorts().iterator();
        while (!(!portIterator.hasNext() || hasExternalPorts && hasHyperedges)) {
            ElkPort elkport = (ElkPort)portIterator.next();
            int externalPortEdges = 0;
            for (ElkEdge elkedge : ElkGraphUtil.allIncidentEdges((ElkConnectableShape)elkport)) {
                boolean connectsToChild;
                boolean isInsideSelfLoop;
                boolean bl = isInsideSelfLoop = enableSelfLoops && elkedge.isSelfloop() && (Boolean)elkedge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
                boolean bl2 = elkedge.getSources().contains((Object)elkport) ? elkgraph == ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getTargets().get(0))).getParent() : (connectsToChild = elkgraph == ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)elkedge.getSources().get(0))).getParent());
                if ((isInsideSelfLoop || connectsToChild) && ++externalPortEdges > 1) break;
            }
            if (externalPortEdges > 0) {
                hasExternalPorts = true;
            } else if (portLabelPlacement.contains(PortLabelPlacement.INSIDE) && elkport.getLabels().size() > 0) {
                hasExternalPorts = true;
            }
            if (externalPortEdges <= 1) continue;
            hasHyperedges = true;
        }
        if (hasExternalPorts) {
            graphProperties.add(GraphProperties.EXTERNAL_PORTS);
        }
        if (hasHyperedges) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
    }

    private void transformExternalPort(ElkNode elkgraph, LGraph lgraph, ElkPort elkport) {
        KVector elkportPosition = new KVector(elkport.getX() + elkport.getWidth() / 2.0, elkport.getY() + elkport.getHeight() / 2.0);
        int netFlow = this.calculateNetFlow(elkport);
        PortConstraints portConstraints = (PortConstraints)elkgraph.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        PortSide portSide = (PortSide)elkport.getProperty(LayeredOptions.PORT_SIDE);
        assert (portSide != PortSide.UNDEFINED);
        if (!elkport.getAllProperties().containsKey(LayeredOptions.PORT_BORDER_OFFSET)) {
            double portOffset = elkport.getX() == 0.0 && elkport.getY() == 0.0 ? 0.0 : ElkUtil.calcPortOffset((ElkPort)elkport, (PortSide)portSide);
            elkport.setProperty(LayeredOptions.PORT_BORDER_OFFSET, (Object)portOffset);
        }
        KVector graphSize = new KVector(elkgraph.getWidth(), elkgraph.getHeight());
        LNode dummy = LGraphUtil.createExternalPortDummy((IPropertyHolder)elkport, portConstraints, portSide, netFlow, graphSize, elkportPosition, new KVector(elkport.getWidth(), elkport.getHeight()), (Direction)lgraph.getProperty(LayeredOptions.DIRECTION), lgraph);
        dummy.setProperty(InternalProperties.ORIGIN, elkport);
        LPort dummyPort = dummy.getPorts().get(0);
        dummyPort.setConnectedToExternalNodes(this.isConnectedToExternalNodes(elkport));
        dummy.setProperty(LayeredOptions.PORT_LABELS_PLACEMENT, PortLabelPlacement.outside());
        boolean insidePortLabels = ((EnumSet)elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT)).contains(PortLabelPlacement.INSIDE);
        for (ElkLabel elklabel : elkport.getLabels()) {
            if (((Boolean)elklabel.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            LLabel llabel = this.transformLabel(elklabel);
            dummyPort.getLabels().add(llabel);
            if (insidePortLabels) continue;
            double insidePart = 0.0;
            if (PortLabelPlacement.isFixed((Set)((Set)elkgraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT)))) {
                insidePart = ElkUtil.computeInsidePart((KVector)new KVector(elklabel.getX(), elklabel.getY()), (KVector)new KVector(elklabel.getWidth(), elklabel.getHeight()), (KVector)new KVector(elkport.getWidth(), elkport.getHeight()), (double)0.0, (PortSide)portSide);
            }
            switch (portSide) {
                case EAST: 
                case WEST: {
                    llabel.getSize().x = insidePart;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    llabel.getSize().y = insidePart;
                }
            }
        }
        dummy.setProperty(LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL, (Double)elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL));
        dummy.setProperty(LayeredOptions.SPACING_LABEL_PORT_VERTICAL, (Double)elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_PORT_VERTICAL));
        dummy.setProperty(LayeredOptions.SPACING_LABEL_LABEL, (Double)elkgraph.getParent().getProperty(LayeredOptions.SPACING_LABEL_LABEL));
        lgraph.getLayerlessNodes().add(dummy);
        this.nodeAndPortMap.put((ElkGraphElement)elkport, dummy);
    }

    private int calculateNetFlow(ElkPort elkport) {
        boolean isInsideSelfLoop;
        boolean isSelfLoop;
        ElkNode elkgraph = elkport.getParent();
        boolean insideSelfLoopsEnabled = (Boolean)elkgraph.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE);
        int outputPortVote = 0;
        int inputPortVote = 0;
        for (ElkEdge outgoingEdge : elkport.getOutgoingEdges()) {
            isSelfLoop = outgoingEdge.isSelfloop();
            isInsideSelfLoop = isSelfLoop && insideSelfLoopsEnabled && (Boolean)outgoingEdge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)outgoingEdge.getTargets().get(0)));
            if (isSelfLoop && isInsideSelfLoop) {
                ++inputPortVote;
                continue;
            }
            if (isSelfLoop && !isInsideSelfLoop) {
                ++outputPortVote;
                continue;
            }
            if (targetNode.getParent() == elkgraph || targetNode == elkgraph) {
                ++inputPortVote;
                continue;
            }
            ++outputPortVote;
        }
        for (ElkEdge incomingEdge : elkport.getIncomingEdges()) {
            isSelfLoop = incomingEdge.isSelfloop();
            isInsideSelfLoop = isSelfLoop && insideSelfLoopsEnabled && (Boolean)incomingEdge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false;
            ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)incomingEdge.getSources().get(0)));
            if (isSelfLoop && isInsideSelfLoop) {
                ++outputPortVote;
                continue;
            }
            if (isSelfLoop && !isInsideSelfLoop) {
                ++inputPortVote;
                continue;
            }
            if (sourceNode.getParent() == elkgraph || sourceNode == elkgraph) {
                ++outputPortVote;
                continue;
            }
            ++inputPortVote;
        }
        return outputPortVote - inputPortVote;
    }

    private boolean isConnectedToExternalNodes(ElkPort elkport) {
        ElkNode parent = elkport.getParent();
        for (ElkEdge outEdge : elkport.getOutgoingEdges()) {
            ElkNode targetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)outEdge.getTargets().get(0)));
            if (ElkGraphUtil.isDescendant((ElkNode)targetNode, (ElkNode)parent)) continue;
            return true;
        }
        for (ElkEdge inEdge : elkport.getIncomingEdges()) {
            ElkNode sourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)inEdge.getSources().get(0)));
            if (ElkGraphUtil.isDescendant((ElkNode)sourceNode, (ElkNode)parent)) continue;
            return true;
        }
        return false;
    }

    private LNode transformNode(ElkNode elknode, LGraph lgraph) {
        LNode lnode = new LNode(lgraph);
        lnode.copyProperties((IPropertyHolder)elknode);
        lnode.setProperty(InternalProperties.ORIGIN, elknode);
        lnode.getSize().x = elknode.getWidth();
        lnode.getSize().y = elknode.getHeight();
        lnode.getPosition().x = elknode.getX();
        lnode.getPosition().y = elknode.getY();
        lgraph.getLayerlessNodes().add(lnode);
        this.nodeAndPortMap.put((ElkGraphElement)elknode, lnode);
        if (!elknode.getChildren().isEmpty() || ((Boolean)elknode.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_ACTIVATE)).booleanValue()) {
            lnode.setProperty(InternalProperties.COMPOUND_NODE, true);
        }
        Set graphProperties = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        PortConstraints portConstraints = (PortConstraints)lnode.getProperty(LayeredOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.UNDEFINED) {
            lnode.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        } else if (portConstraints != PortConstraints.FREE) {
            graphProperties.add(GraphProperties.NON_FREE_PORTS);
        }
        int portModelOrder = 0;
        Direction direction = (Direction)lgraph.getProperty(LayeredOptions.DIRECTION);
        for (ElkPort elkport : elknode.getPorts()) {
            if (this.needsModelOrder(elknode)) {
                elkport.setProperty(InternalProperties.MODEL_ORDER, (Object)portModelOrder++);
            }
            if (((Boolean)elkport.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue()) continue;
            this.transformPort(elkport, lnode, graphProperties, direction, portConstraints);
        }
        for (ElkLabel elklabel : elknode.getLabels()) {
            if (((Boolean)elklabel.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            lnode.getLabels().add(this.transformLabel(elklabel));
        }
        if (((Boolean)lnode.getProperty(LayeredOptions.COMMENT_BOX)).booleanValue()) {
            graphProperties.add(GraphProperties.COMMENTS);
        }
        if (((Boolean)lnode.getProperty(LayeredOptions.HYPERNODE)).booleanValue()) {
            graphProperties.add(GraphProperties.HYPERNODES);
            graphProperties.add(GraphProperties.HYPEREDGES);
            lnode.setProperty(LayeredOptions.PORT_CONSTRAINTS, PortConstraints.FREE);
        }
        return lnode;
    }

    private LPort transformPort(ElkPort elkport, LNode parentLNode, Set<GraphProperties> graphProperties, Direction layoutDirection, PortConstraints portConstraints) {
        LPort lport = new LPort();
        lport.copyProperties((IPropertyHolder)elkport);
        lport.setSide((PortSide)elkport.getProperty(LayeredOptions.PORT_SIDE));
        lport.setProperty(InternalProperties.ORIGIN, elkport);
        lport.setNode(parentLNode);
        KVector portSize = lport.getSize();
        portSize.x = elkport.getWidth();
        portSize.y = elkport.getHeight();
        KVector portPos = lport.getPosition();
        portPos.x = elkport.getX();
        portPos.y = elkport.getY();
        this.nodeAndPortMap.put((ElkGraphElement)elkport, lport);
        boolean connectionsToDescendants = elkport.getOutgoingEdges().stream().flatMap(edge -> edge.getTargets().stream()).map(ElkGraphUtil::connectableShapeToNode).anyMatch(targetNode -> ElkGraphUtil.isDescendant((ElkNode)targetNode, (ElkNode)elkport.getParent()));
        if (!connectionsToDescendants) {
            connectionsToDescendants = elkport.getIncomingEdges().stream().flatMap(edge -> edge.getSources().stream()).map(ElkGraphUtil::connectableShapeToNode).anyMatch(sourceNode -> ElkGraphUtil.isDescendant((ElkNode)sourceNode, (ElkNode)elkport.getParent()));
        }
        if (!connectionsToDescendants) {
            connectionsToDescendants = elkport.getOutgoingEdges().stream().anyMatch(edge -> edge.isSelfloop() && (Boolean)edge.getProperty(LayeredOptions.INSIDE_SELF_LOOPS_YO) != false);
        }
        lport.setProperty(InternalProperties.INSIDE_CONNECTIONS, connectionsToDescendants);
        LGraphUtil.initializePort(lport, portConstraints, layoutDirection, (KVector)elkport.getProperty(LayeredOptions.PORT_ANCHOR));
        for (ElkLabel elklabel : elkport.getLabels()) {
            if (((Boolean)elklabel.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            lport.getLabels().add(this.transformLabel(elklabel));
        }
        switch (layoutDirection) {
            case RIGHT: 
            case LEFT: {
                if (lport.getSide() != PortSide.NORTH && lport.getSide() != PortSide.SOUTH) break;
                graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
                break;
            }
            case DOWN: 
            case UP: {
                if (lport.getSide() != PortSide.EAST && lport.getSide() != PortSide.WEST) break;
                graphProperties.add(GraphProperties.NORTH_SOUTH_PORTS);
            }
        }
        return lport;
    }

    private LEdge transformEdge(ElkEdge elkedge, ElkNode elkparent, LGraph lgraph) {
        boolean bendPointsRequired;
        PortType portType;
        this.checkEdgeValidity(elkedge);
        ElkConnectableShape elkSourceShape = (ElkConnectableShape)elkedge.getSources().get(0);
        ElkConnectableShape elkTargetShape = (ElkConnectableShape)elkedge.getTargets().get(0);
        ElkNode elkSourceNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkSourceShape);
        ElkNode elkTargetNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)elkTargetShape);
        ElkEdgeSection edgeSection = elkedge.getSections().isEmpty() ? null : (ElkEdgeSection)elkedge.getSections().get(0);
        LNode sourceLNode = (LNode)this.nodeAndPortMap.get(elkSourceNode);
        LNode targetLNode = (LNode)this.nodeAndPortMap.get(elkTargetNode);
        LPort sourceLPort = null;
        LPort targetLPort = null;
        if (elkSourceShape instanceof ElkPort) {
            LGraphElement sourceElem = this.nodeAndPortMap.get(elkSourceShape);
            if (sourceElem instanceof LPort) {
                sourceLPort = (LPort)sourceElem;
            } else if (sourceElem instanceof LNode) {
                sourceLNode = (LNode)sourceElem;
                sourceLPort = sourceLNode.getPorts().get(0);
            }
        }
        if (elkTargetShape instanceof ElkPort) {
            LGraphElement targetElem = this.nodeAndPortMap.get(elkTargetShape);
            if (targetElem instanceof LPort) {
                targetLPort = (LPort)targetElem;
            } else if (targetElem instanceof LNode) {
                targetLNode = (LNode)targetElem;
                targetLPort = targetLNode.getPorts().get(0);
            }
        }
        if (sourceLNode == null || targetLNode == null) {
            throw new UnsupportedGraphException("The source or the target of edge " + String.valueOf(elkedge) + " could not be found. This usually happens when an edge connects a node laid out by ELK Layered to a node in another level of hierarchy laid out by either another instance of ELK Layered or another layout algorithm alltogether. The former can be solved by setting the hierarchyHandling option to INCLUDE_CHILDREN.");
        }
        LEdge ledge = new LEdge();
        ledge.copyProperties((IPropertyHolder)elkedge);
        ledge.setProperty(InternalProperties.ORIGIN, elkedge);
        ledge.setProperty(LayeredOptions.JUNCTION_POINTS, null);
        Set graphProperties = (Set)lgraph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (sourceLNode == targetLNode) {
            graphProperties.add(GraphProperties.SELF_LOOPS);
        }
        if (sourceLPort == null) {
            portType = PortType.OUTPUT;
            KVector sourcePoint = null;
            if (edgeSection != null && ((PortConstraints)sourceLNode.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                sourcePoint = new KVector(edgeSection.getStartX(), edgeSection.getStartY());
                ElkUtil.toAbsolute((KVector)sourcePoint, (ElkNode)elkedge.getContainingNode());
                ElkUtil.toRelative((KVector)sourcePoint, (ElkNode)elkparent);
                if (ElkGraphUtil.isDescendant((ElkNode)elkTargetNode, (ElkNode)elkSourceNode)) {
                    portType = PortType.INPUT;
                    sourcePoint.add(sourceLNode.getPosition());
                }
            }
            sourceLPort = LGraphUtil.createPort(sourceLNode, sourcePoint, portType, lgraph);
        }
        if (targetLPort == null) {
            portType = PortType.INPUT;
            Iterator targetPoint = null;
            if (edgeSection != null && ((PortConstraints)targetLNode.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isSideFixed()) {
                targetPoint = new KVector(edgeSection.getEndX(), edgeSection.getEndY());
                ElkUtil.toAbsolute((KVector)targetPoint, (ElkNode)elkedge.getContainingNode());
                ElkUtil.toRelative((KVector)targetPoint, (ElkNode)elkparent);
            }
            targetLPort = LGraphUtil.createPort(targetLNode, targetPoint, portType, targetLNode.getGraph());
        }
        ledge.setSource(sourceLPort);
        ledge.setTarget(targetLPort);
        if (sourceLPort.getIncomingEdges().size() > 1 || sourceLPort.getOutgoingEdges().size() > 1 || targetLPort.getIncomingEdges().size() > 1 || targetLPort.getOutgoingEdges().size() > 1) {
            graphProperties.add(GraphProperties.HYPEREDGES);
        }
        for (ElkLabel elklabel : elkedge.getLabels()) {
            if (((Boolean)elklabel.getProperty(LayeredOptions.NO_LAYOUT)).booleanValue() || Strings.isNullOrEmpty((String)elklabel.getText())) continue;
            LLabel llabel = this.transformLabel(elklabel);
            ledge.getLabels().add(llabel);
            switch ((EdgeLabelPlacement)llabel.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT)) {
                case HEAD: 
                case TAIL: {
                    graphProperties.add(GraphProperties.END_LABELS);
                    break;
                }
                case CENTER: {
                    graphProperties.add(GraphProperties.CENTER_LABELS);
                    llabel.setProperty(LayeredOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.CENTER);
                }
            }
        }
        CrossingMinimizationStrategy crossMinStrat = (CrossingMinimizationStrategy)((Object)lgraph.getProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY));
        NodePlacementStrategy nodePlaceStrat = (NodePlacementStrategy)((Object)lgraph.getProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY));
        boolean bl = bendPointsRequired = crossMinStrat == CrossingMinimizationStrategy.INTERACTIVE || nodePlaceStrat == NodePlacementStrategy.INTERACTIVE;
        if (edgeSection != null && !edgeSection.getBendPoints().isEmpty() && bendPointsRequired) {
            KVectorChain originalBendpoints = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
            KVectorChain importedBendpoints = new KVectorChain();
            for (KVector point : originalBendpoints) {
                importedBendpoints.add((Object)new KVector(point));
            }
            ledge.setProperty(InternalProperties.ORIGINAL_BENDPOINTS, importedBendpoints);
        }
        return ledge;
    }

    private void checkEdgeValidity(ElkEdge edge) {
        if (edge.getSources().isEmpty()) {
            throw new UnsupportedGraphException("Edges must have a source.");
        }
        if (edge.getTargets().isEmpty()) {
            throw new UnsupportedGraphException("Edges must have a target.");
        }
        if (edge.isHyperedge()) {
            throw new UnsupportedGraphException("Hyperedges are not supported.");
        }
    }

    private LLabel transformLabel(ElkLabel elklabel) {
        LLabel newLabel = new LLabel(elklabel.getText());
        newLabel.copyProperties((IPropertyHolder)elklabel);
        newLabel.setProperty(InternalProperties.ORIGIN, elklabel);
        newLabel.getSize().x = elklabel.getWidth();
        newLabel.getSize().y = elklabel.getHeight();
        newLabel.getPosition().x = elklabel.getX();
        newLabel.getPosition().y = elklabel.getY();
        return newLabel;
    }
}

