/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.libavoid;

import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.elk.alg.common.NodeMicroLayout;
import org.eclipse.elk.alg.common.nodespacing.NodeDimensionCalculation;
import org.eclipse.elk.alg.libavoid.LibavoidServerCommunicator;
import org.eclipse.elk.alg.libavoid.options.LibavoidOptions;
import org.eclipse.elk.alg.libavoid.server.LibavoidServer;
import org.eclipse.elk.alg.libavoid.server.LibavoidServerPool;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.adapters.ElkGraphAdapters;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;

public class LibavoidLayoutProvider
extends AbstractLayoutProvider {
    private final ConcurrentHashMap<ElkNode, LibavoidServer> parentNodeToServer = new ConcurrentHashMap();
    private LibavoidServerCommunicator comm = new LibavoidServerCommunicator();

    public void layout(ElkNode parentNode, IElkProgressMonitor progressMonitor) {
        if (!((Boolean)parentNode.getProperty(LibavoidOptions.OMIT_NODE_MICRO_LAYOUT)).booleanValue()) {
            NodeMicroLayout.forGraph((ElkNode)parentNode).execute();
        }
        this.prepareGraph(parentNode);
        ElkGraphAdapters.ElkGraphAdapter adapter = ElkGraphAdapters.adapt((ElkNode)parentNode);
        NodeDimensionCalculation.sortPortLists((GraphAdapters.GraphAdapter)adapter);
        NodeDimensionCalculation.calculateNodeMargins((GraphAdapters.GraphAdapter)adapter);
        LibavoidServer lvServer = LibavoidServerPool.INSTANCE.fetch();
        this.parentNodeToServer.putIfAbsent(parentNode, lvServer);
        this.comm.requestLayout(parentNode, progressMonitor, lvServer);
        this.parentNodeToServer.remove(parentNode);
        LibavoidServerPool.INSTANCE.release(lvServer);
    }

    private void prepareGraph(ElkNode parentNode) {
        Direction direction = (Direction)parentNode.getProperty(CoreOptions.DIRECTION);
        for (ElkNode node : parentNode.getChildren()) {
            for (ElkPort port : node.getPorts()) {
                PortSide side = (PortSide)port.getProperty(CoreOptions.PORT_SIDE);
                if (side != PortSide.UNDEFINED) continue;
                side = ElkUtil.calcPortSide((ElkPort)port, (Direction)direction);
                port.setProperty(CoreOptions.PORT_SIDE, (Object)side);
            }
        }
    }

    public boolean cancelLayouting(ElkNode parentNode) {
        LibavoidServer responsibleServer = this.parentNodeToServer.get(parentNode);
        if (responsibleServer != null) {
            this.parentNodeToServer.remove(parentNode);
            responsibleServer.cancelProcess();
            return true;
        }
        return false;
    }
}

