/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.intermediate.wrapping.GraphStats;
import org.eclipse.elk.alg.layered.intermediate.wrapping.ICutIndexCalculator;

public class ARDCutIndexHeuristic
implements ICutIndexCalculator {
    @Override
    public List<Integer> getCutIndexes(LGraph graph, GraphStats gs) {
        int rows = ARDCutIndexHeuristic.getChunkCount(gs);
        ArrayList cuts = Lists.newArrayList();
        double step = (double)gs.longestPath / (double)rows;
        int idx = 1;
        while (idx < rows) {
            cuts.add((int)Math.round((double)idx * step));
            ++idx;
        }
        return cuts;
    }

    public static int getChunkCount(GraphStats gs) {
        double rowsd = Math.sqrt(gs.getSumWidth() / (gs.dar * gs.getMaxHeight()));
        int rows = (int)Math.round(rowsd);
        rows = Math.min(rows, gs.longestPath);
        return rows;
    }

    @Override
    public boolean guaranteeValid() {
        return false;
    }
}

