/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.options;

import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.p1cycles.BFSNodeOrderCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.DFSNodeOrderCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.DepthFirstCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.GreedyCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.GreedyModelOrderCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.InteractiveCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.ModelOrderCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.SCCNodeTypeCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.SCConnectivity;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;

public enum CycleBreakingStrategy implements ILayoutPhaseFactory<LayeredPhases, LGraph>
{
    GREEDY,
    DEPTH_FIRST,
    INTERACTIVE,
    MODEL_ORDER,
    GREEDY_MODEL_ORDER,
    SCC_CONNECTIVITY,
    SCC_NODE_TYPE,
    DFS_NODE_ORDER,
    BFS_NODE_ORDER;


    public ILayoutPhase<LayeredPhases, LGraph> create() {
        switch (this) {
            case GREEDY: {
                return new GreedyCycleBreaker();
            }
            case DEPTH_FIRST: {
                return new DepthFirstCycleBreaker();
            }
            case INTERACTIVE: {
                return new InteractiveCycleBreaker();
            }
            case MODEL_ORDER: {
                return new ModelOrderCycleBreaker();
            }
            case GREEDY_MODEL_ORDER: {
                return new GreedyModelOrderCycleBreaker();
            }
            case SCC_CONNECTIVITY: {
                return new SCConnectivity();
            }
            case SCC_NODE_TYPE: {
                return new SCCNodeTypeCycleBreaker();
            }
            case DFS_NODE_ORDER: {
                return new DFSNodeOrderCycleBreaker();
            }
            case BFS_NODE_ORDER: {
                return new BFSNodeOrderCycleBreaker();
            }
        }
        throw new IllegalArgumentException("No implementation is available for the cycle breaker " + this.toString());
    }
}

