/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.GroupOrderStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p1cycles.GreedyCycleBreaker;
import org.eclipse.elk.alg.layered.p1cycles.GroupModelOrderCalculator;

public final class GreedyModelOrderCycleBreaker
extends GreedyCycleBreaker {
    @Override
    protected LNode chooseNodeWithMaxOutflow(List<LNode> nodes) {
        LNode returnNode = null;
        int minimumModelOrder = Integer.MAX_VALUE;
        int offset = Math.max(this.layeredGraph.getLayerlessNodes().size(), (Integer)this.layeredGraph.getProperty(InternalProperties.MAX_MODEL_ORDER_NODES));
        int bigOffset = offset * (Integer)this.layeredGraph.getProperty(InternalProperties.CB_NUM_MODEL_ORDER_GROUPS);
        GroupModelOrderCalculator moCalculator = new GroupModelOrderCalculator();
        boolean enforceGroupModelOrder = this.layeredGraph.getProperty(LayeredOptions.CONSIDER_MODEL_ORDER_GROUP_MODEL_ORDER_CB_GROUP_ORDER_STRATEGY) == GroupOrderStrategy.ENFORCED;
        for (LNode node : nodes) {
            int modelOrder;
            if (!node.hasProperty(InternalProperties.MODEL_ORDER)) continue;
            int n = modelOrder = enforceGroupModelOrder ? moCalculator.computeConstraintGroupModelOrder(node, bigOffset, offset) : moCalculator.computeConstraintModelOrder(node, offset);
            if (minimumModelOrder <= modelOrder) continue;
            minimumModelOrder = modelOrder;
            returnNode = node;
        }
        if (returnNode == null) {
            return super.chooseNodeWithMaxOutflow(nodes);
        }
        return returnNode;
    }
}

