/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.LayerConstraint;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.UnsupportedConfigurationException;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LayerConstraintProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        Object node;
        int n;
        LNode[] lNodeArray;
        LNode[] nodes;
        monitor.begin("Layer constraint application", 1.0f);
        List<Layer> layers = layeredGraph.getLayers();
        if (layers.isEmpty()) {
            monitor.done();
            return;
        }
        Layer firstLayer = layers.get(0);
        Layer lastLayer = layers.get(layers.size() - 1);
        Layer veryFirstLayer = new Layer(layeredGraph);
        Layer veryLastLayer = new Layer(layeredGraph);
        for (Layer layer : layers) {
            lNodeArray = nodes = layer.getNodes().toArray(new LNode[layer.getNodes().size()]);
            n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                node = lNodeArray[n2];
                LayerConstraint constraint = (LayerConstraint)((Object)node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT));
                switch (constraint) {
                    case FIRST: {
                        ((LNode)((Object)node)).setLayer(firstLayer);
                        this.assertNoIncoming((LNode)((Object)node), false);
                        break;
                    }
                    case FIRST_SEPARATE: {
                        ((LNode)((Object)node)).setLayer(veryFirstLayer);
                        this.assertNoIncoming((LNode)((Object)node), true);
                        break;
                    }
                    case LAST: {
                        ((LNode)((Object)node)).setLayer(lastLayer);
                        this.assertNoOutgoing((LNode)((Object)node), false);
                        break;
                    }
                    case LAST_SEPARATE: {
                        ((LNode)((Object)node)).setLayer(veryLastLayer);
                        this.assertNoOutgoing((LNode)((Object)node), false);
                    }
                }
                ++n2;
            }
        }
        if (layers.size() >= 2) {
            boolean moveAllowed = true;
            Layer sndFirstLayer = layers.get(1);
            for (LNode node2 : firstLayer) {
                if (node2.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.NONE) {
                    moveAllowed = false;
                    break;
                }
                for (LEdge edge : node2.getOutgoingEdges()) {
                    if (edge.getTarget().getNode().getLayer() != sndFirstLayer) continue;
                    moveAllowed = false;
                    break;
                }
                if (!moveAllowed) break;
            }
            if (moveAllowed) {
                lNodeArray = nodes = firstLayer.getNodes().toArray(new LNode[firstLayer.getNodes().size()]);
                n = nodes.length;
                int edge = 0;
                while (edge < n) {
                    node = lNodeArray[edge];
                    ((LNode)((Object)node)).setLayer(sndFirstLayer);
                    ++edge;
                }
                layers.remove(firstLayer);
                firstLayer = sndFirstLayer;
            }
        }
        if (layers.size() >= 2) {
            boolean moveAllowed = true;
            Layer sndLastLayer = layers.get(layers.size() - 2);
            for (LNode node2 : lastLayer) {
                if (node2.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.NONE) {
                    moveAllowed = false;
                    break;
                }
                for (LEdge edge : node2.getIncomingEdges()) {
                    if (edge.getSource().getNode().getLayer() != sndLastLayer) continue;
                    moveAllowed = false;
                    break;
                }
                if (!moveAllowed) break;
            }
            if (moveAllowed) {
                lNodeArray = nodes = lastLayer.getNodes().toArray(new LNode[lastLayer.getNodes().size()]);
                int n3 = nodes.length;
                int n4 = 0;
                while (n4 < n3) {
                    node = lNodeArray[n4];
                    ((LNode)((Object)node)).setLayer(sndLastLayer);
                    ++n4;
                }
                layers.remove(lastLayer);
                lastLayer = sndLastLayer;
            }
        }
        if (layers.size() == 1 && layers.get(0).getNodes().isEmpty()) {
            layers.remove(0);
        }
        if (!veryFirstLayer.getNodes().isEmpty()) {
            layers.add(0, veryFirstLayer);
        }
        if (!veryLastLayer.getNodes().isEmpty()) {
            layers.add(veryLastLayer);
        }
        monitor.done();
    }

    private void assertNoIncoming(LNode node, boolean strict) {
        for (LPort port : node.getPorts()) {
            if (strict) {
                if (port.getIncomingEdges().isEmpty()) continue;
                throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to FIRST or FIRST_SEPARATE, but has " + "at least one incoming edge. Connections between nodes with these " + "layer constraints are not supported.");
            }
            for (LEdge incoming : port.getIncomingEdges()) {
                if (incoming.getSource().getNode().getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.FIRST_SEPARATE) continue;
                throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to FIRST or FIRST_SEPARATE, but has " + "at least one incoming edge. Connections between nodes with these " + "layer constraints are not supported.");
            }
        }
    }

    private void assertNoOutgoing(LNode node, boolean strict) {
        for (LPort port : node.getPorts()) {
            if (strict) {
                if (port.getOutgoingEdges().isEmpty()) continue;
                throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to LAST or LAST_SEPARATE, but has " + "at least one outgoing edge. Connections between nodes with these " + "layer constraints are not supported.");
            }
            for (LEdge outgoing : port.getOutgoingEdges()) {
                if (outgoing.getTarget().getNode().getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.LAST_SEPARATE) continue;
                throw new UnsupportedConfigurationException("Node '" + node.getDesignation() + "' has its layer constraint set to LAST or LAST_SEPARATE, but has " + "at least one outgoing edge. Connections between nodes with these " + "layer constraints are not supported.");
            }
        }
    }
}

