/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.debug.views.execution;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.core.debug.views.execution.ClearExecutionsAction;
import org.eclipse.elk.core.debug.views.execution.Execution;
import org.eclipse.elk.core.debug.views.execution.ExecutionContentProvider;
import org.eclipse.elk.core.debug.views.execution.ExecutionLabelProvider;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ExecutionView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.elk.debug.executionView";
    private TreeViewer viewer;
    private List<Execution> executions = new ArrayList<Execution>();

    public static void addExecution(final IElkProgressMonitor progressMonitor) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ExecutionView activeView = ExecutionView.findView();
                if (progressMonitor != null && activeView != null) {
                    activeView.executions.add(Execution.fromProgressMonitor(progressMonitor));
                    activeView.viewer.refresh();
                }
            }
        });
    }

    public void clearExecutions() {
        this.executions.clear();
        this.viewer.refresh();
    }

    private static ExecutionView findView() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart viewPart = activePage.findView(VIEW_ID);
        if (viewPart instanceof ExecutionView) {
            return (ExecutionView)viewPart;
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new ClearExecutionsAction(this));
        this.viewer = new TreeViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ExecutionContentProvider());
        this.viewer.setInput(this.executions);
        this.viewer.getTree().setHeaderVisible(true);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.viewer, 0);
        nameColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionLabelProvider(ExecutionLabelProvider.DisplayMode.NAME)));
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(500);
        TreeViewerColumn timeColumn = new TreeViewerColumn(this.viewer, 0);
        timeColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionLabelProvider(ExecutionLabelProvider.DisplayMode.TIME_TOTAL)));
        timeColumn.getColumn().setAlignment(131072);
        timeColumn.getColumn().setText("Time [ms]");
        timeColumn.getColumn().setWidth(100);
        TreeViewerColumn localTimeColumn = new TreeViewerColumn(this.viewer, 0);
        localTimeColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ExecutionLabelProvider(ExecutionLabelProvider.DisplayMode.TIME_LOCAL)));
        localTimeColumn.getColumn().setAlignment(131072);
        localTimeColumn.getColumn().setText("Local Time [ms]");
        localTimeColumn.getColumn().setWidth(100);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

