/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.views;

import org.eclipse.elk.core.ui.views.LayoutViewPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class MultipleOptionsCellEditor
extends DialogCellEditor {
    private String[] items;

    public MultipleOptionsCellEditor(Composite parent, String[] items) {
        super(parent);
        this.items = items;
    }

    protected Control createContents(final Composite cell) {
        Control label = super.createContents(cell);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LayoutViewPart layoutView;
                Object newValue = MultipleOptionsCellEditor.this.openDialogBox((Control)cell);
                if (newValue != null) {
                    MultipleOptionsCellEditor.this.markDirty();
                    MultipleOptionsCellEditor.this.doSetValue(newValue);
                    MultipleOptionsCellEditor.this.fireApplyEditorValue();
                }
                if ((layoutView = LayoutViewPart.findView()) != null) {
                    layoutView.setFocus();
                }
            }
        });
        return label;
    }

    protected void updateContents(Object value) {
        if (value instanceof String[]) {
            String[] strArray = (String[])value;
            if (strArray.length == 0) {
                super.updateContents((Object)"");
            } else {
                StringBuilder text = new StringBuilder();
                String[] stringArray = strArray;
                int n = strArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    text.append(", " + item);
                    ++n2;
                }
                super.updateContents((Object)text.substring(2));
            }
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ListSelectionDialog dialog = new ListSelectionDialog(cellEditorWindow.getShell(), (Object)this.items, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(), null);
        dialog.setInitialSelections((Object[])((String[])this.getValue()));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            String[] stringResult = new String[result.length];
            int i = 0;
            while (i < result.length) {
                stringResult[i] = (String)result[i];
                ++i;
            }
            return stringResult;
        }
        return new String[0];
    }
}

