/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.p5edges.PolylineEdgeRouter;
import org.eclipse.elk.alg.layered.p5edges.splines.NubSpline;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public final class SplineEdgeRouter
implements ILayoutPhase {
    private static final double MAX_VERTICAL_DIFF_FOR_STRAIGHT = 0.2;
    private double hEdgeSpacing = 3.0;
    private static final double ONE_HALF = 0.5;
    private static final int DIMENSION = 3;
    private static final double NODE_TO_VERTICAL_SEGMENT_GAP = 10.0;
    private static final double NODE_TO_STRAIGHTENING_CP_GAP = 5.0;
    private static final double RELEVANT_POS_OUTER_RATE = 0.9;
    private static final double RELEVANT_POS_MID_RATE = 0.09999999999999998;
    private static final IntermediateProcessingConfiguration SELF_LOOP_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase1(IntermediateProcessorStrategy.SPLINE_SELF_LOOP_PREPROCESSOR).addBeforePhase4(IntermediateProcessorStrategy.SPLINE_SELF_LOOP_POSITIONER).addBeforePhase4(IntermediateProcessorStrategy.SPLINE_SELF_LOOP_ROUTER);
    private static final IntermediateProcessingConfiguration CENTER_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase2(IntermediateProcessorStrategy.LABEL_DUMMY_INSERTER).addBeforePhase3(IntermediateProcessorStrategy.LABEL_DUMMY_SWITCHER).addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.LABEL_DUMMY_REMOVER);
    private static final IntermediateProcessingConfiguration INVERTED_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.INVERTED_PORT_PROCESSOR);
    private static final IntermediateProcessingConfiguration NORTH_SOUTH_PORT_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_PREPROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.NORTH_SOUTH_PORT_POSTPROCESSOR);
    private static final IntermediateProcessingConfiguration END_EDGE_LABEL_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase4(IntermediateProcessorStrategy.LABEL_SIDE_SELECTOR).addAfterPhase5(IntermediateProcessorStrategy.END_LABEL_PROCESSOR);

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        Layer rightLayer;
        monitor.begin("Spline edge routing", 1.0f);
        double hNodeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
        this.hEdgeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_BETWEEN_LAYERS);
        boolean sloppyRouting = (Boolean)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_SLOPPY_SPLINE_ROUTING);
        double sloppyLayerSpacingFactor = (Double)layeredGraph.getProperty(LayeredOptions.EDGE_ROUTING_SLOPPY_SPLINE_LAYER_SPACING);
        double xpos = 0.0;
        Iterator<Layer> layerIterator = layeredGraph.iterator();
        Layer leftLayer = null;
        HashMap successingEdge = Maps.newHashMap();
        ArrayList startEdges = Lists.newArrayList();
        boolean externalLeftLayer = true;
        boolean externalRightLayer = true;
        do {
            rightLayer = layerIterator.hasNext() ? layerIterator.next() : null;
            ArrayList hyperEdges = Lists.newArrayList();
            ArrayList edgesRemaining = Lists.newArrayList();
            LinkedHashSet leftPorts = Sets.newLinkedHashSet();
            LinkedHashSet rightPorts = Sets.newLinkedHashSet();
            LinkedHashSet selfLoops = Sets.newLinkedHashSet();
            this.fillMappings((Pair<Layer, Layer>)Pair.of(leftLayer, (Object)rightLayer), (Pair<Set<LPort>, Set<LPort>>)Pair.of((Object)leftPorts, (Object)rightPorts), edgesRemaining, successingEdge, startEdges, selfLoops);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.LEFT, true, edgesRemaining, hyperEdges);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.LEFT, false, edgesRemaining, hyperEdges);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.RIGHT, true, edgesRemaining, hyperEdges);
            this.createHyperEdges(leftPorts, rightPorts, SideToProcess.RIGHT, false, edgesRemaining, hyperEdges);
            this.createHyperEdges(edgesRemaining, leftPorts, rightPorts, hyperEdges);
            ListIterator sourceIter = hyperEdges.listIterator();
            while (sourceIter.hasNext()) {
                SplineHyperEdge hyperEdge1 = (SplineHyperEdge)sourceIter.next();
                ListIterator targetIter = hyperEdges.listIterator(sourceIter.nextIndex());
                while (targetIter.hasNext()) {
                    SplineHyperEdge hyperEdge2 = (SplineHyperEdge)targetIter.next();
                    this.createDependency(hyperEdge1, hyperEdge2);
                }
            }
            SplineEdgeRouter.breakCycles(hyperEdges, (Random)layeredGraph.getProperty(InternalProperties.RANDOM));
            SplineEdgeRouter.topologicalNumbering(hyperEdges);
            double rightLayersPosition = xpos;
            if (rightLayer != null) {
                externalRightLayer = Iterables.all(rightLayer.getNodes(), PolylineEdgeRouter.PRED_EXTERNAL_WEST_OR_EAST_PORT);
                if (sloppyRouting) {
                    double maxVertDiff = 0.0;
                    for (LNode node : rightLayer) {
                        double maxCurrInputYDiff = 0.0;
                        for (LEdge incomingEdge : node.getIncomingEdges()) {
                            double sourcePos = incomingEdge.getSource().getAbsoluteAnchor().y;
                            double targetPos = incomingEdge.getTarget().getAbsoluteAnchor().y;
                            maxCurrInputYDiff = Math.max(maxCurrInputYDiff, Math.abs(targetPos - sourcePos));
                        }
                        maxVertDiff = Math.max(maxVertDiff, maxCurrInputYDiff);
                    }
                    double layerSpacing = sloppyLayerSpacingFactor * (this.hEdgeSpacing / hNodeSpacing) * maxVertDiff;
                    if (layerSpacing < hNodeSpacing && !externalLeftLayer && !externalRightLayer) {
                        layerSpacing = hNodeSpacing;
                    }
                    rightLayersPosition += layerSpacing;
                } else {
                    rightLayersPosition += 10.0;
                    int maxRank = -1;
                    for (SplineHyperEdge edge : hyperEdges) {
                        maxRank = Math.max(maxRank, edge.rank);
                    }
                    if (++maxRank > 0) {
                        double increment = (double)(maxRank + 1) * this.hEdgeSpacing;
                        if (increment < hNodeSpacing && !externalLeftLayer && !externalRightLayer) {
                            increment = hNodeSpacing;
                        }
                        rightLayersPosition += increment;
                    } else if (!(externalLeftLayer || externalRightLayer || this.layerOnlyContainsDummies(leftLayer) || this.layerOnlyContainsDummies(rightLayer))) {
                        rightLayersPosition += hNodeSpacing;
                    }
                }
                LGraphUtil.placeNodesHorizontally(rightLayer, rightLayersPosition);
            }
            for (LEdge selfLoop : selfLoops) {
                KVector offset = selfLoop.getSource().getNode().getPosition();
                selfLoop.getBendPoints().offset(offset);
                for (LLabel label : selfLoop.getLabels()) {
                    label.getPosition().add(offset);
                }
            }
            for (SplineHyperEdge edge : hyperEdges) {
                if (edge.isStraight) {
                    this.calculateNUBSBendPointStraight(edge, xpos);
                    continue;
                }
                this.calculateNUBSBendPoints(edge, xpos, rightLayersPosition, sloppyRouting);
            }
            if (rightLayer != null) {
                xpos = rightLayersPosition + rightLayer.getSize().x;
                if (!sloppyRouting) {
                    xpos += 10.0;
                }
            } else {
                int maxRank = -1;
                for (SplineHyperEdge edge : hyperEdges) {
                    maxRank = Math.max(maxRank, edge.rank);
                }
                if (maxRank >= 0) {
                    xpos += (double)(maxRank + 2) * this.hEdgeSpacing;
                }
            }
            leftLayer = rightLayer;
            externalLeftLayer = externalRightLayer;
        } while (rightLayer != null);
        for (LEdge edge : startEdges) {
            this.calculateBezierBendPoints(edge, successingEdge, sloppyRouting);
        }
        layeredGraph.getSize().x = xpos;
        monitor.done();
    }

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.createEmpty();
        Set graphProperties = (Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES);
        if (graphProperties.contains((Object)GraphProperties.SELF_LOOPS)) {
            configuration.addAll(SELF_LOOP_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.CENTER_LABELS)) {
            configuration.addAll(CENTER_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        if (graphProperties.contains((Object)GraphProperties.NON_FREE_PORTS) || ((Boolean)graph.getProperty(LayeredOptions.FEEDBACK_EDGES)).booleanValue()) {
            configuration.addAll(INVERTED_PORT_PROCESSING_ADDITIONS);
            if (graphProperties.contains((Object)GraphProperties.NORTH_SOUTH_PORTS)) {
                configuration.addAll(NORTH_SOUTH_PORT_PROCESSING_ADDITIONS);
            }
        }
        if (graphProperties.contains((Object)GraphProperties.END_LABELS)) {
            configuration.addAll(END_EDGE_LABEL_PROCESSING_ADDITIONS);
        }
        return configuration;
    }

    private static boolean isStraight(double firstY, double secondY) {
        return Math.abs(firstY - secondY) < 0.2;
    }

    private void fillMappings(Pair<Layer, Layer> leftRightLayer, Pair<Set<LPort>, Set<LPort>> leftRightPorts, List<LEdge> allEdges, Map<LEdge, LEdge> succeedingEdge, List<LEdge> startingEdges, Set<LEdge> selfLoops) {
        LPort targetPort;
        Layer targetLayer;
        Layer leftLayer = (Layer)leftRightLayer.getFirst();
        Layer rightLayer = (Layer)leftRightLayer.getSecond();
        Set leftPorts = (Set)leftRightPorts.getFirst();
        Set rightPorts = (Set)leftRightPorts.getSecond();
        if (leftLayer != null) {
            for (LNode node : leftLayer.getNodes()) {
                for (LPort sourcePort : node.getPorts(PortSide.EAST)) {
                    leftPorts.add(sourcePort);
                    for (LEdge edge : sourcePort.getOutgoingEdges()) {
                        if (edge.isSelfLoop()) continue;
                        allEdges.add(edge);
                        this.findAndAddSuccessor(edge, succeedingEdge);
                        if (this.isQualifiedAsStartingNode(edge.getSource().getNode())) {
                            startingEdges.add(edge);
                        }
                        if ((targetLayer = (targetPort = edge.getTarget()).getNode().getLayer()).equals(rightLayer)) {
                            rightPorts.add(targetPort);
                            continue;
                        }
                        if (targetLayer.equals(leftLayer)) {
                            leftPorts.add(targetPort);
                            continue;
                        }
                        allEdges.remove((Object)edge);
                    }
                }
            }
        }
        if (rightLayer != null) {
            for (LNode node : rightLayer.getNodes()) {
                for (LPort port : node.getPorts()) {
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (!edge.isSelfLoop()) continue;
                        selfLoops.add(edge);
                    }
                }
                for (LPort sourcePort : node.getPorts(PortSide.WEST)) {
                    rightPorts.add(sourcePort);
                    for (LEdge edge : sourcePort.getOutgoingEdges()) {
                        if (edge.isSelfLoop()) continue;
                        allEdges.add(edge);
                        this.findAndAddSuccessor(edge, succeedingEdge);
                        if (this.isQualifiedAsStartingNode(edge.getSource().getNode())) {
                            startingEdges.add(edge);
                        }
                        if ((targetLayer = (targetPort = edge.getTarget()).getNode().getLayer()).equals(rightLayer)) {
                            rightPorts.add(targetPort);
                            continue;
                        }
                        if (targetLayer.equals(leftLayer)) {
                            leftPorts.add(targetPort);
                            continue;
                        }
                        allEdges.remove((Object)edge);
                    }
                }
            }
        }
    }

    private void findAndAddSuccessor(LEdge edge, Map<LEdge, LEdge> succeedingEdge) {
        LNode targetNode = edge.getTarget().getNode();
        if (this.isNormalNode(targetNode)) {
            return;
        }
        Iterator<LEdge> iter = targetNode.getOutgoingEdges().iterator();
        if (iter.hasNext()) {
            succeedingEdge.put(edge, iter.next());
        }
    }

    private void createHyperEdges(List<LEdge> edges, Set<LPort> leftPorts, Set<LPort> rightPorts, List<SplineHyperEdge> hyperEdges) {
        for (LEdge edge : edges) {
            SideToProcess targetSide;
            SideToProcess sourceSide;
            LPort sourcePort = edge.getSource();
            if (leftPorts.contains((Object)sourcePort)) {
                sourceSide = SideToProcess.LEFT;
            } else if (rightPorts.contains((Object)sourcePort)) {
                sourceSide = SideToProcess.RIGHT;
            } else {
                throw new IllegalArgumentException("Source port must be in one of the port sets.");
            }
            LPort targetPort = edge.getTarget();
            if (leftPorts.contains((Object)targetPort)) {
                targetSide = SideToProcess.LEFT;
            } else if (rightPorts.contains((Object)targetPort)) {
                targetSide = SideToProcess.RIGHT;
            } else {
                throw new IllegalArgumentException("Target port must be in one of the port sets.");
            }
            hyperEdges.add(new SplineHyperEdge(edge, sourceSide, targetSide));
        }
    }

    private void createHyperEdges(Set<LPort> leftPorts, Set<LPort> rightPorts, SideToProcess sideToProcess, boolean reversed, List<LEdge> edgesRemaining, List<SplineHyperEdge> hyperEdges) {
        Set<LPort> portsToProcess = null;
        if (sideToProcess == SideToProcess.LEFT) {
            portsToProcess = leftPorts;
        } else if (sideToProcess == SideToProcess.RIGHT) {
            portsToProcess = rightPorts;
        } else assert (false) : "sideToProcess must be either LEFT or RIGHT.";
        for (LPort singlePort : portsToProcess) {
            double singlePortPosition = singlePort.getAbsoluteAnchor().y;
            HashSet upEdges = Sets.newHashSet();
            HashSet downEdges = Sets.newHashSet();
            for (LEdge edge : singlePort.getConnectedEdges()) {
                if ((Boolean)edge.getProperty(InternalProperties.REVERSED) != reversed || !edgesRemaining.contains((Object)edge)) continue;
                LPort targetPort = edge.getTarget() == singlePort ? edge.getSource() : edge.getTarget();
                double targetPortPosition = targetPort.getAbsoluteAnchor().y;
                if (SplineEdgeRouter.isStraight(targetPortPosition, singlePortPosition)) continue;
                if (targetPortPosition < singlePortPosition) {
                    if (leftPorts.contains((Object)targetPort)) {
                        upEdges.add(Pair.of((Object)((Object)SideToProcess.LEFT), (Object)((Object)edge)));
                        continue;
                    }
                    upEdges.add(Pair.of((Object)((Object)SideToProcess.RIGHT), (Object)((Object)edge)));
                    continue;
                }
                if (leftPorts.contains((Object)targetPort)) {
                    downEdges.add(Pair.of((Object)((Object)SideToProcess.LEFT), (Object)((Object)edge)));
                    continue;
                }
                downEdges.add(Pair.of((Object)((Object)SideToProcess.RIGHT), (Object)((Object)edge)));
            }
            if (upEdges.size() > 1) {
                hyperEdges.add(new SplineHyperEdge(singlePort, upEdges, sideToProcess));
                for (Pair pair : upEdges) {
                    edgesRemaining.remove(pair.getSecond());
                }
            }
            if (downEdges.size() <= 1) continue;
            hyperEdges.add(new SplineHyperEdge(singlePort, downEdges, sideToProcess));
            for (Pair pair : downEdges) {
                edgesRemaining.remove(pair.getSecond());
            }
        }
    }

    private void createDependency(SplineHyperEdge edge0, SplineHyperEdge edge1) {
        if (edge0.topYPos > edge1.bottomYPos || edge1.topYPos > edge0.bottomYPos) {
            return;
        }
        int edge0Counter = 0;
        int edge1Counter = 0;
        for (LPort port : edge0.rightPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge1.topYPos, edge1.bottomYPos)) continue;
            ++edge0Counter;
        }
        for (LPort port : edge0.leftPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge1.topYPos, edge1.bottomYPos)) continue;
            --edge0Counter;
        }
        for (LPort port : edge1.rightPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge0.topYPos, edge0.bottomYPos)) continue;
            ++edge1Counter;
        }
        for (LPort port : edge1.leftPorts) {
            if (!SplinesMath.isBetween(port.getAbsoluteAnchor().y, edge0.topYPos, edge0.bottomYPos)) continue;
            --edge1Counter;
        }
        if (edge0Counter < edge1Counter) {
            new Dependency(edge0, edge1, edge1Counter - edge0Counter);
        } else if (edge1Counter < edge0Counter) {
            new Dependency(edge1, edge0, edge0Counter - edge1Counter);
        } else {
            new Dependency(edge1, edge0, 0);
            new Dependency(edge0, edge1, 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void breakCycles(List<SplineHyperEdge> edges, Random random) {
        sources = Lists.newLinkedList();
        sinks = Lists.newLinkedList();
        nextMark = -1;
        for (SplineHyperEdge edge : edges) {
            SplineHyperEdge.access$9(edge, nextMark--);
            inweight = 0;
            outweight = 0;
            for (Dependency dependency : SplineHyperEdge.access$1(edge)) {
                outweight += Dependency.access$0(dependency);
            }
            for (Dependency dependency : SplineHyperEdge.access$2(edge)) {
                inweight += Dependency.access$0(dependency);
            }
            SplineHyperEdge.access$10(edge, inweight);
            SplineHyperEdge.access$11(edge, outweight);
            if (outweight == 0) {
                sinks.add(edge);
                continue;
            }
            if (inweight != 0) continue;
            sources.add(edge);
        }
        unprocessed = Sets.newLinkedHashSet(edges);
        markBase = edges.size();
        nextLeft = markBase + 1;
        nextRight = markBase - 1;
        maxEdges = Lists.newArrayList();
        ** GOTO lbl61
        {
            sink = (SplineHyperEdge)sinks.removeFirst();
            unprocessed.remove(sink);
            SplineHyperEdge.access$9(sink, nextRight--);
            SplineEdgeRouter.updateNeighbors(sink, sources, sinks);
            do {
                if (!sinks.isEmpty()) continue block3;
                while (!sources.isEmpty()) {
                    source = (SplineHyperEdge)sources.removeFirst();
                    unprocessed.remove(source);
                    SplineHyperEdge.access$9(source, nextLeft++);
                    SplineEdgeRouter.updateNeighbors(source, sources, sinks);
                }
                maxOutflow = -2147483648;
                for (SplineHyperEdge edge : unprocessed) {
                    outflow = SplineHyperEdge.access$12(edge) - SplineHyperEdge.access$13(edge);
                    if (outflow < maxOutflow) continue;
                    if (outflow > maxOutflow) {
                        maxEdges.clear();
                        maxOutflow = outflow;
                    }
                    maxEdges.add(edge);
                }
                if (maxEdges.isEmpty()) continue;
                maxEdge = (SplineHyperEdge)maxEdges.get(random.nextInt(maxEdges.size()));
                unprocessed.remove(maxEdge);
                SplineHyperEdge.access$9(maxEdge, nextLeft++);
                SplineEdgeRouter.updateNeighbors(maxEdge, sources, sinks);
                maxEdges.clear();
lbl61:
                // 3 sources

            } while (!unprocessed.isEmpty());
        }
        shiftBase = edges.size() + 1;
        for (SplineHyperEdge edge : edges) {
            if (SplineHyperEdge.access$14(edge) >= markBase) continue;
            v0 = edge;
            SplineHyperEdge.access$9(v0, SplineHyperEdge.access$14(v0) + shiftBase);
        }
        for (SplineHyperEdge source : edges) {
            depIter = SplineHyperEdge.access$1(source).listIterator();
            while (depIter.hasNext()) {
                dependency = (Dependency)depIter.next();
                target = Dependency.access$1(dependency);
                if (SplineHyperEdge.access$14(source) <= SplineHyperEdge.access$14(target)) continue;
                depIter.remove();
                SplineHyperEdge.access$2(target).remove(dependency);
                if (Dependency.access$0(dependency) <= 0) continue;
                Dependency.access$2(dependency, target);
                SplineHyperEdge.access$1(target).add(dependency);
                Dependency.access$3(dependency, source);
                SplineHyperEdge.access$2(source).add(dependency);
            }
        }
    }

    private static void updateNeighbors(SplineHyperEdge edge, List<SplineHyperEdge> sources, List<SplineHyperEdge> sinks) {
        for (Dependency dep : edge.outgoing) {
            if (dep.target.mark >= 0 || dep.weight <= 0) continue;
            SplineHyperEdge splineHyperEdge = dep.target;
            splineHyperEdge.inweight = splineHyperEdge.inweight - dep.weight;
            if (dep.target.inweight > 0 || dep.target.outweight <= 0) continue;
            sources.add(dep.target);
        }
        for (Dependency dep : edge.incoming) {
            if (dep.source.mark >= 0 || dep.weight <= 0) continue;
            SplineHyperEdge splineHyperEdge = dep.source;
            splineHyperEdge.outweight = splineHyperEdge.outweight - dep.weight;
            if (dep.source.outweight > 0 || dep.source.inweight <= 0) continue;
            sinks.add(dep.source);
        }
    }

    private static void topologicalNumbering(List<SplineHyperEdge> edges) {
        SplineHyperEdge edge3;
        LinkedList sources = Lists.newLinkedList();
        LinkedList rightwardTargets = Lists.newLinkedList();
        for (SplineHyperEdge edge2 : edges) {
            edge2.inweight = edge2.incoming.size();
            edge2.outweight = edge2.outgoing.size();
            if (edge2.inweight == 0) {
                sources.add(edge2);
            }
            if (edge2.outweight != 0 || !edge2.leftPorts.isEmpty()) continue;
            rightwardTargets.add(edge2);
        }
        int maxRank = -1;
        while (!sources.isEmpty()) {
            edge3 = (SplineHyperEdge)sources.remove(0);
            for (Object dep : edge3.outgoing) {
                SplineHyperEdge target = ((Dependency)dep).target;
                target.rank = Math.max(target.rank, edge3.rank + 1);
                maxRank = Math.max(maxRank, target.rank);
                SplineHyperEdge splineHyperEdge = target;
                splineHyperEdge.inweight = splineHyperEdge.inweight - 1;
                if (target.inweight != 0) continue;
                sources.add(target);
            }
        }
        if (maxRank > -1) {
            for (SplineHyperEdge edge3 : rightwardTargets) {
                edge3.rank = maxRank;
            }
            while (!rightwardTargets.isEmpty()) {
                edge3 = (SplineHyperEdge)rightwardTargets.remove(0);
                for (Object dep : edge3.incoming) {
                    SplineHyperEdge source = ((Dependency)dep).source;
                    if (!source.leftPorts.isEmpty()) continue;
                    source.rank = Math.min(source.rank, edge3.rank - 1);
                    SplineHyperEdge splineHyperEdge = source;
                    splineHyperEdge.outweight = splineHyperEdge.outweight - 1;
                    if (source.outweight != 0) continue;
                    rightwardTargets.add(source);
                }
            }
        }
    }

    private void calculateBezierBendPoints(LEdge edge, Map<LEdge, LEdge> succeedingEdge, boolean sloppyRouting) {
        KVector offsetOfStraightening;
        KVectorChain allCP = new KVectorChain();
        KVector northSouthBendPoint = null;
        LPort sourcePort = edge.getSource();
        LNode.NodeType sourceNodeType = sourcePort.getNode().getType();
        if (!this.isQualifiedAsStartingNode(sourcePort.getNode())) {
            throw new IllegalArgumentException("The target node of the edge must be a normal node or a northSouthPort.");
        }
        if (sourceNodeType == LNode.NodeType.NORTH_SOUTH_PORT) {
            LPort originPort = (LPort)((Object)sourcePort.getProperty(InternalProperties.ORIGIN));
            northSouthBendPoint = new KVector(originPort.getAbsoluteAnchor().x, sourcePort.getAbsoluteAnchor().y);
            sourcePort = originPort;
        }
        allCP.addLast((Object)sourcePort.getAbsoluteAnchor());
        if (!sloppyRouting) {
            double gap = Math.max(5.0, SplinesMath.getMarginOnPortSide(sourcePort.getNode(), sourcePort.getSide()));
            offsetOfStraightening = new KVector(SplinesMath.portSideToDirection(sourcePort.getSide()));
            offsetOfStraightening.scale(gap);
            allCP.add((Object)offsetOfStraightening.add(sourcePort.getAbsoluteAnchor()));
        }
        if (northSouthBendPoint != null) {
            allCP.addLast(northSouthBendPoint);
            northSouthBendPoint = null;
        }
        LEdge currentEdge = edge;
        LEdge lastEdge = edge;
        KVector lastCP = null;
        boolean addMidPoint = false;
        while (currentEdge != null) {
            KVectorChain currentBendPoints = currentEdge.getBendPoints();
            if (!currentBendPoints.isEmpty()) {
                if (addMidPoint) {
                    allCP.add((Object)lastCP.add((KVector)currentBendPoints.getFirst()).scale(0.5));
                    addMidPoint = false;
                } else {
                    addMidPoint = true;
                }
                lastCP = ((KVector)currentBendPoints.getLast()).clone();
                allCP.addAll((Collection)currentBendPoints);
                currentBendPoints.clear();
            }
            lastEdge = currentEdge;
            currentEdge = succeedingEdge.get((Object)currentEdge);
        }
        LPort targetPort = lastEdge.getTarget();
        if (targetPort.getNode().getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
            LPort originPort = (LPort)((Object)targetPort.getProperty(InternalProperties.ORIGIN));
            allCP.add((Object)new KVector(originPort.getAbsoluteAnchor().x, targetPort.getAbsoluteAnchor().y));
            targetPort = originPort;
        }
        if (!sloppyRouting) {
            double gap = Math.max(5.0, SplinesMath.getMarginOnPortSide(targetPort.getNode(), targetPort.getSide()));
            offsetOfStraightening = new KVector(SplinesMath.portSideToDirection(targetPort.getSide()));
            offsetOfStraightening.scale(gap);
            allCP.add((Object)offsetOfStraightening.add(targetPort.getAbsoluteAnchor()));
        }
        allCP.addLast((Object)targetPort.getAbsoluteAnchor());
        NubSpline nubSpline = new NubSpline(true, 3, (List<KVector>)allCP);
        edge.getBendPoints().addAll((Collection)nubSpline.getBezierCP());
    }

    private void calculateNUBSBendPointStraight(SplineHyperEdge hyperEdge, double startPos) {
        Set edges = hyperEdge.edges;
        if (edges.size() > 1) {
            throw new IllegalArgumentException("In straight hyperEdges there may be only one edge.");
        }
        ((LEdge)((Object)edges.iterator().next())).getBendPoints().add((Object)new KVector(startPos, hyperEdge.centerYPos));
    }

    private void calculateNUBSBendPoints(SplineHyperEdge hyperEdge, double startXPos, double endXPos, boolean sloppyRouting) {
        double centerXPos = sloppyRouting ? (startXPos + endXPos) / 2.0 : startXPos + (double)(hyperEdge.rank + 1) * this.hEdgeSpacing;
        for (LEdge edge : hyperEdge.edges) {
            KVector targetAnchor = edge.getTarget().getAbsoluteAnchor();
            KVector sourceAnchor = edge.getSource().getAbsoluteAnchor();
            KVector sourceVerticalCP = new KVector(centerXPos, sourceAnchor.y);
            KVector targetVerticalCP = new KVector(centerXPos, targetAnchor.y);
            KVector sourceStraightCP = new KVector(startXPos - 10.0, sourceAnchor.y);
            KVector targetStraightCP = new KVector(endXPos, targetAnchor.y);
            boolean invertedSource = false;
            boolean invertedTarget = false;
            if (targetAnchor.x >= endXPos && sourceAnchor.x >= endXPos) {
                invertedSource = true;
                sourceStraightCP.x = endXPos;
            }
            if (targetAnchor.x <= startXPos && sourceAnchor.x <= startXPos) {
                invertedTarget = true;
                targetStraightCP.x = startXPos - 10.0;
            }
            boolean normalSource = this.isNormalNode(edge.getSource().getNode());
            boolean normalTarget = this.isNormalNode(edge.getTarget().getNode());
            if (!sloppyRouting || !normalSource && !normalTarget || invertedTarget || invertedSource) {
                if (hyperEdge.edges.size() == 1) {
                    edge.getBendPoints().addAll(new KVector[]{sourceStraightCP, sourceVerticalCP, targetVerticalCP, targetStraightCP});
                    continue;
                }
                KVector center = new KVector(centerXPos, hyperEdge.centerYPos);
                edge.getBendPoints().addAll(new KVector[]{sourceStraightCP, sourceVerticalCP, center, targetVerticalCP, targetStraightCP});
                continue;
            }
            if (normalSource && normalTarget) {
                int indegree = 0;
                int outdegree = 0;
                for (LPort port : edge.getTarget().getNode().getPorts()) {
                    indegree += port.getIncomingEdges().size();
                }
                for (LPort port : edge.getSource().getNode().getPorts()) {
                    outdegree += port.getOutgoingEdges().size();
                }
                int degreeDiff = (int)Math.signum(outdegree - indegree);
                double centerYPos = (targetAnchor.y + sourceAnchor.y) / 2.0 + (targetAnchor.y - sourceAnchor.y) * (0.4 * (double)degreeDiff);
                if (targetAnchor.x > endXPos) {
                    edge.getBendPoints().add((Object)targetStraightCP);
                }
                edge.getBendPoints().add((Object)new KVector(centerXPos, centerYPos));
                if (!(sourceAnchor.x < startXPos)) continue;
                edge.getBendPoints().add((Object)sourceStraightCP);
                continue;
            }
            if (normalSource) {
                edge.getBendPoints().addAll(new KVector[]{targetVerticalCP, targetStraightCP});
                continue;
            }
            if (!normalTarget) continue;
            edge.getBendPoints().addAll(new KVector[]{sourceStraightCP, sourceVerticalCP});
        }
    }

    private boolean layerOnlyContainsDummies(Layer layer) {
        for (LNode n : layer.getNodes()) {
            if (!this.isNormalNode(n)) continue;
            return false;
        }
        return true;
    }

    private boolean isNormalNode(LNode node) {
        LNode.NodeType nt = node.getType();
        return nt == LNode.NodeType.NORMAL || nt == LNode.NodeType.BIG_NODE;
    }

    private boolean isQualifiedAsStartingNode(LNode node) {
        LNode.NodeType nt = node.getType();
        return nt == LNode.NodeType.NORMAL || nt == LNode.NodeType.NORTH_SOUTH_PORT || nt == LNode.NodeType.EXTERNAL_PORT || nt == LNode.NodeType.BIG_NODE;
    }

    private final class Dependency {
        private SplineHyperEdge source;
        private SplineHyperEdge target;
        private final int weight;

        Dependency(SplineHyperEdge source, SplineHyperEdge target, int weight) {
            this.source = source;
            this.target = target;
            this.weight = weight;
            source.outgoing.add(this);
            target.incoming.add(this);
        }

        public String toString() {
            return this.source + " ->(" + this.weight + ") " + this.target;
        }

        static /* synthetic */ void access$2(Dependency dependency, SplineHyperEdge splineHyperEdge) {
            dependency.source = splineHyperEdge;
        }

        static /* synthetic */ void access$3(Dependency dependency, SplineHyperEdge splineHyperEdge) {
            dependency.target = splineHyperEdge;
        }
    }

    private static enum SideToProcess {
        LEFT,
        RIGHT;

    }

    private static final class SplineHyperEdge
    implements Comparable<SplineHyperEdge> {
        private final Set<LPort> leftPorts = Sets.newHashSet();
        private final Set<LPort> rightPorts = Sets.newHashSet();
        private final Set<LEdge> edges = Sets.newHashSet();
        private boolean isStraight;
        private double topYPos;
        private double centerYPos;
        private double bottomYPos;
        private final List<Dependency> outgoing = Lists.newArrayList();
        private final List<Dependency> incoming = Lists.newArrayList();
        private int mark;
        private int inweight;
        private int outweight;
        private int rank;

        SplineHyperEdge(LPort singlePort, Set<Pair<SideToProcess, LEdge>> edges, SideToProcess sourceSide) {
            if (sourceSide == SideToProcess.LEFT) {
                this.leftPorts.add(singlePort);
            } else {
                this.rightPorts.add(singlePort);
            }
            double yMinPosOfTarget = Double.POSITIVE_INFINITY;
            double yMaxPosOfTarget = Double.NEGATIVE_INFINITY;
            for (Pair<SideToProcess, LEdge> pair : edges) {
                SideToProcess side = (SideToProcess)((Object)pair.getFirst());
                LEdge edge = (LEdge)((Object)pair.getSecond());
                LPort targetPort = edge.getSource();
                if (((Object)((Object)targetPort)).equals((Object)singlePort)) {
                    targetPort = edge.getTarget();
                }
                if (side == SideToProcess.LEFT) {
                    this.leftPorts.add(targetPort);
                } else {
                    this.rightPorts.add(targetPort);
                }
                double yPosOfTarget = targetPort.getAbsoluteAnchor().y;
                yMinPosOfTarget = Math.min(yMinPosOfTarget, yPosOfTarget);
                yMaxPosOfTarget = Math.max(yMaxPosOfTarget, yPosOfTarget);
            }
            double yPosOfSingleSide = singlePort.getAbsoluteAnchor().y;
            this.setRelevantPositions(yPosOfSingleSide, yMinPosOfTarget, yMaxPosOfTarget);
            for (Pair<SideToProcess, LEdge> pair : edges) {
                this.edges.add((LEdge)((Object)pair.getSecond()));
            }
            this.isStraight = false;
        }

        SplineHyperEdge(LEdge edge, SideToProcess sourceSide, SideToProcess targetSide) {
            if (sourceSide == SideToProcess.LEFT) {
                this.leftPorts.add(edge.getSource());
            } else {
                this.rightPorts.add(edge.getSource());
            }
            if (targetSide == SideToProcess.LEFT) {
                this.leftPorts.add(edge.getTarget());
            } else {
                this.rightPorts.add(edge.getTarget());
            }
            this.edges.add(edge);
            double sourceY = edge.getSource().getAbsoluteAnchor().y;
            double targetY = edge.getTarget().getAbsoluteAnchor().y;
            this.setRelevantPositions(sourceY, targetY, targetY);
            this.isStraight = SplineEdgeRouter.isStraight(edge.getSource().getAbsoluteAnchor().y, edge.getTarget().getAbsoluteAnchor().y);
        }

        @Override
        public int compareTo(SplineHyperEdge other) {
            return this.mark - other.mark;
        }

        private void setRelevantPositions(double sourceY, double targetYMin, double targetYMax) {
            if (sourceY < targetYMin) {
                this.centerYPos = 0.5 * (sourceY + targetYMin);
                this.topYPos = 0.09999999999999998 * this.centerYPos + 0.9 * sourceY;
                this.bottomYPos = 0.09999999999999998 * this.centerYPos + 0.9 * targetYMin;
            } else {
                this.centerYPos = 0.5 * (sourceY + targetYMax);
                this.topYPos = 0.09999999999999998 * this.centerYPos + 0.9 * targetYMax;
                this.bottomYPos = 0.09999999999999998 * this.centerYPos + 0.9 * sourceY;
            }
        }

        static /* synthetic */ void access$9(SplineHyperEdge splineHyperEdge, int n) {
            splineHyperEdge.mark = n;
        }
    }
}

