/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class HypernodesProcessor
implements ILayoutProcessor {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hypernodes processing", 1.0f);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                if (!((Boolean)node.getProperty(LayeredOptions.HYPERNODE)).booleanValue() || node.getPorts().size() > 2) continue;
                int topEdges = 0;
                int rightEdges = 0;
                int bottomEdges = 0;
                int leftEdges = 0;
                for (LPort port : node.getPorts()) {
                    switch (port.getSide()) {
                        case NORTH: {
                            ++topEdges;
                            break;
                        }
                        case EAST: {
                            ++rightEdges;
                            break;
                        }
                        case SOUTH: {
                            ++bottomEdges;
                            break;
                        }
                        case WEST: {
                            ++leftEdges;
                        }
                    }
                }
                if (topEdges != 0 || bottomEdges != 0) continue;
                this.moveHypernode(layeredGraph, node, leftEdges <= rightEdges);
            }
        }
        monitor.done();
    }

    private void moveHypernode(LGraph layeredGraph, LNode hypernode, boolean right) {
        ArrayList bendEdges = Lists.newArrayList();
        double bendx = 2.147483647E9;
        double diffx = 2.147483647E9;
        double diffy = 2.147483647E9;
        if (right) {
            bendx = layeredGraph.getSize().x;
            for (LPort port : hypernode.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    if (edge.getBendPoints().isEmpty()) continue;
                    KVector firstPoint = (KVector)edge.getBendPoints().getFirst();
                    if (firstPoint.x < bendx) {
                        diffx = bendx - firstPoint.x;
                        diffy = 2.147483647E9;
                        bendEdges.clear();
                        bendx = firstPoint.x;
                    }
                    if (!(firstPoint.x <= bendx)) continue;
                    bendEdges.add(edge);
                    if (edge.getBendPoints().size() <= 1) continue;
                    diffy = Math.min(diffy, Math.abs(((KVector)edge.getBendPoints().get((int)1)).y - firstPoint.y));
                }
            }
        } else {
            for (LPort port : hypernode.getPorts()) {
                for (LEdge edge : port.getIncomingEdges()) {
                    if (edge.getBendPoints().isEmpty()) continue;
                    KVector lastPoint = (KVector)edge.getBendPoints().getLast();
                    if (lastPoint.x > bendx) {
                        diffx = lastPoint.x - bendx;
                        diffy = 2.147483647E9;
                        bendEdges.clear();
                        bendx = lastPoint.x;
                    }
                    if (!(lastPoint.x >= bendx)) continue;
                    bendEdges.add(edge);
                    if (edge.getBendPoints().size() <= 1) continue;
                    diffy = Math.min(diffy, Math.abs(((KVector)edge.getBendPoints().get((int)(edge.getBendPoints().size() - 2))).y - lastPoint.y));
                }
            }
        }
        if (!bendEdges.isEmpty() && diffx > hypernode.getSize().x / 2.0 && diffy > hypernode.getSize().y / 2.0) {
            LPort northPort = new LPort();
            northPort.setNode(hypernode);
            northPort.setSide(PortSide.NORTH);
            northPort.getPosition().x = hypernode.getSize().x / 2.0;
            LPort southPort = new LPort();
            southPort.setNode(hypernode);
            southPort.setSide(PortSide.SOUTH);
            southPort.getPosition().x = hypernode.getSize().x / 2.0;
            southPort.getPosition().y = hypernode.getSize().y;
            for (LEdge edge : bendEdges) {
                KVector second;
                KVector first;
                if (right) {
                    first = (KVector)edge.getBendPoints().removeFirst();
                    KVector kVector = second = edge.getBendPoints().isEmpty() ? edge.getTarget().getAbsoluteAnchor() : (KVector)edge.getBendPoints().getFirst();
                    if (second.y >= first.y) {
                        edge.setSource(southPort);
                    } else {
                        edge.setSource(northPort);
                    }
                } else {
                    first = (KVector)edge.getBendPoints().removeLast();
                    KVector kVector = second = edge.getBendPoints().isEmpty() ? edge.getSource().getAbsoluteAnchor() : (KVector)edge.getBendPoints().getLast();
                    if (second.y >= first.y) {
                        edge.setTarget(southPort);
                    } else {
                        edge.setTarget(northPort);
                    }
                }
                KVectorChain junctionPoints = (KVectorChain)edge.getProperty(LayeredOptions.JUNCTION_POINTS);
                if (junctionPoints == null) continue;
                junctionPoints.remove((Object)first);
            }
            hypernode.getPosition().x = bendx - hypernode.getSize().x / 2.0;
        }
    }
}

