/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.force.properties;

import java.util.EnumSet;
import org.eclipse.elk.alg.force.properties.StressOptions;
import org.eclipse.elk.alg.force.stress.StressMajorization;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class StressMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final boolean FIXED_DEFAULT = false;
    public static final IProperty<Boolean> FIXED = new Property("org.eclipse.elk.stress.fixed", (Object)false, null, null);
    private static final float DESIRED_EDGE_LENGTH_DEFAULT = 100.0f;
    public static final IProperty<Float> DESIRED_EDGE_LENGTH = new Property("org.eclipse.elk.stress.desiredEdgeLength", (Object)Float.valueOf(100.0f), null, null);
    private static final StressMajorization.Dimension DIMENSION_DEFAULT = StressMajorization.Dimension.XY;
    public static final IProperty<StressMajorization.Dimension> DIMENSION = new Property("org.eclipse.elk.stress.dimension", (Object)DIMENSION_DEFAULT, null, null);
    private static final float EPSILON_DEFAULT = 0.001f;
    public static final IProperty<Float> EPSILON = new Property("org.eclipse.elk.stress.epsilon", (Object)Float.valueOf(0.001f), null, null);
    private static final int ITERATION_LIMIT_DEFAULT = Integer.MAX_VALUE;
    public static final IProperty<Integer> ITERATION_LIMIT = new Property("org.eclipse.elk.stress.iterationLimit", (Object)Integer.MAX_VALUE, null, null);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData("org.eclipse.elk.stress.fixed", "", "Fixed Position", "Prevent that the node is moved by the layout algorithm.", (Object)false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.NODES), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.stress.desiredEdgeLength", "", "Desired Edge Length", "Either specified for parent nodes or for individual edges, where the latter takes higher precedence.", (Object)Float.valueOf(100.0f), null, null, LayoutOptionData.Type.DOUBLE, Double.class, EnumSet.of(LayoutOptionData.Target.PARENTS, LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.stress.dimension", "", "Layout Dimension", "Dimensions that are permitted to be altered during layout.", (Object)DIMENSION_DEFAULT, null, null, LayoutOptionData.Type.ENUM, StressMajorization.Dimension.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.stress.epsilon", "", "Stress Epsilon", "Termination criterion for the iterative process.", (Object)Float.valueOf(0.001f), null, null, LayoutOptionData.Type.DOUBLE, Double.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.stress.iterationLimit", "", "Iteration Limit", "Maximum number of performed iterations. Takes higher precedence than 'epsilon'.", (Object)Integer.MAX_VALUE, null, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        new StressOptions().apply(registry);
    }
}

