/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import java.util.EnumSet;
import org.eclipse.elk.alg.graphviz.dot.transform.NeatoModel;
import org.eclipse.elk.alg.graphviz.dot.transform.OverlapMode;
import org.eclipse.elk.alg.graphviz.layouter.CircoOptions;
import org.eclipse.elk.alg.graphviz.layouter.DotOptions;
import org.eclipse.elk.alg.graphviz.layouter.FdpOptions;
import org.eclipse.elk.alg.graphviz.layouter.NeatoOptions;
import org.eclipse.elk.alg.graphviz.layouter.TwopiOptions;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.ExclusiveBounds;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class GraphvizMetaDataProvider
implements ILayoutMetaDataProvider {
    private static final boolean ADAPT_PORT_POSITIONS_DEFAULT = true;
    public static final IProperty<Boolean> ADAPT_PORT_POSITIONS = new Property("org.eclipse.elk.graphviz.adaptPortPositions", (Object)true, null, null);
    private static final boolean CONCENTRATE_DEFAULT = false;
    public static final IProperty<Boolean> CONCENTRATE = new Property("org.eclipse.elk.graphviz.concentrate", (Object)false, null, null);
    private static final Comparable<? super Double> EPSILON_LOWER_BOUND = ExclusiveBounds.greaterThan((double)0.0);
    public static final IProperty<Double> EPSILON = new Property("org.eclipse.elk.graphviz.epsilon", null, EPSILON_LOWER_BOUND, null);
    private static final Comparable<? super Double> ITERATIONS_FACTOR_LOWER_BOUND = ExclusiveBounds.greaterThan((double)0.0);
    public static final IProperty<Double> ITERATIONS_FACTOR = new Property("org.eclipse.elk.graphviz.iterationsFactor", null, ITERATIONS_FACTOR_LOWER_BOUND, null);
    private static final double LABEL_ANGLE_DEFAULT = -25.0;
    public static final IProperty<Double> LABEL_ANGLE = new Property("org.eclipse.elk.graphviz.labelAngle", (Object)-25.0, null, null);
    private static final double LABEL_DISTANCE_DEFAULT = 1.0;
    private static final Comparable<? super Double> LABEL_DISTANCE_LOWER_BOUND = 0.0;
    public static final IProperty<Double> LABEL_DISTANCE = new Property("org.eclipse.elk.graphviz.labelDistance", (Object)1.0, LABEL_DISTANCE_LOWER_BOUND, null);
    private static final double LAYER_SPACING_FACTOR_DEFAULT = 1.0;
    private static final Comparable<? super Double> LAYER_SPACING_FACTOR_LOWER_BOUND = ExclusiveBounds.greaterThan((double)0.0);
    public static final IProperty<Double> LAYER_SPACING_FACTOR = new Property("org.eclipse.elk.graphviz.layerSpacingFactor", (Object)1.0, LAYER_SPACING_FACTOR_LOWER_BOUND, null);
    private static final Comparable<? super Integer> MAXITER_LOWER_BOUND = 1;
    public static final IProperty<Integer> MAXITER = new Property("org.eclipse.elk.graphviz.maxiter", null, MAXITER_LOWER_BOUND, null);
    private static final NeatoModel NEATO_MODEL_DEFAULT = NeatoModel.SHORTPATH;
    public static final IProperty<NeatoModel> NEATO_MODEL = new Property("org.eclipse.elk.graphviz.neatoModel", (Object)NEATO_MODEL_DEFAULT, null, null);
    private static final OverlapMode OVERLAP_MODE_DEFAULT = OverlapMode.PRISM;
    public static final IProperty<OverlapMode> OVERLAP_MODE = new Property("org.eclipse.elk.graphviz.overlapMode", (Object)OVERLAP_MODE_DEFAULT, null, null);

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.adaptPortPositions", "", "Adapt Port Positions", "Whether ports should be moved to the point where edges cross the node's bounds.", (Object)true, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.concentrate", "", "Concentrate Edges", "Merges multiedges into a single edge and causes partially parallel edges to share part of their paths.", (Object)false, null, null, LayoutOptionData.Type.BOOLEAN, Boolean.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.epsilon", "", "Epsilon", "Terminating condition. If the length squared of all energy gradients are less than epsilon, the algorithm stops.", null, EPSILON_LOWER_BOUND, null, LayoutOptionData.Type.DOUBLE, Double.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.iterationsFactor", "", "Iterations Factor", "Multiplicative scale factor for the maximal number of iterations used during crossing minimization, node ranking, and node positioning.", null, ITERATIONS_FACTOR_LOWER_BOUND, null, LayoutOptionData.Type.DOUBLE, Double.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.labelAngle", "", "Label Angle", "Angle between head / tail positioned edge labels and the corresponding edge.", (Object)-25.0, null, null, LayoutOptionData.Type.DOUBLE, Double.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.labelDistance", "", "Label Distance", "Distance of head / tail positioned edge labels to the source or target node.", (Object)1.0, LABEL_DISTANCE_LOWER_BOUND, null, LayoutOptionData.Type.DOUBLE, Double.class, EnumSet.of(LayoutOptionData.Target.EDGES), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.layerSpacingFactor", "", "Layer Spacing Factor", "Factor for the spacing of different layers (ranks).", (Object)1.0, LAYER_SPACING_FACTOR_LOWER_BOUND, null, LayoutOptionData.Type.DOUBLE, Double.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.maxiter", "", "Max. Iterations", "The maximum number of iterations.", null, MAXITER_LOWER_BOUND, null, LayoutOptionData.Type.INT, Integer.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.neatoModel", "", "Distance Model", "Specifies how the distance matrix is computed for the input graph.", (Object)NEATO_MODEL_DEFAULT, null, null, LayoutOptionData.Type.ENUM, NeatoModel.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.ADVANCED, new String[0]));
        registry.register(new LayoutOptionData("org.eclipse.elk.graphviz.overlapMode", "", "Overlap Removal", "Determines if and how node overlaps should be removed.", (Object)OVERLAP_MODE_DEFAULT, null, null, LayoutOptionData.Type.ENUM, OverlapMode.class, EnumSet.of(LayoutOptionData.Target.PARENTS), LayoutOptionData.Visibility.VISIBLE, new String[0]));
        new DotOptions().apply(registry);
        new NeatoOptions().apply(registry);
        new FdpOptions().apply(registry);
        new TwopiOptions().apply(registry);
        new CircoOptions().apply(registry);
    }
}

