/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.math;

import com.google.common.math.DoubleMath;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;

public final class ElkMath {
    private static final long[] FACT_TABLE = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    private static final int W_DEGREE = 5;
    private static final int DEGREE = 3;
    private static final double[][] CUBIC_Z = new double[][]{{1.0, 0.6, 0.3, 0.1}, {0.4, 0.6, 0.6, 0.4}, {0.1, 0.3, 0.6, 1.0}};
    private static final int MAXDEPTH = 64;
    private static final double EPSILON = 1.0 * Math.pow(2.0, -65.0);
    private static final double DOUBLE_EQ_EPSILON = 1.0E-5;

    private ElkMath() {
    }

    public static long factl(int x) {
        if (x < 0 || x >= FACT_TABLE.length) {
            throw new IllegalArgumentException("The input must be between 0 and " + FACT_TABLE.length);
        }
        return FACT_TABLE[x];
    }

    public static double factd(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("The input must be positive");
        }
        if (x < FACT_TABLE.length) {
            return FACT_TABLE[x];
        }
        return Math.sqrt(Math.PI * 2 * (double)x) * ((double)ElkMath.powf(x, x) / ElkMath.powd(Math.E, x));
    }

    public static long binomiall(int n, int k) {
        if (n < 0 || k < 0) {
            throw new IllegalArgumentException("k and n must be positive");
        }
        if (k > n) {
            throw new IllegalArgumentException("k must be smaller than n");
        }
        if (k == 0 || k == n) {
            return 1L;
        }
        if (n == 0) {
            return 0L;
        }
        if (n < FACT_TABLE.length) {
            return ElkMath.factl(n) / (ElkMath.factl(k) * ElkMath.factl(n - k));
        }
        return ElkMath.binomiall(n - 1, k - 1) + ElkMath.binomiall(n - 1, k);
    }

    public static double binomiald(int n, int k) {
        if (n < 0 || k < 0) {
            throw new IllegalArgumentException("k and n must be positive");
        }
        if (k > n) {
            throw new IllegalArgumentException("k must be smaller than n");
        }
        if (k == 0 || k == n) {
            return 1.0;
        }
        if (n == 0) {
            return 0.0;
        }
        return ElkMath.factd(n) / (ElkMath.factd(k) * ElkMath.factd(n - k));
    }

    public static double powd(double a, int b) {
        double result = 1.0;
        double base = a;
        int exp = b >= 0 ? b : -b;
        while (exp > 0) {
            if (exp % 2 == 0) {
                base *= base;
                exp /= 2;
                continue;
            }
            result *= base;
            --exp;
        }
        if (b < 0) {
            return 1.0 / result;
        }
        return result;
    }

    public static float powf(float a, int b) {
        float result = 1.0f;
        float base = a;
        int exp = b >= 0 ? b : -b;
        while (exp > 0) {
            if (exp % 2 == 0) {
                base *= base;
                exp /= 2;
                continue;
            }
            result *= base;
            --exp;
        }
        if (b < 0) {
            return 1.0f / result;
        }
        return result;
    }

    public static KVector[] approximateBezierSegment(int resultSize, KVector ... controlPoints) {
        if (resultSize <= 0) {
            return new KVector[0];
        }
        KVector[] result = new KVector[resultSize];
        int n = controlPoints.length - 1;
        double dt = 1.0 / (double)resultSize;
        double t = 0.0;
        int i = 0;
        while (i < resultSize) {
            t += dt;
            KVector v = new KVector();
            int j = 0;
            while (j <= n) {
                KVector p = controlPoints[j];
                double factor = ElkMath.binomiald(n, j) * ElkMath.powd(1.0 - t, n - j) * ElkMath.powd(t, j);
                v.x += p.x * factor;
                v.y += p.y * factor;
                ++j;
            }
            result[i] = v;
            ++i;
        }
        return result;
    }

    public static KVector[] approximateBezierSegment(KVector ... controlPoints) {
        int approximationCount = controlPoints.length + 1;
        return ElkMath.approximateBezierSegment(approximationCount, controlPoints);
    }

    public static KVectorChain approximateBezierSpline(KVectorChain controlPoints) {
        int ctrlPtCount = controlPoints.size();
        KVectorChain spline = new KVectorChain();
        ListIterator controlIter = controlPoints.listIterator();
        KVector currentPoint = (KVector)controlIter.next();
        spline.add(currentPoint);
        while (controlIter.hasNext()) {
            int remainingPoints = ctrlPtCount - controlIter.nextIndex();
            if (remainingPoints == 1) {
                spline.add((KVector)controlIter.next());
                continue;
            }
            if (remainingPoints == 2) {
                spline.addAll(ElkMath.approximateBezierSegment(currentPoint, (KVector)controlIter.next(), (KVector)controlIter.next()));
                continue;
            }
            KVector control1 = (KVector)controlIter.next();
            KVector control2 = (KVector)controlIter.next();
            KVector nextPoint = (KVector)controlIter.next();
            spline.addAll(ElkMath.approximateBezierSegment(currentPoint, control1, control2, nextPoint));
            currentPoint = nextPoint;
        }
        return spline;
    }

    public static double distanceFromBezierSegment(KVector start, KVector c1, KVector c2, KVector end, KVector needle) {
        double[] tCandidate = new double[5];
        KVector[] v = new KVector[]{start, c1, c2, end};
        KVector[] w = ElkMath.convertToBezierForm(v, needle);
        int nSolutions = ElkMath.findRoots(w, 5, tCandidate, 0);
        double minDistance = needle.distance(start);
        double t = 0.0;
        int i = 0;
        while (i < nSolutions) {
            KVector p = ElkMath.bezier(v, 3, tCandidate[i], null, null);
            double distance = needle.distance(p);
            if (distance < minDistance) {
                minDistance = distance;
                t = tCandidate[i];
            }
            ++i;
        }
        double distance = needle.distance(end);
        if (distance < minDistance) {
            t = 1.0;
        }
        KVector pn = new KVector(ElkMath.bezier(v, 3, t, null, null));
        return Math.sqrt(pn.distance(needle));
    }

    private static KVector[] convertToBezierForm(KVector[] v, KVector pa) {
        KVector[] c = new KVector[4];
        KVector[] d = new KVector[3];
        double[][] cdTable = new double[3][4];
        KVector[] w = new KVector[6];
        int i = 0;
        while (i <= 3) {
            c[i] = new KVector(v[i].x - pa.x, v[i].y - pa.y);
            ++i;
        }
        double s = 3.0;
        int i2 = 0;
        while (i2 <= 2) {
            d[i2] = new KVector(s * (v[i2 + 1].x - v[i2].x), s * (v[i2 + 1].y - v[i2].y));
            ++i2;
        }
        int row = 0;
        while (row <= 2) {
            int column = 0;
            while (column <= 3) {
                cdTable[row][column] = d[row].x * c[column].x + d[row].y * c[column].y;
                ++column;
            }
            ++row;
        }
        i2 = 0;
        while (i2 <= 5) {
            w[i2] = new KVector((double)i2 / 5.0, 0.0);
            ++i2;
        }
        int n = 3;
        int m = 2;
        int k = 0;
        while (k <= n + m) {
            int lb = Math.max(0, k - m);
            int ub = Math.min(k, n);
            int i3 = lb;
            while (i3 <= ub) {
                int j = k - i3;
                w[i3 + j].y += cdTable[j][i3] * CUBIC_Z[j][i3];
                ++i3;
            }
            ++k;
        }
        return w;
    }

    private static int findRoots(KVector[] w, int degree, double[] t, int depth) {
        switch (ElkMath.crossingCount(w, degree)) {
            case 0: {
                return 0;
            }
            case 1: {
                if (depth >= 64) {
                    t[0] = (w[0].x + w[5].x) / 2.0;
                    return 1;
                }
                if (!ElkMath.controlPolygonFlatEnough(w, degree)) break;
                t[0] = ElkMath.computeXIntercept(w, degree);
                return 1;
            }
        }
        KVector[] left = new KVector[6];
        KVector[] right = new KVector[6];
        double[] leftT = new double[6];
        double[] rightT = new double[6];
        ElkMath.bezier(w, degree, 0.5, left, right);
        int leftCount = ElkMath.findRoots(left, degree, leftT, depth + 1);
        int rightCount = ElkMath.findRoots(right, degree, rightT, depth + 1);
        int i = 0;
        while (i < leftCount) {
            t[i] = leftT[i];
            ++i;
        }
        i = 0;
        while (i < rightCount) {
            t[i + leftCount] = rightT[i];
            ++i;
        }
        return leftCount + rightCount;
    }

    private static boolean controlPolygonFlatEnough(KVector[] v, int degree) {
        double a = v[0].y - v[degree].y;
        double b = v[degree].x - v[0].x;
        double c = v[0].x * v[degree].y - v[degree].x * v[0].y;
        double abSquared = a * a + b * b;
        double[] distance = new double[degree + 1];
        int i = 1;
        while (i < degree) {
            distance[i] = a * v[i].x + b * v[i].y + c;
            if (distance[i] > 0.0) {
                distance[i] = distance[i] * distance[i] / abSquared;
            }
            if (distance[i] < 0.0) {
                distance[i] = -(distance[i] * distance[i] / abSquared);
            }
            ++i;
        }
        double maxDistanceAbove = 0.0;
        double maxDistanceBelow = 0.0;
        int i2 = 1;
        while (i2 < degree) {
            if (distance[i2] < 0.0) {
                maxDistanceBelow = Math.min(maxDistanceBelow, distance[i2]);
            }
            if (distance[i2] > 0.0) {
                maxDistanceAbove = Math.max(maxDistanceAbove, distance[i2]);
            }
            ++i2;
        }
        double a1 = 0.0;
        double b1 = 1.0;
        double c1 = 0.0;
        double a2 = a;
        double b2 = b;
        double c2 = c + maxDistanceAbove;
        double det = a1 * b2 - a2 * b1;
        double dInv = 1.0 / det;
        double intercept1 = (b1 * c2 - b2 * c1) * dInv;
        a2 = a;
        b2 = b;
        c2 = c + maxDistanceBelow;
        det = a1 * b2 - a2 * b1;
        dInv = 1.0 / det;
        double intercept2 = (b1 * c2 - b2 * c1) * dInv;
        double leftIntercept = Math.min(intercept1, intercept2);
        double rightIntercept = Math.max(intercept1, intercept2);
        double error = (rightIntercept - leftIntercept) / 2.0;
        return error < EPSILON;
    }

    private static double computeXIntercept(KVector[] v, int degree) {
        double xnm = v[degree].x - v[0].x;
        double ynm = v[degree].y - v[0].y;
        double xmk = v[0].x;
        double ymk = v[0].y;
        double detInv = -1.0 / ynm;
        return (xnm * ymk - ynm * xmk) * detInv;
    }

    private static int crossingCount(KVector[] v, int degree) {
        int sign;
        int nCrossings = 0;
        int oldSign = sign = v[0].y < 0.0 ? -1 : 1;
        int i = 1;
        while (i <= degree) {
            int n = sign = v[i].y < 0.0 ? -1 : 1;
            if (sign != oldSign) {
                ++nCrossings;
            }
            oldSign = sign;
            ++i;
        }
        return nCrossings;
    }

    private static KVector bezier(KVector[] c, int degree, double t, KVector[] left, KVector[] right) {
        KVector[][] p = new KVector[6][6];
        int j = 0;
        while (j <= degree) {
            p[0][j] = new KVector(c[j]);
            ++j;
        }
        int i = 1;
        while (i <= degree) {
            int j2 = 0;
            while (j2 <= degree - i) {
                p[i][j2] = new KVector((1.0 - t) * p[i - 1][j2].x + t * p[i - 1][j2 + 1].x, (1.0 - t) * p[i - 1][j2].y + t * p[i - 1][j2 + 1].y);
                ++j2;
            }
            ++i;
        }
        if (left != null) {
            j = 0;
            while (j <= degree) {
                left[j] = p[j][0];
                ++j;
            }
        }
        if (right != null) {
            j = 0;
            while (j <= degree) {
                right[j] = p[degree - j][j];
                ++j;
            }
        }
        return p[degree][0];
    }

    public static int maxi(int ... values) {
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static int mini(int ... values) {
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static int averagei(int ... values) {
        int avg = 0;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / values.length;
    }

    public static long maxl(long ... values) {
        long max = Integer.MIN_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static long minl(long ... values) {
        long min = Integer.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static long averagel(long ... values) {
        long avg = 0L;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / (long)values.length;
    }

    public static float maxf(float ... values) {
        float max = -3.4028235E38f;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static float minf(float ... values) {
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static float averagef(float ... values) {
        float avg = 0.0f;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / (float)values.length;
    }

    public static double maxd(double ... values) {
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < values.length) {
            if (values[i] > max) {
                max = values[i];
            }
            ++i;
        }
        return max;
    }

    public static double mind(double ... values) {
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < values.length) {
            if (values[i] < min) {
                min = values[i];
            }
            ++i;
        }
        return min;
    }

    public static double averaged(double ... values) {
        double avg = 0.0;
        int i = 0;
        while (i < values.length) {
            avg += values[i];
            ++i;
        }
        return avg / (double)values.length;
    }

    public static int boundi(int x, int lower, int upper) {
        if (x <= lower) {
            return lower;
        }
        if (x >= upper) {
            return upper;
        }
        return x;
    }

    public static long boundl(long x, long lower, long upper) {
        if (x <= lower) {
            return lower;
        }
        if (x >= upper) {
            return upper;
        }
        return x;
    }

    public static float boundf(float x, float lower, float upper) {
        if (x <= lower) {
            return lower;
        }
        if (x >= upper) {
            return upper;
        }
        return x;
    }

    public static double boundd(double x, double lower, double upper) {
        if (x <= lower) {
            return lower;
        }
        if (x >= upper) {
            return upper;
        }
        return x;
    }

    public static KVector clipVector(KVector v, double width, double height) {
        double wh = width / 2.0;
        double hh = height / 2.0;
        double absx = Math.abs(v.x);
        double absy = Math.abs(v.y);
        double xscale = 1.0;
        double yscale = 1.0;
        if (absx > wh) {
            xscale = wh / absx;
        }
        if (absy > hh) {
            yscale = hh / absy;
        }
        v.scale(Math.min(xscale, yscale));
        return v;
    }

    public static int signum(double x) {
        if (x < 0.0) {
            return -1;
        }
        if (x > 0.0) {
            return 1;
        }
        return 0;
    }

    public static boolean intersects(ElkRectangle rect, KVectorChain path) {
        KVector first;
        if (path.size() < 2) {
            return false;
        }
        Iterator pathIt = path.iterator();
        KVector p1 = first = (KVector)pathIt.next();
        while (pathIt.hasNext()) {
            KVector p2 = (KVector)pathIt.next();
            if (ElkMath.intersects(rect, p1, p2)) {
                return true;
            }
            p1 = p2;
        }
        return ElkMath.intersects(rect, p1, first);
    }

    public static boolean intersects(ElkRectangle rect, KVector p1, KVector p2) {
        if (ElkMath.contains(rect, p1, p2)) {
            return false;
        }
        return ElkMath.intersects(rect.getTopLeft(), rect.getTopRight(), p1, p2) || ElkMath.intersects(rect.getTopRight(), rect.getBottomRight(), p1, p2) || ElkMath.intersects(rect.getBottomRight(), rect.getBottomLeft(), p1, p2) || ElkMath.intersects(rect.getBottomLeft(), rect.getTopLeft(), p1, p2);
    }

    public static boolean intersects(KVector l11, KVector l12, KVector l21, KVector l22) {
        KVector u0 = l11;
        KVector v0 = l12.clone().sub(l11);
        KVector u1 = l21;
        KVector v1 = l22.clone().sub(l21);
        double x00 = u0.x;
        double y00 = u0.y;
        double x10 = u1.x;
        double y10 = u1.y;
        double x11 = v1.x;
        double y01 = v0.y;
        double x01 = v0.x;
        double y11 = v1.y;
        double d = x11 * y01 - x01 * y11;
        if (DoubleMath.fuzzyEquals((double)0.0, (double)d, (double)1.0E-5)) {
            return false;
        }
        double s = 1.0 / d * ((x00 - x10) * y01 - (y00 - y10) * x01);
        double t = 1.0 / d * -(-(x00 - x10) * y11 + (y00 - y10) * x11);
        return 0.0 < s && s < 1.0 && 0.0 < t && t < 1.0;
    }

    public static KVector intersects2(KVector p, KVector r, KVector q, KVector s) {
        KVector pq = q.clone().sub(p);
        double pqXr = KVector.crossProduct(pq, r);
        double rXs = KVector.crossProduct(r, s);
        double t = KVector.crossProduct(pq, s) / rXs;
        double u = pqXr / rXs;
        if (rXs == 0.0) {
            if (pqXr == 0.0) {
                KVector center = q.clone().add(s.clone().scale(0.5));
                double d1 = p.distance(center);
                double d2 = p.clone().add(r).distance(center);
                double l = s.length() * 0.5;
                if (d1 < d2 && d1 <= l) {
                    return p.clone();
                }
                if (d2 <= l) {
                    return p.clone().add(r);
                }
                return null;
            }
            return null;
        }
        if (t >= 0.0 && t <= 1.0 && u >= 0.0 && u <= 1.0) {
            return p.clone().add(r.clone().scale(t));
        }
        return null;
    }

    public static double distance(KVector a1, KVector a2, KVector b1, KVector b2, KVector v) {
        return Math.min(ElkMath.traceRays(a1, a2, b1, b2, v), ElkMath.traceRays(b1, b2, a1, a2, v.clone().negate()));
    }

    private static double traceRays(KVector a1, KVector a2, KVector b1, KVector b2, KVector v) {
        double result = Double.POSITIVE_INFINITY;
        boolean endpointHit = false;
        KVector intersection = ElkMath.intersects2(a1, a2.clone().sub(a1), b1.clone().add(v), b2.clone().sub(b1));
        boolean edgeCase = intersection != null && !intersection.equalsFuzzily(a1) && !intersection.equalsFuzzily(a2);
        intersection = ElkMath.intersects2(a1, a2.clone().sub(a1), b1, v);
        if (intersection != null) {
            if (intersection.equalsFuzzily(a1) == intersection.equalsFuzzily(a2) || edgeCase) {
                result = Math.min(result, intersection.sub(b1).length());
            } else {
                endpointHit = true;
            }
        }
        if ((intersection = ElkMath.intersects2(a1, a2.clone().sub(a1), b2, v)) != null && (endpointHit || intersection.equalsFuzzily(a1) == intersection.equalsFuzzily(a2) || edgeCase)) {
            result = Math.min(result, intersection.sub(b2).length());
        }
        return result;
    }

    public static boolean contains(ElkRectangle rect, KVectorChain path) {
        KVector first;
        if (path.size() < 2) {
            return false;
        }
        Iterator pathIt = path.iterator();
        KVector p1 = first = (KVector)pathIt.next();
        while (pathIt.hasNext()) {
            KVector p2 = (KVector)pathIt.next();
            if (!ElkMath.contains(rect, p1, p2)) {
                return false;
            }
            p1 = p2;
        }
        return ElkMath.contains(rect, p1, first);
    }

    public static boolean contains(ElkRectangle rect, KVector p1, KVector p2) {
        return ElkMath.contains(rect, p1) && ElkMath.contains(rect, p2);
    }

    public static boolean contains(ElkRectangle rect, KVector p) {
        double minX = rect.x;
        double maxX = rect.x + rect.width;
        double minY = rect.y;
        double maxY = rect.y + rect.height;
        return p.x > minX && p.x < maxX && p.y > minY && p.y < maxY;
    }

    public static double shortestDistance(ElkRectangle r1, ElkRectangle r2) {
        double rightDist = r2.x - (r1.x + r1.width);
        double leftDist = r1.x - (r2.x + r2.width);
        double topDist = r1.y - (r2.y + r2.height);
        double bottomDist = r2.y - (r1.y + r1.height);
        double horzDist = Math.max(leftDist, rightDist);
        double vertDist = Math.max(topDist, bottomDist);
        if (DoubleMath.fuzzyCompare((double)horzDist, (double)0.0, (double)1.0E-5) >= 0 ^ DoubleMath.fuzzyCompare((double)vertDist, (double)0.0, (double)1.0E-5) >= 0) {
            return Math.max(vertDist, horzDist);
        }
        if (DoubleMath.fuzzyCompare((double)horzDist, (double)0.0, (double)1.0E-5) > 0) {
            return Math.sqrt(vertDist * vertDist + horzDist * horzDist);
        }
        return -Math.sqrt(vertDist * vertDist + horzDist * horzDist);
    }
}

