/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.position;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.SelfLoopOrderingStrategy;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopComponent;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopOpposingSegment;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopType;
import org.eclipse.elk.alg.layered.p5edges.loops.position.AbstractSelfLoopPortPositioner;
import org.eclipse.elk.core.options.PortSide;

public class FixedSideSelfLoopPortPositioner
extends AbstractSelfLoopPortPositioner {
    private static final int ONE_SIDE_COMP = 1;
    private static final int TWO_SIDE_COMP = 2;
    private static final int THREE_SIDE_COMP = 3;
    private static final int FOUR_SIDE_COMP = 4;
    private SelfLoopOrderingStrategy ordering;
    private SelfLoopNode slNode;
    private Map<PortSide, Integer> nonLoopsPerSide = new HashMap<PortSide, Integer>();

    public FixedSideSelfLoopPortPositioner(SelfLoopOrderingStrategy ordering) {
        this.ordering = ordering;
    }

    @Override
    public void position(LNode node) {
        this.slNode = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        List<SelfLoopComponent> components = this.slNode.getSelfLoopComponents();
        components.sort((comp1, comp2) -> Integer.compare(comp1.getPorts().size(), comp2.getPorts().size()));
        ArrayListMultimap loopTypes = ArrayListMultimap.create();
        this.determineLoopTypes(components, (Multimap<SelfLoopType, SelfLoopComponent>)loopTypes);
        this.placeSideLoops(loopTypes.get((Object)SelfLoopType.SIDE));
        this.placeNonLoops(loopTypes.get((Object)SelfLoopType.NON_LOOP));
        this.placeOpposingLoops(loopTypes.get((Object)SelfLoopType.OPPOSING));
        this.placeThreeSidesLoop(loopTypes.get((Object)SelfLoopType.THREE_CORNER));
        this.placeFourSidesLoop(loopTypes.get((Object)SelfLoopType.FOUR_CORNER));
        this.placeCornerLoops(loopTypes.get((Object)SelfLoopType.CORNER));
    }

    public void determineLoopTypes(List<SelfLoopComponent> components, Multimap<SelfLoopType, SelfLoopComponent> loopTypes) {
        for (SelfLoopComponent component : components) {
            switch (component.getPortSides().size()) {
                case 1: {
                    if (component.getPorts().size() == 1) {
                        loopTypes.put((Object)SelfLoopType.NON_LOOP, (Object)component);
                        break;
                    }
                    loopTypes.put((Object)SelfLoopType.SIDE, (Object)component);
                    break;
                }
                case 2: {
                    if (component.isCornerComponent()) {
                        loopTypes.put((Object)SelfLoopType.CORNER, (Object)component);
                        break;
                    }
                    loopTypes.put((Object)SelfLoopType.OPPOSING, (Object)component);
                    break;
                }
                case 3: {
                    loopTypes.put((Object)SelfLoopType.THREE_CORNER, (Object)component);
                    break;
                }
                case 4: {
                    loopTypes.put((Object)SelfLoopType.FOUR_CORNER, (Object)component);
                }
            }
        }
    }

    private void placeSideLoops(Collection<SelfLoopComponent> sideComponents) {
        ArrayListMultimap sideMap = ArrayListMultimap.create();
        for (SelfLoopComponent component : sideComponents) {
            sideMap.put((Object)component.getPorts().get(0).getPortSide(), (Object)component);
        }
        if (this.ordering == SelfLoopOrderingStrategy.STACKED) {
            this.stackComponents(this.slNode, sideMap.get((Object)PortSide.NORTH), PortSide.NORTH);
            this.stackComponents(this.slNode, sideMap.get((Object)PortSide.SOUTH), PortSide.SOUTH);
            this.stackComponents(this.slNode, sideMap.get((Object)PortSide.EAST), PortSide.EAST);
            this.stackComponents(this.slNode, sideMap.get((Object)PortSide.WEST), PortSide.WEST);
        } else {
            this.sequenceComponents(this.slNode, sideMap.get((Object)PortSide.NORTH), PortSide.NORTH);
            this.sequenceComponents(this.slNode, sideMap.get((Object)PortSide.SOUTH), PortSide.SOUTH);
            this.sequenceComponents(this.slNode, sideMap.get((Object)PortSide.EAST), PortSide.EAST);
            this.sequenceComponents(this.slNode, sideMap.get((Object)PortSide.WEST), PortSide.WEST);
        }
    }

    private void placeCornerLoops(Collection<SelfLoopComponent> cornerComponents) {
        ArrayList<SelfLoopComponent> leftTop = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> rightTop = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> leftBottom = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> rightBottom = new ArrayList<SelfLoopComponent>();
        for (SelfLoopComponent component : cornerComponents) {
            List<SelfLoopPort> ports = component.getPorts();
            this.rotatePorts(component);
            PortSide firstPortSide = ports.get(0).getPortSide();
            switch (firstPortSide) {
                case NORTH: {
                    rightTop.add(component);
                    break;
                }
                case EAST: {
                    rightBottom.add(component);
                    break;
                }
                case SOUTH: {
                    leftBottom.add(component);
                    break;
                }
                case WEST: {
                    leftTop.add(component);
                }
            }
        }
        this.stackCornerComponents(this.slNode, rightTop, PortSide.NORTH, PortSide.EAST);
        this.stackCornerComponents(this.slNode, rightBottom, PortSide.EAST, PortSide.SOUTH);
        this.stackCornerComponents(this.slNode, leftBottom, PortSide.SOUTH, PortSide.WEST);
        this.stackCornerComponents(this.slNode, leftTop, PortSide.WEST, PortSide.NORTH);
    }

    private void placeOpposingLoops(Collection<SelfLoopComponent> oppossingComponents) {
        ArrayList<SelfLoopComponent> northSouth = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> westEast = new ArrayList<SelfLoopComponent>();
        for (SelfLoopComponent component : oppossingComponents) {
            PortSide side1 = component.getPorts().get(0).getPortSide();
            switch (side1) {
                case NORTH: {
                    northSouth.add(component);
                    break;
                }
                case WEST: {
                    westEast.add(component);
                    break;
                }
                case SOUTH: {
                    northSouth.add(component);
                    break;
                }
                case EAST: {
                    westEast.add(component);
                }
            }
        }
        this.addOpposingComponents(northSouth);
        this.addOpposingComponents(westEast);
    }

    private void addOpposingComponents(Collection<SelfLoopComponent> oppossingComponents) {
        for (SelfLoopComponent component : oppossingComponents) {
            SelfLoopNodeSide eastSouthSide;
            SelfLoopNodeSide westNorthSide;
            List<SelfLoopPort> ports = component.getPorts();
            ports.sort(INCOMING_EDGE_PORT_COMPARATOR);
            Set<PortSide> sides = component.getPortSides();
            Iterator<PortSide> sidesIterator = sides.iterator();
            PortSide side1 = sidesIterator.next();
            PortSide side2 = sidesIterator.next();
            if (side1 == PortSide.NORTH || side2 == PortSide.NORTH) {
                westNorthSide = this.slNode.getNodeSide(PortSide.WEST);
                eastSouthSide = this.slNode.getNodeSide(PortSide.EAST);
            } else {
                westNorthSide = this.slNode.getNodeSide(PortSide.NORTH);
                eastSouthSide = this.slNode.getNodeSide(PortSide.SOUTH);
            }
            int westNorthNonLoops = this.nonLoopsPerSide.get(westNorthSide.getSide());
            int eastSouthNonLoops = this.nonLoopsPerSide.get(eastSouthSide.getSide());
            int portlevelWestNorth = westNorthSide.getMaximumPortLevel() + new HashSet<SelfLoopOpposingSegment>(westNorthSide.getOpposingSegments().values()).size();
            int portlevelEastSouth = eastSouthSide.getMaximumPortLevel() + new HashSet<SelfLoopOpposingSegment>(eastSouthSide.getOpposingSegments().values()).size();
            PortSide routeSide = westNorthNonLoops < eastSouthNonLoops ? westNorthSide.getSide() : (westNorthNonLoops > eastSouthNonLoops ? eastSouthSide.getSide() : (portlevelEastSouth <= portlevelWestNorth ? eastSouthSide.getSide() : westNorthSide.getSide()));
            while (ports.get(0).getPortSide() != routeSide.left()) {
                SelfLoopPort firstElementPort = ports.remove(0);
                ports.add(firstElementPort);
            }
            ArrayList<SelfLoopPort> firstSidePorts = new ArrayList<SelfLoopPort>();
            ArrayList<SelfLoopPort> secondSidePorts = new ArrayList<SelfLoopPort>();
            SelfLoopRoutingDirection direction = null;
            boolean startPortOnFirstSide = false;
            int i = 0;
            while (i < ports.size()) {
                SelfLoopPort port = ports.get(i);
                this.setDirection(port, i, ports.size());
                PortSide side = port.getLPort().getSide();
                port.setPortSide(side);
                if (port.getPortSide() == side1) {
                    firstSidePorts.add(port);
                } else {
                    secondSidePorts.add(port);
                }
                if (i == 0) {
                    direction = port.getDirection();
                    startPortOnFirstSide = port.getPortSide() == side1;
                }
                ++i;
            }
            if (direction == SelfLoopRoutingDirection.LEFT) {
                if (startPortOnFirstSide) {
                    this.slNode.prependPorts(firstSidePorts, side1);
                    this.slNode.appendPorts(secondSidePorts, side2);
                } else {
                    this.slNode.appendPorts(firstSidePorts, side1);
                    this.slNode.prependPorts(secondSidePorts, side2);
                }
            } else if (startPortOnFirstSide) {
                this.slNode.appendPorts(firstSidePorts, side1);
                this.slNode.prependPorts(secondSidePorts, side2);
            } else {
                this.slNode.prependPorts(firstSidePorts, side1);
                this.slNode.appendPorts(secondSidePorts, side2);
            }
            SelfLoopNodeSide routeSideRep = this.slNode.getNodeSide(routeSide);
            Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> segment = SelfLoopOpposingSegment.create(component, this.slNode);
            routeSideRep.getOpposingSegments().putAll(segment.get(routeSide));
        }
        ArrayList<SelfLoopPort> ports = new ArrayList<SelfLoopPort>();
        for (SelfLoopNodeSide side : this.slNode.getSides()) {
            ports.addAll(side.getPorts());
        }
    }

    private void placeThreeSidesLoop(Collection<SelfLoopComponent> threeSideComponents) {
        for (SelfLoopComponent component : threeSideComponents) {
            Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> segment;
            int type3;
            HashSet<PortSide> portSideValues = new HashSet<PortSide>(Arrays.asList(PortSide.values()));
            Set<PortSide> componentPortSides = component.getPortSides();
            portSideValues.remove(PortSide.UNDEFINED);
            portSideValues.removeAll(componentPortSides);
            PortSide freePortSide = (PortSide)portSideValues.iterator().next();
            List<SelfLoopPort> ports = component.getPorts();
            ports.sort(new Comparator<SelfLoopPort>(){

                @Override
                public int compare(SelfLoopPort o1, SelfLoopPort o2) {
                    return Integer.compare(o1.getPortSide().ordinal(), o2.getPortSide().ordinal());
                }
            });
            while (ports.get(0).getPortSide() != freePortSide.right()) {
                SelfLoopPort firstElementPort = ports.remove(0);
                ports.add(firstElementPort);
            }
            PortSide firstPortSide = ports.get(0).getPortSide();
            PortSide lastPortSide = ports.get(ports.size() - 1).getPortSide();
            PortSide middleSide = firstPortSide.right();
            PortSide middleOpposingSide = middleSide.right().right();
            int middleSideNonLoops = this.nonLoopsPerSide.get(middleSide);
            int middleOpposingSideNonLoops = this.nonLoopsPerSide.get(middleOpposingSide);
            int firstSideNonLoops = this.nonLoopsPerSide.get(firstPortSide);
            int lastSideNonLoops = this.nonLoopsPerSide.get(lastPortSide);
            int type2 = lastSideNonLoops + middleOpposingSideNonLoops;
            int minimum = Math.min(middleSideNonLoops, Math.min(type2, type3 = firstSideNonLoops + middleOpposingSideNonLoops));
            if (minimum == middleSideNonLoops) {
                this.updateSideAndDirection(ports);
                Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> segment2 = SelfLoopOpposingSegment.create(component, this.slNode);
                this.slNode.getNodeSide(middleSide).getOpposingSegments().putAll(segment2.get(middleSide));
                continue;
            }
            if (minimum == type2) {
                SelfLoopPort firstElementPort = ports.remove(0);
                ports.add(firstElementPort);
                this.updateSideAndDirection(ports);
                segment = SelfLoopOpposingSegment.create(component, this.slNode);
                this.slNode.getNodeSide(lastPortSide).getOpposingSegments().putAll(segment.get(lastPortSide));
                this.slNode.getNodeSide(middleOpposingSide).getOpposingSegments().putAll(segment.get(middleOpposingSide));
                continue;
            }
            SelfLoopPort lastElementPort = ports.remove(ports.size() - 1);
            ports.add(0, lastElementPort);
            this.updateSideAndDirection(ports);
            segment = SelfLoopOpposingSegment.create(component, this.slNode);
            this.slNode.getNodeSide(firstPortSide).getOpposingSegments().putAll(segment.get(firstPortSide));
            this.slNode.getNodeSide(middleOpposingSide).getOpposingSegments().putAll(segment.get(middleOpposingSide));
        }
    }

    private void updateSideAndDirection(List<SelfLoopPort> ports) {
        int i = 0;
        while (i < ports.size()) {
            SelfLoopPort port = ports.get(i);
            this.setDirection(port, i, ports.size());
            PortSide side = port.getLPort().getSide();
            port.setPortSide(side);
            if (port.getDirection() == SelfLoopRoutingDirection.LEFT) {
                this.slNode.prependPort(port, side);
            } else {
                this.slNode.appendPort(port, side);
            }
            ++i;
        }
    }

    private void placeFourSidesLoop(Collection<SelfLoopComponent> fourSideComponents) {
        for (SelfLoopComponent component : fourSideComponents) {
            List<SelfLoopPort> ports = component.getPorts();
            ports.sort(new Comparator<SelfLoopPort>(){

                @Override
                public int compare(SelfLoopPort o1, SelfLoopPort o2) {
                    return Integer.compare(o1.getPortSide().ordinal(), o2.getPortSide().ordinal());
                }
            });
            int northSide = this.nonLoopsPerSide.get(PortSide.NORTH);
            int eastSide = this.nonLoopsPerSide.get(PortSide.EAST);
            int southSide = this.nonLoopsPerSide.get(PortSide.SOUTH);
            int westSide = this.nonLoopsPerSide.get(PortSide.WEST);
            int northEast = northSide + eastSide;
            int eastSouth = eastSide + southSide;
            int soutWest = southSide + westSide;
            int westNorth = westSide + northSide;
            int maximum = Math.max(northEast, Math.max(eastSouth, Math.max(soutWest, westNorth)));
            PortSide startSide = null;
            if (maximum == northEast) {
                startSide = PortSide.EAST;
            } else if (maximum == eastSouth) {
                startSide = PortSide.SOUTH;
            } else if (maximum == soutWest) {
                startSide = PortSide.WEST;
            } else if (maximum == westNorth) {
                startSide = PortSide.NORTH;
            }
            PortSide firstOpposingSide = startSide.right();
            PortSide secondOpposingSide = startSide.right().right();
            while (ports.get(0).getPortSide() != startSide) {
                SelfLoopPort firstElementPort = ports.remove(0);
                ports.add(firstElementPort);
            }
            this.updateSideAndDirection(ports);
            Map<PortSide, Map<SelfLoopEdge, SelfLoopOpposingSegment>> segment = SelfLoopOpposingSegment.create(component, this.slNode);
            this.slNode.getNodeSide(firstOpposingSide).getOpposingSegments().putAll(segment.get(firstOpposingSide));
            this.slNode.getNodeSide(secondOpposingSide).getOpposingSegments().putAll(segment.get(secondOpposingSide));
        }
    }

    private void placeNonLoops(Collection<SelfLoopComponent> nonLoopComponents) {
        ArrayList<SelfLoopComponent> nonLoopNorth = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> nonLoopSouth = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> nonLoopWest = new ArrayList<SelfLoopComponent>();
        ArrayList<SelfLoopComponent> nonLoopEast = new ArrayList<SelfLoopComponent>();
        for (SelfLoopComponent component : nonLoopComponents) {
            SelfLoopPort port = component.getPorts().get(0);
            switch (port.getPortSide()) {
                case NORTH: {
                    nonLoopNorth.add(component);
                    break;
                }
                case SOUTH: {
                    nonLoopSouth.add(component);
                    break;
                }
                case EAST: {
                    nonLoopEast.add(component);
                    break;
                }
                case WEST: {
                    nonLoopWest.add(component);
                    break;
                }
                default: {
                    nonLoopEast.add(component);
                }
            }
        }
        this.nonLoopsPerSide.put(PortSide.NORTH, nonLoopNorth.size());
        this.nonLoopsPerSide.put(PortSide.SOUTH, nonLoopSouth.size());
        this.nonLoopsPerSide.put(PortSide.WEST, nonLoopWest.size());
        this.nonLoopsPerSide.put(PortSide.EAST, nonLoopEast.size());
        this.placeNonLoopPorts(this.slNode, PortSide.NORTH, nonLoopNorth);
        this.placeNonLoopPorts(this.slNode, PortSide.SOUTH, nonLoopSouth);
        this.placeNonLoopPorts(this.slNode, PortSide.WEST, nonLoopWest);
        this.placeNonLoopPorts(this.slNode, PortSide.EAST, nonLoopEast);
    }
}

