/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.routing;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.AbstractSelfLoopRouter;
import org.eclipse.elk.alg.layered.p5edges.splines.NubsSelfLoop;
import org.eclipse.elk.core.math.KVector;

public class SplineSelfLoopRouter
extends AbstractSelfLoopRouter {
    private static final double DISTANCE = 10.0;

    @Override
    public void routeSideSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopPort source = slEdge.getSource();
        LPort sourceLPort = lEdge.getSource();
        LPort targetLPort = lEdge.getTarget();
        int order = slEdge.getEdgeOrders().get(source.getPortSide());
        int connectedEdges = Iterables.size(source.getConnectedEdges());
        int splineLevel = source.getEdgeLevel(lEdge) - connectedEdges + order;
        NubsSelfLoop nubs = NubsSelfLoop.createSideSelfLoop(sourceLPort, targetLPort, 10.0 * (double)splineLevel + source.getOtherEdgeOffset());
        slEdge.getEdge().getBendPoints().addAll((Collection)nubs.getBezierCP());
    }

    @Override
    public void routeCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        SelfLoopPort source = slEdge.getSource();
        SelfLoopPort target = slEdge.getTarget();
        LPort sourceLPort = lEdge.getSource();
        LPort targetLPort = lEdge.getTarget();
        int orderSource = slEdge.getEdgeOrders().get(source.getPortSide());
        int connectedEdgesSource = Iterables.size(source.getConnectedEdges());
        int splineLevelSource = source.getEdgeLevel(lEdge) - connectedEdgesSource + orderSource;
        int orderTarget = slEdge.getEdgeOrders().get(target.getPortSide());
        int connectedEdgesTarget = Iterables.size(target.getConnectedEdges());
        int splineLevelTarget = target.getEdgeLevel(lEdge) - connectedEdgesTarget + orderTarget;
        NubsSelfLoop nubs = NubsSelfLoop.createCornerSelfLoop(sourceLPort, targetLPort, 10.0 * (double)splineLevelSource + source.getOtherEdgeOffset(), 10.0 * (double)splineLevelTarget + target.getOtherEdgeOffset());
        slEdge.getEdge().getBendPoints().addAll((Collection)nubs.getBezierCP());
    }

    @Override
    public void routeOpposingSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        LPort sourceLPort = lEdge.getSource();
        LPort targetLPort = lEdge.getTarget();
        SelfLoopNode slNode = (SelfLoopNode)sourceLPort.getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge, false);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge, false);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        NubsSelfLoop nubs = NubsSelfLoop.createAcrossSelfLoop(sourceLPort, targetLPort, sourceBendPoint, cornerBendPoints, targetBendPoint);
        lEdge.getBendPoints().addAll((Collection)nubs.getBezierCP());
    }

    @Override
    public void routeThreeCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        LPort sourceLPort = lEdge.getSource();
        LPort targetLPort = lEdge.getTarget();
        SelfLoopNode slNode = (SelfLoopNode)sourceLPort.getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge, false);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge, false);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        NubsSelfLoop nubs = NubsSelfLoop.createThreeSideSelfLoop(sourceLPort, targetLPort, sourceBendPoint, cornerBendPoints, targetBendPoint);
        lEdge.getBendPoints().addAll((Collection)nubs.getBezierCP());
    }

    @Override
    public void routeFourCornerSelfLoop(SelfLoopEdge slEdge) {
        LEdge lEdge = slEdge.getEdge();
        LPort sourceLPort = lEdge.getSource();
        LPort targetLPort = lEdge.getTarget();
        SelfLoopNode slNode = (SelfLoopNode)sourceLPort.getNode().getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        KVector sourceBendPoint = this.computeSourceBendPoint(slEdge, false);
        KVector targetBendPoint = this.computeTargetBendPoint(slEdge, false);
        List<KVector> cornerBendPoints = this.computeCornerBendpoints(slNode, slEdge, sourceBendPoint, targetBendPoint);
        NubsSelfLoop nubs = NubsSelfLoop.createFourSideSelfLoop(sourceLPort, targetLPort, sourceBendPoint, cornerBendPoints, targetBendPoint);
        lEdge.getBendPoints().addAll((Collection)nubs.getBezierCP());
    }
}

